/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.monitor.application;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.monitor.application.ServerStatus;

@AvroGenerated
public class ApplicationServerStatus
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -6772410435210655145L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ApplicationServerStatus\",\"namespace\":\"org.radarcns.monitor.application\",\"doc\":\"Server connection status with android client.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"serverStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ServerStatus\",\"doc\":\"Server connection status.\",\"symbols\":[\"CONNECTED\",\"DISCONNECTED\",\"UNKNOWN\"]},\"doc\":\"Application server connection status.\",\"default\":\"UNKNOWN\"},{\"name\":\"ipAddress\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Hardware identifier of client application.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<ApplicationServerStatus> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<ApplicationServerStatus> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private ServerStatus serverStatus;
    private String ipAddress;
    private static final DatumWriter<ApplicationServerStatus> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<ApplicationServerStatus> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<ApplicationServerStatus> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<ApplicationServerStatus> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<ApplicationServerStatus> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static ApplicationServerStatus fromByteBuffer(ByteBuffer b) throws IOException {
        return (ApplicationServerStatus)((Object)DECODER.decode(b));
    }

    public ApplicationServerStatus() {
    }

    public ApplicationServerStatus(Double time, ServerStatus serverStatus, String ipAddress) {
        this.time = time;
        this.serverStatus = serverStatus;
        this.ipAddress = ipAddress;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.serverStatus;
            }
            case 2: {
                return this.ipAddress;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.serverStatus = (ServerStatus)((Object)value$);
                break;
            }
            case 2: {
                this.ipAddress = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(ServerStatus value) {
        this.serverStatus = value;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String value) {
        this.ipAddress = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(ApplicationServerStatus other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeEnum(this.serverStatus.ordinal());
        if (this.ipAddress == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.ipAddress);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.serverStatus = ServerStatus.values()[in.readEnum()];
            if (in.readIndex() != 1) {
                in.readNull();
                this.ipAddress = null;
            } else {
                this.ipAddress = in.readString();
            }
        } else {
            block5: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block5;
                    }
                    case 1: {
                        this.serverStatus = ServerStatus.values()[in.readEnum()];
                        continue block5;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.ipAddress = null;
                            continue block5;
                        }
                        this.ipAddress = in.readString();
                        continue block5;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<ApplicationServerStatus>
    implements RecordBuilder<ApplicationServerStatus> {
        private double time;
        private ServerStatus serverStatus;
        private String ipAddress;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.serverStatus))) {
                this.serverStatus = (ServerStatus)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.serverStatus));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.ipAddress)) {
                this.ipAddress = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.ipAddress);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(ApplicationServerStatus other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.serverStatus))) {
                this.serverStatus = (ServerStatus)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.serverStatus));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.ipAddress)) {
                this.ipAddress = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.ipAddress);
                this.fieldSetFlags()[2] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public ServerStatus getServerStatus() {
            return this.serverStatus;
        }

        public Builder setServerStatus(ServerStatus value) {
            this.validate(this.fields()[1], (Object)value);
            this.serverStatus = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasServerStatus() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearServerStatus() {
            this.serverStatus = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public Builder setIpAddress(String value) {
            this.validate(this.fields()[2], value);
            this.ipAddress = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasIpAddress() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearIpAddress() {
            this.ipAddress = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public ApplicationServerStatus build() {
            try {
                ApplicationServerStatus record = new ApplicationServerStatus();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.serverStatus = this.fieldSetFlags()[1] ? this.serverStatus : (ServerStatus)((Object)this.defaultValue(this.fields()[1]));
                record.ipAddress = this.fieldSetFlags()[2] ? this.ipAddress : (String)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

