/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.biovotion;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class BiovotionVsm1BloodPulseWave
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1274120569967938731L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"BiovotionVsm1BloodPulseWave\",\"namespace\":\"org.radarcns.passive.biovotion\",\"doc\":\"Blood pulse wave data calculated by biovotion device.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"bloodPulseWave\",\"type\":\"float\",\"doc\":\"Blood pulse wave value (nondimensional).\"},{\"name\":\"bloodPulseWaveQuality\",\"type\":\"float\",\"doc\":\"Blood pulse wave quality (0-1).\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<BiovotionVsm1BloodPulseWave> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<BiovotionVsm1BloodPulseWave> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float bloodPulseWave;
    private float bloodPulseWaveQuality;
    private static final DatumWriter<BiovotionVsm1BloodPulseWave> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<BiovotionVsm1BloodPulseWave> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<BiovotionVsm1BloodPulseWave> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<BiovotionVsm1BloodPulseWave> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<BiovotionVsm1BloodPulseWave> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static BiovotionVsm1BloodPulseWave fromByteBuffer(ByteBuffer b) throws IOException {
        return (BiovotionVsm1BloodPulseWave)((Object)DECODER.decode(b));
    }

    public BiovotionVsm1BloodPulseWave() {
    }

    public BiovotionVsm1BloodPulseWave(Double time, Double timeReceived, Float bloodPulseWave, Float bloodPulseWaveQuality) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.bloodPulseWave = bloodPulseWave.floatValue();
        this.bloodPulseWaveQuality = bloodPulseWaveQuality.floatValue();
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.bloodPulseWave);
            }
            case 3: {
                return Float.valueOf(this.bloodPulseWaveQuality);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.bloodPulseWave = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.bloodPulseWaveQuality = ((Float)value$).floatValue();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getBloodPulseWave() {
        return this.bloodPulseWave;
    }

    public void setBloodPulseWave(float value) {
        this.bloodPulseWave = value;
    }

    public float getBloodPulseWaveQuality() {
        return this.bloodPulseWaveQuality;
    }

    public void setBloodPulseWaveQuality(float value) {
        this.bloodPulseWaveQuality = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(BiovotionVsm1BloodPulseWave other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.bloodPulseWave);
        out.writeFloat(this.bloodPulseWaveQuality);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.bloodPulseWave = in.readFloat();
            this.bloodPulseWaveQuality = in.readFloat();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.bloodPulseWave = in.readFloat();
                        continue block6;
                    }
                    case 3: {
                        this.bloodPulseWaveQuality = in.readFloat();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<BiovotionVsm1BloodPulseWave>
    implements RecordBuilder<BiovotionVsm1BloodPulseWave> {
        private double time;
        private double timeReceived;
        private float bloodPulseWave;
        private float bloodPulseWaveQuality;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.bloodPulseWave))) {
                this.bloodPulseWave = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.bloodPulseWave))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.bloodPulseWaveQuality))) {
                this.bloodPulseWaveQuality = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.bloodPulseWaveQuality))).floatValue();
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(BiovotionVsm1BloodPulseWave other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.bloodPulseWave))) {
                this.bloodPulseWave = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.bloodPulseWave))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)Float.valueOf(other.bloodPulseWaveQuality))) {
                this.bloodPulseWaveQuality = ((Float)this.data().deepCopy(this.fields()[3].schema(), (Object)Float.valueOf(other.bloodPulseWaveQuality))).floatValue();
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getBloodPulseWave() {
            return this.bloodPulseWave;
        }

        public Builder setBloodPulseWave(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.bloodPulseWave = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasBloodPulseWave() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearBloodPulseWave() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public float getBloodPulseWaveQuality() {
            return this.bloodPulseWaveQuality;
        }

        public Builder setBloodPulseWaveQuality(float value) {
            this.validate(this.fields()[3], Float.valueOf(value));
            this.bloodPulseWaveQuality = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasBloodPulseWaveQuality() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearBloodPulseWaveQuality() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public BiovotionVsm1BloodPulseWave build() {
            try {
                BiovotionVsm1BloodPulseWave record = new BiovotionVsm1BloodPulseWave();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.bloodPulseWave = this.fieldSetFlags()[2] ? this.bloodPulseWave : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                record.bloodPulseWaveQuality = this.fieldSetFlags()[3] ? this.bloodPulseWaveQuality : ((Float)this.defaultValue(this.fields()[3])).floatValue();
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

