/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.dreem;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.dreem.DreemMetric;

@AvroGenerated
public class DreemSleepEndpoints
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -2897108149358318951L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"DreemSleepEndpoints\",\"namespace\":\"org.radarcns.passive.dreem\",\"doc\":\"AVRO Schema for DREEM sleep endpoints. These are statistics (metrics) calculated from DREEM Hypnogram.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"This refers to the recDateTime field from the dataset.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"This is the processing time in UTC (s).\"},{\"name\":\"offHead\",\"type\":\"float\",\"doc\":\"Percentage of the total recording time TRT during which the headband was on head.\"},{\"name\":\"totalRecordingTime\",\"type\":{\"type\":\"record\",\"name\":\"DreemMetric\",\"doc\":\"Single computed Dreem endpoint Metric.\",\"fields\":[{\"name\":\"value\",\"type\":[\"null\",\"float\"],\"doc\":\"Value associated with the endpoint. Format: XX.XX .\",\"default\":null},{\"name\":\"confidenceIndex\",\"type\":[\"null\",\"float\"],\"doc\":\"Confidence index associated to the endpoint value (only for TST, SE, SOL, WASO, N1, N2, N3, REM, NREM, p_N1, p_N2, p_N3, p_REM). If not computed \u2018NA\u2019 but for schema purposes it is set to null.\",\"default\":null}]},\"doc\":\"TRT stands for Total Recording Time. Unit is min. It is amount of time from record start to record stop.\"},{\"name\":\"totalSleepTime\",\"type\":\"DreemMetric\",\"doc\":\"TST stands for Total Sleep Time. Unit is min. It is amount of sleep from record start to record stop.\"},{\"name\":\"sleepEfficiency\",\"type\":\"DreemMetric\",\"doc\":\"SE stands for Sleep Efficiency. Unit is %. It is portion of the TRT spent asleep.\"},{\"name\":\"sleepOnsetLatency\",\"type\":\"DreemMetric\",\"doc\":\"SOL stands for Sleep Onset Latency. Unit is min. Time from 'Lights out' to unequivocal sleep onset (first of three consecutive N1 sleep epochs, or any non-N1 sleep stage).\"},{\"name\":\"latencyPersistentSleep\",\"type\":\"DreemMetric\",\"doc\":\"LPS stands for Latency to Persistent Sleep. Unit is min. Time from 'Lights out' to the first epoch of persistent sleep (persistent sleep defined as the first epoch of 10 min of persistent sleep).\"},{\"name\":\"wakeAfterSleepOnset\",\"type\":\"DreemMetric\",\"doc\":\"WASO stands for Wake After Sleep Onset. Unit is min. It is wakefulness between SO and final epoch of sleep.\"},{\"name\":\"rapidEyeMovementLatency\",\"type\":\"DreemMetric\",\"doc\":\"RL stands for REM Latency. Unit is min. It is SO to first epoch of REM sleep.\"},{\"name\":\"nonRapidEyeMovement\",\"type\":\"DreemMetric\",\"doc\":\"NREM stands for Total Sleep Non-REM Sleep. Unit is min. It is N1 + N2 + N3.\"},{\"name\":\"nonRapidEyeMovement1Duration\",\"type\":\"DreemMetric\",\"doc\":\"N1 stands for NREM 1 duration. Unit is min. It is minutes of N1 sleep.\"},{\"name\":\"nonRapidEyeMovement2Duration\",\"type\":\"DreemMetric\",\"doc\":\"N2 stands for NREM 2 duration. Unit is min. It is minutes of N2 sleep.\"},{\"name\":\"nonRapidEyeMovement3Duration\",\"type\":\"DreemMetric\",\"doc\":\"N3 stands for NREM 3 duration. Unit is min. It is minutes of N3 sleep.\"},{\"name\":\"totalRapidEyeMovementSleepDuration\",\"type\":\"DreemMetric\",\"doc\":\"REM stands for Total Rapid Eye Movement Sleep duration. Unit is min. It is minutes of REM sleep.\"},{\"name\":\"totalSleepTimeSpentInNonRapidEyeMovement1Sleep\",\"type\":\"DreemMetric\",\"doc\":\"The p_N1 stands for percentage Stage N1 Sleep. Unit is %. It is percentage of TST spent in N1 sleep.\"},{\"name\":\"totalSleepTimeSpentInNonRapidEyeMovement2Sleep\",\"type\":\"DreemMetric\",\"doc\":\"The p_N2 stands for percentage Stage N2 Sleep. Unit is %. It is percentage of TST spent in N2 sleep.\"},{\"name\":\"totalSleepTimeSpentInNonRapidEyeMovement3Sleep\",\"type\":\"DreemMetric\",\"doc\":\"The p_N3 stands for percentage Stage N3 Sleep. Unit is %. It is percentage of TST spent in N3 sleep.\"},{\"name\":\"totalSleepTimeSpentInRapidEyeMovementSleep\",\"type\":\"DreemMetric\",\"doc\":\"The p_REM stands for Percentage Stage REM Sleep. Unit is %. It is percentage of TST spent in REM sleep.\"},{\"name\":\"totalSleepTimeSpentInNonRapidEyeMovementSleep\",\"type\":\"DreemMetric\",\"doc\":\"The p_NREM stands for Total Sleep NREM Sleep/ Total Sleep Time. Unit is %. It is percentage of TST spent in NREM sleep (N1 + N2 + N3).\"},{\"name\":\"meanRespiratoryRate\",\"type\":\"DreemMetric\",\"doc\":\"RR stands for Mean Respiratory rate. Unit is BPM. Is is average number of breaths per minute through the recording.\"},{\"name\":\"respiratoryRateDuringNonRapidEyeMovement1Duration\",\"type\":\"DreemMetric\",\"doc\":\"RRN1 stands for respiratory rate during N1. Unit is BPM. It is average number of breaths per minute in N1 sleep.\"},{\"name\":\"respiratoryRateDuringNonRapidEyeMovement2Duration\",\"type\":\"DreemMetric\",\"doc\":\"RRN2 stands for respiratory rate during N2. Unit is BPM. It is average number of breaths per minute in N2 sleep.\"},{\"name\":\"respiratoryRateDuringNonRapidEyeMovement3Duration\",\"type\":\"DreemMetric\",\"doc\":\"RRN3 stands for respiratory rate during N3. Unit is BPM. It is average number of breaths per minute in N3 sleep.\"},{\"name\":\"recordingQuality\",\"type\":\"DreemMetric\",\"doc\":\"QUAL stands for recording quality. Unit is %. It is proportion of recording that is unequivocally scorable by a sleep expert.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<DreemSleepEndpoints> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<DreemSleepEndpoints> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private float offHead;
    private DreemMetric totalRecordingTime;
    private DreemMetric totalSleepTime;
    private DreemMetric sleepEfficiency;
    private DreemMetric sleepOnsetLatency;
    private DreemMetric latencyPersistentSleep;
    private DreemMetric wakeAfterSleepOnset;
    private DreemMetric rapidEyeMovementLatency;
    private DreemMetric nonRapidEyeMovement;
    private DreemMetric nonRapidEyeMovement1Duration;
    private DreemMetric nonRapidEyeMovement2Duration;
    private DreemMetric nonRapidEyeMovement3Duration;
    private DreemMetric totalRapidEyeMovementSleepDuration;
    private DreemMetric totalSleepTimeSpentInNonRapidEyeMovement1Sleep;
    private DreemMetric totalSleepTimeSpentInNonRapidEyeMovement2Sleep;
    private DreemMetric totalSleepTimeSpentInNonRapidEyeMovement3Sleep;
    private DreemMetric totalSleepTimeSpentInRapidEyeMovementSleep;
    private DreemMetric totalSleepTimeSpentInNonRapidEyeMovementSleep;
    private DreemMetric meanRespiratoryRate;
    private DreemMetric respiratoryRateDuringNonRapidEyeMovement1Duration;
    private DreemMetric respiratoryRateDuringNonRapidEyeMovement2Duration;
    private DreemMetric respiratoryRateDuringNonRapidEyeMovement3Duration;
    private DreemMetric recordingQuality;
    private static final DatumWriter<DreemSleepEndpoints> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<DreemSleepEndpoints> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<DreemSleepEndpoints> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<DreemSleepEndpoints> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<DreemSleepEndpoints> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static DreemSleepEndpoints fromByteBuffer(ByteBuffer b) throws IOException {
        return (DreemSleepEndpoints)((Object)DECODER.decode(b));
    }

    public DreemSleepEndpoints() {
    }

    public DreemSleepEndpoints(Double time, Double timeReceived, Float offHead, DreemMetric totalRecordingTime, DreemMetric totalSleepTime, DreemMetric sleepEfficiency, DreemMetric sleepOnsetLatency, DreemMetric latencyPersistentSleep, DreemMetric wakeAfterSleepOnset, DreemMetric rapidEyeMovementLatency, DreemMetric nonRapidEyeMovement, DreemMetric nonRapidEyeMovement1Duration, DreemMetric nonRapidEyeMovement2Duration, DreemMetric nonRapidEyeMovement3Duration, DreemMetric totalRapidEyeMovementSleepDuration, DreemMetric totalSleepTimeSpentInNonRapidEyeMovement1Sleep, DreemMetric totalSleepTimeSpentInNonRapidEyeMovement2Sleep, DreemMetric totalSleepTimeSpentInNonRapidEyeMovement3Sleep, DreemMetric totalSleepTimeSpentInRapidEyeMovementSleep, DreemMetric totalSleepTimeSpentInNonRapidEyeMovementSleep, DreemMetric meanRespiratoryRate, DreemMetric respiratoryRateDuringNonRapidEyeMovement1Duration, DreemMetric respiratoryRateDuringNonRapidEyeMovement2Duration, DreemMetric respiratoryRateDuringNonRapidEyeMovement3Duration, DreemMetric recordingQuality) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.offHead = offHead.floatValue();
        this.totalRecordingTime = totalRecordingTime;
        this.totalSleepTime = totalSleepTime;
        this.sleepEfficiency = sleepEfficiency;
        this.sleepOnsetLatency = sleepOnsetLatency;
        this.latencyPersistentSleep = latencyPersistentSleep;
        this.wakeAfterSleepOnset = wakeAfterSleepOnset;
        this.rapidEyeMovementLatency = rapidEyeMovementLatency;
        this.nonRapidEyeMovement = nonRapidEyeMovement;
        this.nonRapidEyeMovement1Duration = nonRapidEyeMovement1Duration;
        this.nonRapidEyeMovement2Duration = nonRapidEyeMovement2Duration;
        this.nonRapidEyeMovement3Duration = nonRapidEyeMovement3Duration;
        this.totalRapidEyeMovementSleepDuration = totalRapidEyeMovementSleepDuration;
        this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = totalSleepTimeSpentInNonRapidEyeMovement1Sleep;
        this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = totalSleepTimeSpentInNonRapidEyeMovement2Sleep;
        this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = totalSleepTimeSpentInNonRapidEyeMovement3Sleep;
        this.totalSleepTimeSpentInRapidEyeMovementSleep = totalSleepTimeSpentInRapidEyeMovementSleep;
        this.totalSleepTimeSpentInNonRapidEyeMovementSleep = totalSleepTimeSpentInNonRapidEyeMovementSleep;
        this.meanRespiratoryRate = meanRespiratoryRate;
        this.respiratoryRateDuringNonRapidEyeMovement1Duration = respiratoryRateDuringNonRapidEyeMovement1Duration;
        this.respiratoryRateDuringNonRapidEyeMovement2Duration = respiratoryRateDuringNonRapidEyeMovement2Duration;
        this.respiratoryRateDuringNonRapidEyeMovement3Duration = respiratoryRateDuringNonRapidEyeMovement3Duration;
        this.recordingQuality = recordingQuality;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return Float.valueOf(this.offHead);
            }
            case 3: {
                return this.totalRecordingTime;
            }
            case 4: {
                return this.totalSleepTime;
            }
            case 5: {
                return this.sleepEfficiency;
            }
            case 6: {
                return this.sleepOnsetLatency;
            }
            case 7: {
                return this.latencyPersistentSleep;
            }
            case 8: {
                return this.wakeAfterSleepOnset;
            }
            case 9: {
                return this.rapidEyeMovementLatency;
            }
            case 10: {
                return this.nonRapidEyeMovement;
            }
            case 11: {
                return this.nonRapidEyeMovement1Duration;
            }
            case 12: {
                return this.nonRapidEyeMovement2Duration;
            }
            case 13: {
                return this.nonRapidEyeMovement3Duration;
            }
            case 14: {
                return this.totalRapidEyeMovementSleepDuration;
            }
            case 15: {
                return this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep;
            }
            case 16: {
                return this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep;
            }
            case 17: {
                return this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep;
            }
            case 18: {
                return this.totalSleepTimeSpentInRapidEyeMovementSleep;
            }
            case 19: {
                return this.totalSleepTimeSpentInNonRapidEyeMovementSleep;
            }
            case 20: {
                return this.meanRespiratoryRate;
            }
            case 21: {
                return this.respiratoryRateDuringNonRapidEyeMovement1Duration;
            }
            case 22: {
                return this.respiratoryRateDuringNonRapidEyeMovement2Duration;
            }
            case 23: {
                return this.respiratoryRateDuringNonRapidEyeMovement3Duration;
            }
            case 24: {
                return this.recordingQuality;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.offHead = ((Float)value$).floatValue();
                break;
            }
            case 3: {
                this.totalRecordingTime = (DreemMetric)((Object)value$);
                break;
            }
            case 4: {
                this.totalSleepTime = (DreemMetric)((Object)value$);
                break;
            }
            case 5: {
                this.sleepEfficiency = (DreemMetric)((Object)value$);
                break;
            }
            case 6: {
                this.sleepOnsetLatency = (DreemMetric)((Object)value$);
                break;
            }
            case 7: {
                this.latencyPersistentSleep = (DreemMetric)((Object)value$);
                break;
            }
            case 8: {
                this.wakeAfterSleepOnset = (DreemMetric)((Object)value$);
                break;
            }
            case 9: {
                this.rapidEyeMovementLatency = (DreemMetric)((Object)value$);
                break;
            }
            case 10: {
                this.nonRapidEyeMovement = (DreemMetric)((Object)value$);
                break;
            }
            case 11: {
                this.nonRapidEyeMovement1Duration = (DreemMetric)((Object)value$);
                break;
            }
            case 12: {
                this.nonRapidEyeMovement2Duration = (DreemMetric)((Object)value$);
                break;
            }
            case 13: {
                this.nonRapidEyeMovement3Duration = (DreemMetric)((Object)value$);
                break;
            }
            case 14: {
                this.totalRapidEyeMovementSleepDuration = (DreemMetric)((Object)value$);
                break;
            }
            case 15: {
                this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = (DreemMetric)((Object)value$);
                break;
            }
            case 16: {
                this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = (DreemMetric)((Object)value$);
                break;
            }
            case 17: {
                this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = (DreemMetric)((Object)value$);
                break;
            }
            case 18: {
                this.totalSleepTimeSpentInRapidEyeMovementSleep = (DreemMetric)((Object)value$);
                break;
            }
            case 19: {
                this.totalSleepTimeSpentInNonRapidEyeMovementSleep = (DreemMetric)((Object)value$);
                break;
            }
            case 20: {
                this.meanRespiratoryRate = (DreemMetric)((Object)value$);
                break;
            }
            case 21: {
                this.respiratoryRateDuringNonRapidEyeMovement1Duration = (DreemMetric)((Object)value$);
                break;
            }
            case 22: {
                this.respiratoryRateDuringNonRapidEyeMovement2Duration = (DreemMetric)((Object)value$);
                break;
            }
            case 23: {
                this.respiratoryRateDuringNonRapidEyeMovement3Duration = (DreemMetric)((Object)value$);
                break;
            }
            case 24: {
                this.recordingQuality = (DreemMetric)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public float getOffHead() {
        return this.offHead;
    }

    public void setOffHead(float value) {
        this.offHead = value;
    }

    public DreemMetric getTotalRecordingTime() {
        return this.totalRecordingTime;
    }

    public void setTotalRecordingTime(DreemMetric value) {
        this.totalRecordingTime = value;
    }

    public DreemMetric getTotalSleepTime() {
        return this.totalSleepTime;
    }

    public void setTotalSleepTime(DreemMetric value) {
        this.totalSleepTime = value;
    }

    public DreemMetric getSleepEfficiency() {
        return this.sleepEfficiency;
    }

    public void setSleepEfficiency(DreemMetric value) {
        this.sleepEfficiency = value;
    }

    public DreemMetric getSleepOnsetLatency() {
        return this.sleepOnsetLatency;
    }

    public void setSleepOnsetLatency(DreemMetric value) {
        this.sleepOnsetLatency = value;
    }

    public DreemMetric getLatencyPersistentSleep() {
        return this.latencyPersistentSleep;
    }

    public void setLatencyPersistentSleep(DreemMetric value) {
        this.latencyPersistentSleep = value;
    }

    public DreemMetric getWakeAfterSleepOnset() {
        return this.wakeAfterSleepOnset;
    }

    public void setWakeAfterSleepOnset(DreemMetric value) {
        this.wakeAfterSleepOnset = value;
    }

    public DreemMetric getRapidEyeMovementLatency() {
        return this.rapidEyeMovementLatency;
    }

    public void setRapidEyeMovementLatency(DreemMetric value) {
        this.rapidEyeMovementLatency = value;
    }

    public DreemMetric getNonRapidEyeMovement() {
        return this.nonRapidEyeMovement;
    }

    public void setNonRapidEyeMovement(DreemMetric value) {
        this.nonRapidEyeMovement = value;
    }

    public DreemMetric getNonRapidEyeMovement1Duration() {
        return this.nonRapidEyeMovement1Duration;
    }

    public void setNonRapidEyeMovement1Duration(DreemMetric value) {
        this.nonRapidEyeMovement1Duration = value;
    }

    public DreemMetric getNonRapidEyeMovement2Duration() {
        return this.nonRapidEyeMovement2Duration;
    }

    public void setNonRapidEyeMovement2Duration(DreemMetric value) {
        this.nonRapidEyeMovement2Duration = value;
    }

    public DreemMetric getNonRapidEyeMovement3Duration() {
        return this.nonRapidEyeMovement3Duration;
    }

    public void setNonRapidEyeMovement3Duration(DreemMetric value) {
        this.nonRapidEyeMovement3Duration = value;
    }

    public DreemMetric getTotalRapidEyeMovementSleepDuration() {
        return this.totalRapidEyeMovementSleepDuration;
    }

    public void setTotalRapidEyeMovementSleepDuration(DreemMetric value) {
        this.totalRapidEyeMovementSleepDuration = value;
    }

    public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovement1Sleep() {
        return this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep;
    }

    public void setTotalSleepTimeSpentInNonRapidEyeMovement1Sleep(DreemMetric value) {
        this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = value;
    }

    public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovement2Sleep() {
        return this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep;
    }

    public void setTotalSleepTimeSpentInNonRapidEyeMovement2Sleep(DreemMetric value) {
        this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = value;
    }

    public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovement3Sleep() {
        return this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep;
    }

    public void setTotalSleepTimeSpentInNonRapidEyeMovement3Sleep(DreemMetric value) {
        this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = value;
    }

    public DreemMetric getTotalSleepTimeSpentInRapidEyeMovementSleep() {
        return this.totalSleepTimeSpentInRapidEyeMovementSleep;
    }

    public void setTotalSleepTimeSpentInRapidEyeMovementSleep(DreemMetric value) {
        this.totalSleepTimeSpentInRapidEyeMovementSleep = value;
    }

    public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovementSleep() {
        return this.totalSleepTimeSpentInNonRapidEyeMovementSleep;
    }

    public void setTotalSleepTimeSpentInNonRapidEyeMovementSleep(DreemMetric value) {
        this.totalSleepTimeSpentInNonRapidEyeMovementSleep = value;
    }

    public DreemMetric getMeanRespiratoryRate() {
        return this.meanRespiratoryRate;
    }

    public void setMeanRespiratoryRate(DreemMetric value) {
        this.meanRespiratoryRate = value;
    }

    public DreemMetric getRespiratoryRateDuringNonRapidEyeMovement1Duration() {
        return this.respiratoryRateDuringNonRapidEyeMovement1Duration;
    }

    public void setRespiratoryRateDuringNonRapidEyeMovement1Duration(DreemMetric value) {
        this.respiratoryRateDuringNonRapidEyeMovement1Duration = value;
    }

    public DreemMetric getRespiratoryRateDuringNonRapidEyeMovement2Duration() {
        return this.respiratoryRateDuringNonRapidEyeMovement2Duration;
    }

    public void setRespiratoryRateDuringNonRapidEyeMovement2Duration(DreemMetric value) {
        this.respiratoryRateDuringNonRapidEyeMovement2Duration = value;
    }

    public DreemMetric getRespiratoryRateDuringNonRapidEyeMovement3Duration() {
        return this.respiratoryRateDuringNonRapidEyeMovement3Duration;
    }

    public void setRespiratoryRateDuringNonRapidEyeMovement3Duration(DreemMetric value) {
        this.respiratoryRateDuringNonRapidEyeMovement3Duration = value;
    }

    public DreemMetric getRecordingQuality() {
        return this.recordingQuality;
    }

    public void setRecordingQuality(DreemMetric value) {
        this.recordingQuality = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(DreemSleepEndpoints other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeFloat(this.offHead);
        this.totalRecordingTime.customEncode(out);
        this.totalSleepTime.customEncode(out);
        this.sleepEfficiency.customEncode(out);
        this.sleepOnsetLatency.customEncode(out);
        this.latencyPersistentSleep.customEncode(out);
        this.wakeAfterSleepOnset.customEncode(out);
        this.rapidEyeMovementLatency.customEncode(out);
        this.nonRapidEyeMovement.customEncode(out);
        this.nonRapidEyeMovement1Duration.customEncode(out);
        this.nonRapidEyeMovement2Duration.customEncode(out);
        this.nonRapidEyeMovement3Duration.customEncode(out);
        this.totalRapidEyeMovementSleepDuration.customEncode(out);
        this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep.customEncode(out);
        this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep.customEncode(out);
        this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep.customEncode(out);
        this.totalSleepTimeSpentInRapidEyeMovementSleep.customEncode(out);
        this.totalSleepTimeSpentInNonRapidEyeMovementSleep.customEncode(out);
        this.meanRespiratoryRate.customEncode(out);
        this.respiratoryRateDuringNonRapidEyeMovement1Duration.customEncode(out);
        this.respiratoryRateDuringNonRapidEyeMovement2Duration.customEncode(out);
        this.respiratoryRateDuringNonRapidEyeMovement3Duration.customEncode(out);
        this.recordingQuality.customEncode(out);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.offHead = in.readFloat();
            if (this.totalRecordingTime == null) {
                this.totalRecordingTime = new DreemMetric();
            }
            this.totalRecordingTime.customDecode(in);
            if (this.totalSleepTime == null) {
                this.totalSleepTime = new DreemMetric();
            }
            this.totalSleepTime.customDecode(in);
            if (this.sleepEfficiency == null) {
                this.sleepEfficiency = new DreemMetric();
            }
            this.sleepEfficiency.customDecode(in);
            if (this.sleepOnsetLatency == null) {
                this.sleepOnsetLatency = new DreemMetric();
            }
            this.sleepOnsetLatency.customDecode(in);
            if (this.latencyPersistentSleep == null) {
                this.latencyPersistentSleep = new DreemMetric();
            }
            this.latencyPersistentSleep.customDecode(in);
            if (this.wakeAfterSleepOnset == null) {
                this.wakeAfterSleepOnset = new DreemMetric();
            }
            this.wakeAfterSleepOnset.customDecode(in);
            if (this.rapidEyeMovementLatency == null) {
                this.rapidEyeMovementLatency = new DreemMetric();
            }
            this.rapidEyeMovementLatency.customDecode(in);
            if (this.nonRapidEyeMovement == null) {
                this.nonRapidEyeMovement = new DreemMetric();
            }
            this.nonRapidEyeMovement.customDecode(in);
            if (this.nonRapidEyeMovement1Duration == null) {
                this.nonRapidEyeMovement1Duration = new DreemMetric();
            }
            this.nonRapidEyeMovement1Duration.customDecode(in);
            if (this.nonRapidEyeMovement2Duration == null) {
                this.nonRapidEyeMovement2Duration = new DreemMetric();
            }
            this.nonRapidEyeMovement2Duration.customDecode(in);
            if (this.nonRapidEyeMovement3Duration == null) {
                this.nonRapidEyeMovement3Duration = new DreemMetric();
            }
            this.nonRapidEyeMovement3Duration.customDecode(in);
            if (this.totalRapidEyeMovementSleepDuration == null) {
                this.totalRapidEyeMovementSleepDuration = new DreemMetric();
            }
            this.totalRapidEyeMovementSleepDuration.customDecode(in);
            if (this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep == null) {
                this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = new DreemMetric();
            }
            this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep.customDecode(in);
            if (this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep == null) {
                this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = new DreemMetric();
            }
            this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep.customDecode(in);
            if (this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep == null) {
                this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = new DreemMetric();
            }
            this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep.customDecode(in);
            if (this.totalSleepTimeSpentInRapidEyeMovementSleep == null) {
                this.totalSleepTimeSpentInRapidEyeMovementSleep = new DreemMetric();
            }
            this.totalSleepTimeSpentInRapidEyeMovementSleep.customDecode(in);
            if (this.totalSleepTimeSpentInNonRapidEyeMovementSleep == null) {
                this.totalSleepTimeSpentInNonRapidEyeMovementSleep = new DreemMetric();
            }
            this.totalSleepTimeSpentInNonRapidEyeMovementSleep.customDecode(in);
            if (this.meanRespiratoryRate == null) {
                this.meanRespiratoryRate = new DreemMetric();
            }
            this.meanRespiratoryRate.customDecode(in);
            if (this.respiratoryRateDuringNonRapidEyeMovement1Duration == null) {
                this.respiratoryRateDuringNonRapidEyeMovement1Duration = new DreemMetric();
            }
            this.respiratoryRateDuringNonRapidEyeMovement1Duration.customDecode(in);
            if (this.respiratoryRateDuringNonRapidEyeMovement2Duration == null) {
                this.respiratoryRateDuringNonRapidEyeMovement2Duration = new DreemMetric();
            }
            this.respiratoryRateDuringNonRapidEyeMovement2Duration.customDecode(in);
            if (this.respiratoryRateDuringNonRapidEyeMovement3Duration == null) {
                this.respiratoryRateDuringNonRapidEyeMovement3Duration = new DreemMetric();
            }
            this.respiratoryRateDuringNonRapidEyeMovement3Duration.customDecode(in);
            if (this.recordingQuality == null) {
                this.recordingQuality = new DreemMetric();
            }
            this.recordingQuality.customDecode(in);
        } else {
            block27: for (int i = 0; i < 25; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block27;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block27;
                    }
                    case 2: {
                        this.offHead = in.readFloat();
                        continue block27;
                    }
                    case 3: {
                        if (this.totalRecordingTime == null) {
                            this.totalRecordingTime = new DreemMetric();
                        }
                        this.totalRecordingTime.customDecode(in);
                        continue block27;
                    }
                    case 4: {
                        if (this.totalSleepTime == null) {
                            this.totalSleepTime = new DreemMetric();
                        }
                        this.totalSleepTime.customDecode(in);
                        continue block27;
                    }
                    case 5: {
                        if (this.sleepEfficiency == null) {
                            this.sleepEfficiency = new DreemMetric();
                        }
                        this.sleepEfficiency.customDecode(in);
                        continue block27;
                    }
                    case 6: {
                        if (this.sleepOnsetLatency == null) {
                            this.sleepOnsetLatency = new DreemMetric();
                        }
                        this.sleepOnsetLatency.customDecode(in);
                        continue block27;
                    }
                    case 7: {
                        if (this.latencyPersistentSleep == null) {
                            this.latencyPersistentSleep = new DreemMetric();
                        }
                        this.latencyPersistentSleep.customDecode(in);
                        continue block27;
                    }
                    case 8: {
                        if (this.wakeAfterSleepOnset == null) {
                            this.wakeAfterSleepOnset = new DreemMetric();
                        }
                        this.wakeAfterSleepOnset.customDecode(in);
                        continue block27;
                    }
                    case 9: {
                        if (this.rapidEyeMovementLatency == null) {
                            this.rapidEyeMovementLatency = new DreemMetric();
                        }
                        this.rapidEyeMovementLatency.customDecode(in);
                        continue block27;
                    }
                    case 10: {
                        if (this.nonRapidEyeMovement == null) {
                            this.nonRapidEyeMovement = new DreemMetric();
                        }
                        this.nonRapidEyeMovement.customDecode(in);
                        continue block27;
                    }
                    case 11: {
                        if (this.nonRapidEyeMovement1Duration == null) {
                            this.nonRapidEyeMovement1Duration = new DreemMetric();
                        }
                        this.nonRapidEyeMovement1Duration.customDecode(in);
                        continue block27;
                    }
                    case 12: {
                        if (this.nonRapidEyeMovement2Duration == null) {
                            this.nonRapidEyeMovement2Duration = new DreemMetric();
                        }
                        this.nonRapidEyeMovement2Duration.customDecode(in);
                        continue block27;
                    }
                    case 13: {
                        if (this.nonRapidEyeMovement3Duration == null) {
                            this.nonRapidEyeMovement3Duration = new DreemMetric();
                        }
                        this.nonRapidEyeMovement3Duration.customDecode(in);
                        continue block27;
                    }
                    case 14: {
                        if (this.totalRapidEyeMovementSleepDuration == null) {
                            this.totalRapidEyeMovementSleepDuration = new DreemMetric();
                        }
                        this.totalRapidEyeMovementSleepDuration.customDecode(in);
                        continue block27;
                    }
                    case 15: {
                        if (this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep == null) {
                            this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = new DreemMetric();
                        }
                        this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep.customDecode(in);
                        continue block27;
                    }
                    case 16: {
                        if (this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep == null) {
                            this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = new DreemMetric();
                        }
                        this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep.customDecode(in);
                        continue block27;
                    }
                    case 17: {
                        if (this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep == null) {
                            this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = new DreemMetric();
                        }
                        this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep.customDecode(in);
                        continue block27;
                    }
                    case 18: {
                        if (this.totalSleepTimeSpentInRapidEyeMovementSleep == null) {
                            this.totalSleepTimeSpentInRapidEyeMovementSleep = new DreemMetric();
                        }
                        this.totalSleepTimeSpentInRapidEyeMovementSleep.customDecode(in);
                        continue block27;
                    }
                    case 19: {
                        if (this.totalSleepTimeSpentInNonRapidEyeMovementSleep == null) {
                            this.totalSleepTimeSpentInNonRapidEyeMovementSleep = new DreemMetric();
                        }
                        this.totalSleepTimeSpentInNonRapidEyeMovementSleep.customDecode(in);
                        continue block27;
                    }
                    case 20: {
                        if (this.meanRespiratoryRate == null) {
                            this.meanRespiratoryRate = new DreemMetric();
                        }
                        this.meanRespiratoryRate.customDecode(in);
                        continue block27;
                    }
                    case 21: {
                        if (this.respiratoryRateDuringNonRapidEyeMovement1Duration == null) {
                            this.respiratoryRateDuringNonRapidEyeMovement1Duration = new DreemMetric();
                        }
                        this.respiratoryRateDuringNonRapidEyeMovement1Duration.customDecode(in);
                        continue block27;
                    }
                    case 22: {
                        if (this.respiratoryRateDuringNonRapidEyeMovement2Duration == null) {
                            this.respiratoryRateDuringNonRapidEyeMovement2Duration = new DreemMetric();
                        }
                        this.respiratoryRateDuringNonRapidEyeMovement2Duration.customDecode(in);
                        continue block27;
                    }
                    case 23: {
                        if (this.respiratoryRateDuringNonRapidEyeMovement3Duration == null) {
                            this.respiratoryRateDuringNonRapidEyeMovement3Duration = new DreemMetric();
                        }
                        this.respiratoryRateDuringNonRapidEyeMovement3Duration.customDecode(in);
                        continue block27;
                    }
                    case 24: {
                        if (this.recordingQuality == null) {
                            this.recordingQuality = new DreemMetric();
                        }
                        this.recordingQuality.customDecode(in);
                        continue block27;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<DreemSleepEndpoints>
    implements RecordBuilder<DreemSleepEndpoints> {
        private double time;
        private double timeReceived;
        private float offHead;
        private DreemMetric totalRecordingTime;
        private DreemMetric.Builder totalRecordingTimeBuilder;
        private DreemMetric totalSleepTime;
        private DreemMetric.Builder totalSleepTimeBuilder;
        private DreemMetric sleepEfficiency;
        private DreemMetric.Builder sleepEfficiencyBuilder;
        private DreemMetric sleepOnsetLatency;
        private DreemMetric.Builder sleepOnsetLatencyBuilder;
        private DreemMetric latencyPersistentSleep;
        private DreemMetric.Builder latencyPersistentSleepBuilder;
        private DreemMetric wakeAfterSleepOnset;
        private DreemMetric.Builder wakeAfterSleepOnsetBuilder;
        private DreemMetric rapidEyeMovementLatency;
        private DreemMetric.Builder rapidEyeMovementLatencyBuilder;
        private DreemMetric nonRapidEyeMovement;
        private DreemMetric.Builder nonRapidEyeMovementBuilder;
        private DreemMetric nonRapidEyeMovement1Duration;
        private DreemMetric.Builder nonRapidEyeMovement1DurationBuilder;
        private DreemMetric nonRapidEyeMovement2Duration;
        private DreemMetric.Builder nonRapidEyeMovement2DurationBuilder;
        private DreemMetric nonRapidEyeMovement3Duration;
        private DreemMetric.Builder nonRapidEyeMovement3DurationBuilder;
        private DreemMetric totalRapidEyeMovementSleepDuration;
        private DreemMetric.Builder totalRapidEyeMovementSleepDurationBuilder;
        private DreemMetric totalSleepTimeSpentInNonRapidEyeMovement1Sleep;
        private DreemMetric.Builder totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder;
        private DreemMetric totalSleepTimeSpentInNonRapidEyeMovement2Sleep;
        private DreemMetric.Builder totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder;
        private DreemMetric totalSleepTimeSpentInNonRapidEyeMovement3Sleep;
        private DreemMetric.Builder totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder;
        private DreemMetric totalSleepTimeSpentInRapidEyeMovementSleep;
        private DreemMetric.Builder totalSleepTimeSpentInRapidEyeMovementSleepBuilder;
        private DreemMetric totalSleepTimeSpentInNonRapidEyeMovementSleep;
        private DreemMetric.Builder totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder;
        private DreemMetric meanRespiratoryRate;
        private DreemMetric.Builder meanRespiratoryRateBuilder;
        private DreemMetric respiratoryRateDuringNonRapidEyeMovement1Duration;
        private DreemMetric.Builder respiratoryRateDuringNonRapidEyeMovement1DurationBuilder;
        private DreemMetric respiratoryRateDuringNonRapidEyeMovement2Duration;
        private DreemMetric.Builder respiratoryRateDuringNonRapidEyeMovement2DurationBuilder;
        private DreemMetric respiratoryRateDuringNonRapidEyeMovement3Duration;
        private DreemMetric.Builder respiratoryRateDuringNonRapidEyeMovement3DurationBuilder;
        private DreemMetric recordingQuality;
        private DreemMetric.Builder recordingQualityBuilder;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.offHead))) {
                this.offHead = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.offHead))).floatValue();
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.totalRecordingTime))) {
                this.totalRecordingTime = (DreemMetric)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.totalRecordingTime));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (other.hasTotalRecordingTimeBuilder()) {
                this.totalRecordingTimeBuilder = DreemMetric.newBuilder(other.getTotalRecordingTimeBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.totalSleepTime))) {
                this.totalSleepTime = (DreemMetric)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.totalSleepTime));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (other.hasTotalSleepTimeBuilder()) {
                this.totalSleepTimeBuilder = DreemMetric.newBuilder(other.getTotalSleepTimeBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.sleepEfficiency))) {
                this.sleepEfficiency = (DreemMetric)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.sleepEfficiency));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (other.hasSleepEfficiencyBuilder()) {
                this.sleepEfficiencyBuilder = DreemMetric.newBuilder(other.getSleepEfficiencyBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.sleepOnsetLatency))) {
                this.sleepOnsetLatency = (DreemMetric)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sleepOnsetLatency));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (other.hasSleepOnsetLatencyBuilder()) {
                this.sleepOnsetLatencyBuilder = DreemMetric.newBuilder(other.getSleepOnsetLatencyBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.latencyPersistentSleep))) {
                this.latencyPersistentSleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.latencyPersistentSleep));
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (other.hasLatencyPersistentSleepBuilder()) {
                this.latencyPersistentSleepBuilder = DreemMetric.newBuilder(other.getLatencyPersistentSleepBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.wakeAfterSleepOnset))) {
                this.wakeAfterSleepOnset = (DreemMetric)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.wakeAfterSleepOnset));
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (other.hasWakeAfterSleepOnsetBuilder()) {
                this.wakeAfterSleepOnsetBuilder = DreemMetric.newBuilder(other.getWakeAfterSleepOnsetBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.rapidEyeMovementLatency))) {
                this.rapidEyeMovementLatency = (DreemMetric)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.rapidEyeMovementLatency));
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (other.hasRapidEyeMovementLatencyBuilder()) {
                this.rapidEyeMovementLatencyBuilder = DreemMetric.newBuilder(other.getRapidEyeMovementLatencyBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.nonRapidEyeMovement))) {
                this.nonRapidEyeMovement = (DreemMetric)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.nonRapidEyeMovement));
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (other.hasNonRapidEyeMovementBuilder()) {
                this.nonRapidEyeMovementBuilder = DreemMetric.newBuilder(other.getNonRapidEyeMovementBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.nonRapidEyeMovement1Duration))) {
                this.nonRapidEyeMovement1Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.nonRapidEyeMovement1Duration));
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (other.hasNonRapidEyeMovement1DurationBuilder()) {
                this.nonRapidEyeMovement1DurationBuilder = DreemMetric.newBuilder(other.getNonRapidEyeMovement1DurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.nonRapidEyeMovement2Duration))) {
                this.nonRapidEyeMovement2Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.nonRapidEyeMovement2Duration));
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (other.hasNonRapidEyeMovement2DurationBuilder()) {
                this.nonRapidEyeMovement2DurationBuilder = DreemMetric.newBuilder(other.getNonRapidEyeMovement2DurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)((Object)other.nonRapidEyeMovement3Duration))) {
                this.nonRapidEyeMovement3Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[13].schema(), (Object)other.nonRapidEyeMovement3Duration));
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (other.hasNonRapidEyeMovement3DurationBuilder()) {
                this.nonRapidEyeMovement3DurationBuilder = DreemMetric.newBuilder(other.getNonRapidEyeMovement3DurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)((Object)other.totalRapidEyeMovementSleepDuration))) {
                this.totalRapidEyeMovementSleepDuration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[14].schema(), (Object)other.totalRapidEyeMovementSleepDuration));
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (other.hasTotalRapidEyeMovementSleepDurationBuilder()) {
                this.totalRapidEyeMovementSleepDurationBuilder = DreemMetric.newBuilder(other.getTotalRapidEyeMovementSleepDurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovement1Sleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovement1Sleep));
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (other.hasTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder()) {
                this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder = DreemMetric.newBuilder(other.getTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovement2Sleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[16].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovement2Sleep));
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (other.hasTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder()) {
                this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder = DreemMetric.newBuilder(other.getTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovement3Sleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[17].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovement3Sleep));
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (other.hasTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder()) {
                this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder = DreemMetric.newBuilder(other.getTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)((Object)other.totalSleepTimeSpentInRapidEyeMovementSleep))) {
                this.totalSleepTimeSpentInRapidEyeMovementSleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[18].schema(), (Object)other.totalSleepTimeSpentInRapidEyeMovementSleep));
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (other.hasTotalSleepTimeSpentInRapidEyeMovementSleepBuilder()) {
                this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder = DreemMetric.newBuilder(other.getTotalSleepTimeSpentInRapidEyeMovementSleepBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovementSleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovementSleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[19].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovementSleep));
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (other.hasTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder()) {
                this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder = DreemMetric.newBuilder(other.getTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)((Object)other.meanRespiratoryRate))) {
                this.meanRespiratoryRate = (DreemMetric)((Object)this.data().deepCopy(this.fields()[20].schema(), (Object)other.meanRespiratoryRate));
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (other.hasMeanRespiratoryRateBuilder()) {
                this.meanRespiratoryRateBuilder = DreemMetric.newBuilder(other.getMeanRespiratoryRateBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)((Object)other.respiratoryRateDuringNonRapidEyeMovement1Duration))) {
                this.respiratoryRateDuringNonRapidEyeMovement1Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[21].schema(), (Object)other.respiratoryRateDuringNonRapidEyeMovement1Duration));
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (other.hasRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder()) {
                this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder = DreemMetric.newBuilder(other.getRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)((Object)other.respiratoryRateDuringNonRapidEyeMovement2Duration))) {
                this.respiratoryRateDuringNonRapidEyeMovement2Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[22].schema(), (Object)other.respiratoryRateDuringNonRapidEyeMovement2Duration));
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (other.hasRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder()) {
                this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder = DreemMetric.newBuilder(other.getRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)((Object)other.respiratoryRateDuringNonRapidEyeMovement3Duration))) {
                this.respiratoryRateDuringNonRapidEyeMovement3Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[23].schema(), (Object)other.respiratoryRateDuringNonRapidEyeMovement3Duration));
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (other.hasRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder()) {
                this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder = DreemMetric.newBuilder(other.getRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)((Object)other.recordingQuality))) {
                this.recordingQuality = (DreemMetric)((Object)this.data().deepCopy(this.fields()[24].schema(), (Object)other.recordingQuality));
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (other.hasRecordingQualityBuilder()) {
                this.recordingQualityBuilder = DreemMetric.newBuilder(other.getRecordingQualityBuilder());
            }
        }

        private Builder(DreemSleepEndpoints other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)Float.valueOf(other.offHead))) {
                this.offHead = ((Float)this.data().deepCopy(this.fields()[2].schema(), (Object)Float.valueOf(other.offHead))).floatValue();
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.totalRecordingTime))) {
                this.totalRecordingTime = (DreemMetric)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.totalRecordingTime));
                this.fieldSetFlags()[3] = true;
            }
            this.totalRecordingTimeBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.totalSleepTime))) {
                this.totalSleepTime = (DreemMetric)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.totalSleepTime));
                this.fieldSetFlags()[4] = true;
            }
            this.totalSleepTimeBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.sleepEfficiency))) {
                this.sleepEfficiency = (DreemMetric)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.sleepEfficiency));
                this.fieldSetFlags()[5] = true;
            }
            this.sleepEfficiencyBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.sleepOnsetLatency))) {
                this.sleepOnsetLatency = (DreemMetric)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sleepOnsetLatency));
                this.fieldSetFlags()[6] = true;
            }
            this.sleepOnsetLatencyBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.latencyPersistentSleep))) {
                this.latencyPersistentSleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.latencyPersistentSleep));
                this.fieldSetFlags()[7] = true;
            }
            this.latencyPersistentSleepBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.wakeAfterSleepOnset))) {
                this.wakeAfterSleepOnset = (DreemMetric)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.wakeAfterSleepOnset));
                this.fieldSetFlags()[8] = true;
            }
            this.wakeAfterSleepOnsetBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)((Object)other.rapidEyeMovementLatency))) {
                this.rapidEyeMovementLatency = (DreemMetric)((Object)this.data().deepCopy(this.fields()[9].schema(), (Object)other.rapidEyeMovementLatency));
                this.fieldSetFlags()[9] = true;
            }
            this.rapidEyeMovementLatencyBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)((Object)other.nonRapidEyeMovement))) {
                this.nonRapidEyeMovement = (DreemMetric)((Object)this.data().deepCopy(this.fields()[10].schema(), (Object)other.nonRapidEyeMovement));
                this.fieldSetFlags()[10] = true;
            }
            this.nonRapidEyeMovementBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.nonRapidEyeMovement1Duration))) {
                this.nonRapidEyeMovement1Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.nonRapidEyeMovement1Duration));
                this.fieldSetFlags()[11] = true;
            }
            this.nonRapidEyeMovement1DurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)((Object)other.nonRapidEyeMovement2Duration))) {
                this.nonRapidEyeMovement2Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[12].schema(), (Object)other.nonRapidEyeMovement2Duration));
                this.fieldSetFlags()[12] = true;
            }
            this.nonRapidEyeMovement2DurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)((Object)other.nonRapidEyeMovement3Duration))) {
                this.nonRapidEyeMovement3Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[13].schema(), (Object)other.nonRapidEyeMovement3Duration));
                this.fieldSetFlags()[13] = true;
            }
            this.nonRapidEyeMovement3DurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)((Object)other.totalRapidEyeMovementSleepDuration))) {
                this.totalRapidEyeMovementSleepDuration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[14].schema(), (Object)other.totalRapidEyeMovementSleepDuration));
                this.fieldSetFlags()[14] = true;
            }
            this.totalRapidEyeMovementSleepDurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovement1Sleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovement1Sleep));
                this.fieldSetFlags()[15] = true;
            }
            this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovement2Sleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[16].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovement2Sleep));
                this.fieldSetFlags()[16] = true;
            }
            this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovement3Sleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[17].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovement3Sleep));
                this.fieldSetFlags()[17] = true;
            }
            this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)((Object)other.totalSleepTimeSpentInRapidEyeMovementSleep))) {
                this.totalSleepTimeSpentInRapidEyeMovementSleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[18].schema(), (Object)other.totalSleepTimeSpentInRapidEyeMovementSleep));
                this.fieldSetFlags()[18] = true;
            }
            this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)((Object)other.totalSleepTimeSpentInNonRapidEyeMovementSleep))) {
                this.totalSleepTimeSpentInNonRapidEyeMovementSleep = (DreemMetric)((Object)this.data().deepCopy(this.fields()[19].schema(), (Object)other.totalSleepTimeSpentInNonRapidEyeMovementSleep));
                this.fieldSetFlags()[19] = true;
            }
            this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)((Object)other.meanRespiratoryRate))) {
                this.meanRespiratoryRate = (DreemMetric)((Object)this.data().deepCopy(this.fields()[20].schema(), (Object)other.meanRespiratoryRate));
                this.fieldSetFlags()[20] = true;
            }
            this.meanRespiratoryRateBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)((Object)other.respiratoryRateDuringNonRapidEyeMovement1Duration))) {
                this.respiratoryRateDuringNonRapidEyeMovement1Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[21].schema(), (Object)other.respiratoryRateDuringNonRapidEyeMovement1Duration));
                this.fieldSetFlags()[21] = true;
            }
            this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)((Object)other.respiratoryRateDuringNonRapidEyeMovement2Duration))) {
                this.respiratoryRateDuringNonRapidEyeMovement2Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[22].schema(), (Object)other.respiratoryRateDuringNonRapidEyeMovement2Duration));
                this.fieldSetFlags()[22] = true;
            }
            this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)((Object)other.respiratoryRateDuringNonRapidEyeMovement3Duration))) {
                this.respiratoryRateDuringNonRapidEyeMovement3Duration = (DreemMetric)((Object)this.data().deepCopy(this.fields()[23].schema(), (Object)other.respiratoryRateDuringNonRapidEyeMovement3Duration));
                this.fieldSetFlags()[23] = true;
            }
            this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)((Object)other.recordingQuality))) {
                this.recordingQuality = (DreemMetric)((Object)this.data().deepCopy(this.fields()[24].schema(), (Object)other.recordingQuality));
                this.fieldSetFlags()[24] = true;
            }
            this.recordingQualityBuilder = null;
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public float getOffHead() {
            return this.offHead;
        }

        public Builder setOffHead(float value) {
            this.validate(this.fields()[2], Float.valueOf(value));
            this.offHead = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasOffHead() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearOffHead() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public DreemMetric getTotalRecordingTime() {
            return this.totalRecordingTime;
        }

        public Builder setTotalRecordingTime(DreemMetric value) {
            this.validate(this.fields()[3], (Object)value);
            this.totalRecordingTimeBuilder = null;
            this.totalRecordingTime = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTotalRecordingTime() {
            return this.fieldSetFlags()[3];
        }

        public DreemMetric.Builder getTotalRecordingTimeBuilder() {
            if (this.totalRecordingTimeBuilder == null) {
                if (this.hasTotalRecordingTime()) {
                    this.setTotalRecordingTimeBuilder(DreemMetric.newBuilder(this.totalRecordingTime));
                } else {
                    this.setTotalRecordingTimeBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalRecordingTimeBuilder;
        }

        public Builder setTotalRecordingTimeBuilder(DreemMetric.Builder value) {
            this.clearTotalRecordingTime();
            this.totalRecordingTimeBuilder = value;
            return this;
        }

        public boolean hasTotalRecordingTimeBuilder() {
            return this.totalRecordingTimeBuilder != null;
        }

        public Builder clearTotalRecordingTime() {
            this.totalRecordingTime = null;
            this.totalRecordingTimeBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public DreemMetric getTotalSleepTime() {
            return this.totalSleepTime;
        }

        public Builder setTotalSleepTime(DreemMetric value) {
            this.validate(this.fields()[4], (Object)value);
            this.totalSleepTimeBuilder = null;
            this.totalSleepTime = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasTotalSleepTime() {
            return this.fieldSetFlags()[4];
        }

        public DreemMetric.Builder getTotalSleepTimeBuilder() {
            if (this.totalSleepTimeBuilder == null) {
                if (this.hasTotalSleepTime()) {
                    this.setTotalSleepTimeBuilder(DreemMetric.newBuilder(this.totalSleepTime));
                } else {
                    this.setTotalSleepTimeBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalSleepTimeBuilder;
        }

        public Builder setTotalSleepTimeBuilder(DreemMetric.Builder value) {
            this.clearTotalSleepTime();
            this.totalSleepTimeBuilder = value;
            return this;
        }

        public boolean hasTotalSleepTimeBuilder() {
            return this.totalSleepTimeBuilder != null;
        }

        public Builder clearTotalSleepTime() {
            this.totalSleepTime = null;
            this.totalSleepTimeBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public DreemMetric getSleepEfficiency() {
            return this.sleepEfficiency;
        }

        public Builder setSleepEfficiency(DreemMetric value) {
            this.validate(this.fields()[5], (Object)value);
            this.sleepEfficiencyBuilder = null;
            this.sleepEfficiency = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSleepEfficiency() {
            return this.fieldSetFlags()[5];
        }

        public DreemMetric.Builder getSleepEfficiencyBuilder() {
            if (this.sleepEfficiencyBuilder == null) {
                if (this.hasSleepEfficiency()) {
                    this.setSleepEfficiencyBuilder(DreemMetric.newBuilder(this.sleepEfficiency));
                } else {
                    this.setSleepEfficiencyBuilder(DreemMetric.newBuilder());
                }
            }
            return this.sleepEfficiencyBuilder;
        }

        public Builder setSleepEfficiencyBuilder(DreemMetric.Builder value) {
            this.clearSleepEfficiency();
            this.sleepEfficiencyBuilder = value;
            return this;
        }

        public boolean hasSleepEfficiencyBuilder() {
            return this.sleepEfficiencyBuilder != null;
        }

        public Builder clearSleepEfficiency() {
            this.sleepEfficiency = null;
            this.sleepEfficiencyBuilder = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public DreemMetric getSleepOnsetLatency() {
            return this.sleepOnsetLatency;
        }

        public Builder setSleepOnsetLatency(DreemMetric value) {
            this.validate(this.fields()[6], (Object)value);
            this.sleepOnsetLatencyBuilder = null;
            this.sleepOnsetLatency = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSleepOnsetLatency() {
            return this.fieldSetFlags()[6];
        }

        public DreemMetric.Builder getSleepOnsetLatencyBuilder() {
            if (this.sleepOnsetLatencyBuilder == null) {
                if (this.hasSleepOnsetLatency()) {
                    this.setSleepOnsetLatencyBuilder(DreemMetric.newBuilder(this.sleepOnsetLatency));
                } else {
                    this.setSleepOnsetLatencyBuilder(DreemMetric.newBuilder());
                }
            }
            return this.sleepOnsetLatencyBuilder;
        }

        public Builder setSleepOnsetLatencyBuilder(DreemMetric.Builder value) {
            this.clearSleepOnsetLatency();
            this.sleepOnsetLatencyBuilder = value;
            return this;
        }

        public boolean hasSleepOnsetLatencyBuilder() {
            return this.sleepOnsetLatencyBuilder != null;
        }

        public Builder clearSleepOnsetLatency() {
            this.sleepOnsetLatency = null;
            this.sleepOnsetLatencyBuilder = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public DreemMetric getLatencyPersistentSleep() {
            return this.latencyPersistentSleep;
        }

        public Builder setLatencyPersistentSleep(DreemMetric value) {
            this.validate(this.fields()[7], (Object)value);
            this.latencyPersistentSleepBuilder = null;
            this.latencyPersistentSleep = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasLatencyPersistentSleep() {
            return this.fieldSetFlags()[7];
        }

        public DreemMetric.Builder getLatencyPersistentSleepBuilder() {
            if (this.latencyPersistentSleepBuilder == null) {
                if (this.hasLatencyPersistentSleep()) {
                    this.setLatencyPersistentSleepBuilder(DreemMetric.newBuilder(this.latencyPersistentSleep));
                } else {
                    this.setLatencyPersistentSleepBuilder(DreemMetric.newBuilder());
                }
            }
            return this.latencyPersistentSleepBuilder;
        }

        public Builder setLatencyPersistentSleepBuilder(DreemMetric.Builder value) {
            this.clearLatencyPersistentSleep();
            this.latencyPersistentSleepBuilder = value;
            return this;
        }

        public boolean hasLatencyPersistentSleepBuilder() {
            return this.latencyPersistentSleepBuilder != null;
        }

        public Builder clearLatencyPersistentSleep() {
            this.latencyPersistentSleep = null;
            this.latencyPersistentSleepBuilder = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public DreemMetric getWakeAfterSleepOnset() {
            return this.wakeAfterSleepOnset;
        }

        public Builder setWakeAfterSleepOnset(DreemMetric value) {
            this.validate(this.fields()[8], (Object)value);
            this.wakeAfterSleepOnsetBuilder = null;
            this.wakeAfterSleepOnset = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasWakeAfterSleepOnset() {
            return this.fieldSetFlags()[8];
        }

        public DreemMetric.Builder getWakeAfterSleepOnsetBuilder() {
            if (this.wakeAfterSleepOnsetBuilder == null) {
                if (this.hasWakeAfterSleepOnset()) {
                    this.setWakeAfterSleepOnsetBuilder(DreemMetric.newBuilder(this.wakeAfterSleepOnset));
                } else {
                    this.setWakeAfterSleepOnsetBuilder(DreemMetric.newBuilder());
                }
            }
            return this.wakeAfterSleepOnsetBuilder;
        }

        public Builder setWakeAfterSleepOnsetBuilder(DreemMetric.Builder value) {
            this.clearWakeAfterSleepOnset();
            this.wakeAfterSleepOnsetBuilder = value;
            return this;
        }

        public boolean hasWakeAfterSleepOnsetBuilder() {
            return this.wakeAfterSleepOnsetBuilder != null;
        }

        public Builder clearWakeAfterSleepOnset() {
            this.wakeAfterSleepOnset = null;
            this.wakeAfterSleepOnsetBuilder = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public DreemMetric getRapidEyeMovementLatency() {
            return this.rapidEyeMovementLatency;
        }

        public Builder setRapidEyeMovementLatency(DreemMetric value) {
            this.validate(this.fields()[9], (Object)value);
            this.rapidEyeMovementLatencyBuilder = null;
            this.rapidEyeMovementLatency = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasRapidEyeMovementLatency() {
            return this.fieldSetFlags()[9];
        }

        public DreemMetric.Builder getRapidEyeMovementLatencyBuilder() {
            if (this.rapidEyeMovementLatencyBuilder == null) {
                if (this.hasRapidEyeMovementLatency()) {
                    this.setRapidEyeMovementLatencyBuilder(DreemMetric.newBuilder(this.rapidEyeMovementLatency));
                } else {
                    this.setRapidEyeMovementLatencyBuilder(DreemMetric.newBuilder());
                }
            }
            return this.rapidEyeMovementLatencyBuilder;
        }

        public Builder setRapidEyeMovementLatencyBuilder(DreemMetric.Builder value) {
            this.clearRapidEyeMovementLatency();
            this.rapidEyeMovementLatencyBuilder = value;
            return this;
        }

        public boolean hasRapidEyeMovementLatencyBuilder() {
            return this.rapidEyeMovementLatencyBuilder != null;
        }

        public Builder clearRapidEyeMovementLatency() {
            this.rapidEyeMovementLatency = null;
            this.rapidEyeMovementLatencyBuilder = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public DreemMetric getNonRapidEyeMovement() {
            return this.nonRapidEyeMovement;
        }

        public Builder setNonRapidEyeMovement(DreemMetric value) {
            this.validate(this.fields()[10], (Object)value);
            this.nonRapidEyeMovementBuilder = null;
            this.nonRapidEyeMovement = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasNonRapidEyeMovement() {
            return this.fieldSetFlags()[10];
        }

        public DreemMetric.Builder getNonRapidEyeMovementBuilder() {
            if (this.nonRapidEyeMovementBuilder == null) {
                if (this.hasNonRapidEyeMovement()) {
                    this.setNonRapidEyeMovementBuilder(DreemMetric.newBuilder(this.nonRapidEyeMovement));
                } else {
                    this.setNonRapidEyeMovementBuilder(DreemMetric.newBuilder());
                }
            }
            return this.nonRapidEyeMovementBuilder;
        }

        public Builder setNonRapidEyeMovementBuilder(DreemMetric.Builder value) {
            this.clearNonRapidEyeMovement();
            this.nonRapidEyeMovementBuilder = value;
            return this;
        }

        public boolean hasNonRapidEyeMovementBuilder() {
            return this.nonRapidEyeMovementBuilder != null;
        }

        public Builder clearNonRapidEyeMovement() {
            this.nonRapidEyeMovement = null;
            this.nonRapidEyeMovementBuilder = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public DreemMetric getNonRapidEyeMovement1Duration() {
            return this.nonRapidEyeMovement1Duration;
        }

        public Builder setNonRapidEyeMovement1Duration(DreemMetric value) {
            this.validate(this.fields()[11], (Object)value);
            this.nonRapidEyeMovement1DurationBuilder = null;
            this.nonRapidEyeMovement1Duration = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasNonRapidEyeMovement1Duration() {
            return this.fieldSetFlags()[11];
        }

        public DreemMetric.Builder getNonRapidEyeMovement1DurationBuilder() {
            if (this.nonRapidEyeMovement1DurationBuilder == null) {
                if (this.hasNonRapidEyeMovement1Duration()) {
                    this.setNonRapidEyeMovement1DurationBuilder(DreemMetric.newBuilder(this.nonRapidEyeMovement1Duration));
                } else {
                    this.setNonRapidEyeMovement1DurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.nonRapidEyeMovement1DurationBuilder;
        }

        public Builder setNonRapidEyeMovement1DurationBuilder(DreemMetric.Builder value) {
            this.clearNonRapidEyeMovement1Duration();
            this.nonRapidEyeMovement1DurationBuilder = value;
            return this;
        }

        public boolean hasNonRapidEyeMovement1DurationBuilder() {
            return this.nonRapidEyeMovement1DurationBuilder != null;
        }

        public Builder clearNonRapidEyeMovement1Duration() {
            this.nonRapidEyeMovement1Duration = null;
            this.nonRapidEyeMovement1DurationBuilder = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public DreemMetric getNonRapidEyeMovement2Duration() {
            return this.nonRapidEyeMovement2Duration;
        }

        public Builder setNonRapidEyeMovement2Duration(DreemMetric value) {
            this.validate(this.fields()[12], (Object)value);
            this.nonRapidEyeMovement2DurationBuilder = null;
            this.nonRapidEyeMovement2Duration = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasNonRapidEyeMovement2Duration() {
            return this.fieldSetFlags()[12];
        }

        public DreemMetric.Builder getNonRapidEyeMovement2DurationBuilder() {
            if (this.nonRapidEyeMovement2DurationBuilder == null) {
                if (this.hasNonRapidEyeMovement2Duration()) {
                    this.setNonRapidEyeMovement2DurationBuilder(DreemMetric.newBuilder(this.nonRapidEyeMovement2Duration));
                } else {
                    this.setNonRapidEyeMovement2DurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.nonRapidEyeMovement2DurationBuilder;
        }

        public Builder setNonRapidEyeMovement2DurationBuilder(DreemMetric.Builder value) {
            this.clearNonRapidEyeMovement2Duration();
            this.nonRapidEyeMovement2DurationBuilder = value;
            return this;
        }

        public boolean hasNonRapidEyeMovement2DurationBuilder() {
            return this.nonRapidEyeMovement2DurationBuilder != null;
        }

        public Builder clearNonRapidEyeMovement2Duration() {
            this.nonRapidEyeMovement2Duration = null;
            this.nonRapidEyeMovement2DurationBuilder = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public DreemMetric getNonRapidEyeMovement3Duration() {
            return this.nonRapidEyeMovement3Duration;
        }

        public Builder setNonRapidEyeMovement3Duration(DreemMetric value) {
            this.validate(this.fields()[13], (Object)value);
            this.nonRapidEyeMovement3DurationBuilder = null;
            this.nonRapidEyeMovement3Duration = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasNonRapidEyeMovement3Duration() {
            return this.fieldSetFlags()[13];
        }

        public DreemMetric.Builder getNonRapidEyeMovement3DurationBuilder() {
            if (this.nonRapidEyeMovement3DurationBuilder == null) {
                if (this.hasNonRapidEyeMovement3Duration()) {
                    this.setNonRapidEyeMovement3DurationBuilder(DreemMetric.newBuilder(this.nonRapidEyeMovement3Duration));
                } else {
                    this.setNonRapidEyeMovement3DurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.nonRapidEyeMovement3DurationBuilder;
        }

        public Builder setNonRapidEyeMovement3DurationBuilder(DreemMetric.Builder value) {
            this.clearNonRapidEyeMovement3Duration();
            this.nonRapidEyeMovement3DurationBuilder = value;
            return this;
        }

        public boolean hasNonRapidEyeMovement3DurationBuilder() {
            return this.nonRapidEyeMovement3DurationBuilder != null;
        }

        public Builder clearNonRapidEyeMovement3Duration() {
            this.nonRapidEyeMovement3Duration = null;
            this.nonRapidEyeMovement3DurationBuilder = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public DreemMetric getTotalRapidEyeMovementSleepDuration() {
            return this.totalRapidEyeMovementSleepDuration;
        }

        public Builder setTotalRapidEyeMovementSleepDuration(DreemMetric value) {
            this.validate(this.fields()[14], (Object)value);
            this.totalRapidEyeMovementSleepDurationBuilder = null;
            this.totalRapidEyeMovementSleepDuration = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasTotalRapidEyeMovementSleepDuration() {
            return this.fieldSetFlags()[14];
        }

        public DreemMetric.Builder getTotalRapidEyeMovementSleepDurationBuilder() {
            if (this.totalRapidEyeMovementSleepDurationBuilder == null) {
                if (this.hasTotalRapidEyeMovementSleepDuration()) {
                    this.setTotalRapidEyeMovementSleepDurationBuilder(DreemMetric.newBuilder(this.totalRapidEyeMovementSleepDuration));
                } else {
                    this.setTotalRapidEyeMovementSleepDurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalRapidEyeMovementSleepDurationBuilder;
        }

        public Builder setTotalRapidEyeMovementSleepDurationBuilder(DreemMetric.Builder value) {
            this.clearTotalRapidEyeMovementSleepDuration();
            this.totalRapidEyeMovementSleepDurationBuilder = value;
            return this;
        }

        public boolean hasTotalRapidEyeMovementSleepDurationBuilder() {
            return this.totalRapidEyeMovementSleepDurationBuilder != null;
        }

        public Builder clearTotalRapidEyeMovementSleepDuration() {
            this.totalRapidEyeMovementSleepDuration = null;
            this.totalRapidEyeMovementSleepDurationBuilder = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovement1Sleep() {
            return this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovement1Sleep(DreemMetric value) {
            this.validate(this.fields()[15], (Object)value);
            this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder = null;
            this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovement1Sleep() {
            return this.fieldSetFlags()[15];
        }

        public DreemMetric.Builder getTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder() {
            if (this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder == null) {
                if (this.hasTotalSleepTimeSpentInNonRapidEyeMovement1Sleep()) {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder(DreemMetric.newBuilder(this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep));
                } else {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder(DreemMetric.Builder value) {
            this.clearTotalSleepTimeSpentInNonRapidEyeMovement1Sleep();
            this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder = value;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder() {
            return this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder != null;
        }

        public Builder clearTotalSleepTimeSpentInNonRapidEyeMovement1Sleep() {
            this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = null;
            this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovement2Sleep() {
            return this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovement2Sleep(DreemMetric value) {
            this.validate(this.fields()[16], (Object)value);
            this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder = null;
            this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovement2Sleep() {
            return this.fieldSetFlags()[16];
        }

        public DreemMetric.Builder getTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder() {
            if (this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder == null) {
                if (this.hasTotalSleepTimeSpentInNonRapidEyeMovement2Sleep()) {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder(DreemMetric.newBuilder(this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep));
                } else {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder(DreemMetric.Builder value) {
            this.clearTotalSleepTimeSpentInNonRapidEyeMovement2Sleep();
            this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder = value;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder() {
            return this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder != null;
        }

        public Builder clearTotalSleepTimeSpentInNonRapidEyeMovement2Sleep() {
            this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = null;
            this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovement3Sleep() {
            return this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovement3Sleep(DreemMetric value) {
            this.validate(this.fields()[17], (Object)value);
            this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder = null;
            this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovement3Sleep() {
            return this.fieldSetFlags()[17];
        }

        public DreemMetric.Builder getTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder() {
            if (this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder == null) {
                if (this.hasTotalSleepTimeSpentInNonRapidEyeMovement3Sleep()) {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder(DreemMetric.newBuilder(this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep));
                } else {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder(DreemMetric.Builder value) {
            this.clearTotalSleepTimeSpentInNonRapidEyeMovement3Sleep();
            this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder = value;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder() {
            return this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder != null;
        }

        public Builder clearTotalSleepTimeSpentInNonRapidEyeMovement3Sleep() {
            this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = null;
            this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public DreemMetric getTotalSleepTimeSpentInRapidEyeMovementSleep() {
            return this.totalSleepTimeSpentInRapidEyeMovementSleep;
        }

        public Builder setTotalSleepTimeSpentInRapidEyeMovementSleep(DreemMetric value) {
            this.validate(this.fields()[18], (Object)value);
            this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder = null;
            this.totalSleepTimeSpentInRapidEyeMovementSleep = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInRapidEyeMovementSleep() {
            return this.fieldSetFlags()[18];
        }

        public DreemMetric.Builder getTotalSleepTimeSpentInRapidEyeMovementSleepBuilder() {
            if (this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder == null) {
                if (this.hasTotalSleepTimeSpentInRapidEyeMovementSleep()) {
                    this.setTotalSleepTimeSpentInRapidEyeMovementSleepBuilder(DreemMetric.newBuilder(this.totalSleepTimeSpentInRapidEyeMovementSleep));
                } else {
                    this.setTotalSleepTimeSpentInRapidEyeMovementSleepBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder;
        }

        public Builder setTotalSleepTimeSpentInRapidEyeMovementSleepBuilder(DreemMetric.Builder value) {
            this.clearTotalSleepTimeSpentInRapidEyeMovementSleep();
            this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder = value;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInRapidEyeMovementSleepBuilder() {
            return this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder != null;
        }

        public Builder clearTotalSleepTimeSpentInRapidEyeMovementSleep() {
            this.totalSleepTimeSpentInRapidEyeMovementSleep = null;
            this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public DreemMetric getTotalSleepTimeSpentInNonRapidEyeMovementSleep() {
            return this.totalSleepTimeSpentInNonRapidEyeMovementSleep;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovementSleep(DreemMetric value) {
            this.validate(this.fields()[19], (Object)value);
            this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder = null;
            this.totalSleepTimeSpentInNonRapidEyeMovementSleep = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovementSleep() {
            return this.fieldSetFlags()[19];
        }

        public DreemMetric.Builder getTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder() {
            if (this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder == null) {
                if (this.hasTotalSleepTimeSpentInNonRapidEyeMovementSleep()) {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder(DreemMetric.newBuilder(this.totalSleepTimeSpentInNonRapidEyeMovementSleep));
                } else {
                    this.setTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder(DreemMetric.newBuilder());
                }
            }
            return this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder;
        }

        public Builder setTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder(DreemMetric.Builder value) {
            this.clearTotalSleepTimeSpentInNonRapidEyeMovementSleep();
            this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder = value;
            return this;
        }

        public boolean hasTotalSleepTimeSpentInNonRapidEyeMovementSleepBuilder() {
            return this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder != null;
        }

        public Builder clearTotalSleepTimeSpentInNonRapidEyeMovementSleep() {
            this.totalSleepTimeSpentInNonRapidEyeMovementSleep = null;
            this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public DreemMetric getMeanRespiratoryRate() {
            return this.meanRespiratoryRate;
        }

        public Builder setMeanRespiratoryRate(DreemMetric value) {
            this.validate(this.fields()[20], (Object)value);
            this.meanRespiratoryRateBuilder = null;
            this.meanRespiratoryRate = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasMeanRespiratoryRate() {
            return this.fieldSetFlags()[20];
        }

        public DreemMetric.Builder getMeanRespiratoryRateBuilder() {
            if (this.meanRespiratoryRateBuilder == null) {
                if (this.hasMeanRespiratoryRate()) {
                    this.setMeanRespiratoryRateBuilder(DreemMetric.newBuilder(this.meanRespiratoryRate));
                } else {
                    this.setMeanRespiratoryRateBuilder(DreemMetric.newBuilder());
                }
            }
            return this.meanRespiratoryRateBuilder;
        }

        public Builder setMeanRespiratoryRateBuilder(DreemMetric.Builder value) {
            this.clearMeanRespiratoryRate();
            this.meanRespiratoryRateBuilder = value;
            return this;
        }

        public boolean hasMeanRespiratoryRateBuilder() {
            return this.meanRespiratoryRateBuilder != null;
        }

        public Builder clearMeanRespiratoryRate() {
            this.meanRespiratoryRate = null;
            this.meanRespiratoryRateBuilder = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public DreemMetric getRespiratoryRateDuringNonRapidEyeMovement1Duration() {
            return this.respiratoryRateDuringNonRapidEyeMovement1Duration;
        }

        public Builder setRespiratoryRateDuringNonRapidEyeMovement1Duration(DreemMetric value) {
            this.validate(this.fields()[21], (Object)value);
            this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder = null;
            this.respiratoryRateDuringNonRapidEyeMovement1Duration = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasRespiratoryRateDuringNonRapidEyeMovement1Duration() {
            return this.fieldSetFlags()[21];
        }

        public DreemMetric.Builder getRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder() {
            if (this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder == null) {
                if (this.hasRespiratoryRateDuringNonRapidEyeMovement1Duration()) {
                    this.setRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder(DreemMetric.newBuilder(this.respiratoryRateDuringNonRapidEyeMovement1Duration));
                } else {
                    this.setRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder;
        }

        public Builder setRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder(DreemMetric.Builder value) {
            this.clearRespiratoryRateDuringNonRapidEyeMovement1Duration();
            this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder = value;
            return this;
        }

        public boolean hasRespiratoryRateDuringNonRapidEyeMovement1DurationBuilder() {
            return this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder != null;
        }

        public Builder clearRespiratoryRateDuringNonRapidEyeMovement1Duration() {
            this.respiratoryRateDuringNonRapidEyeMovement1Duration = null;
            this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public DreemMetric getRespiratoryRateDuringNonRapidEyeMovement2Duration() {
            return this.respiratoryRateDuringNonRapidEyeMovement2Duration;
        }

        public Builder setRespiratoryRateDuringNonRapidEyeMovement2Duration(DreemMetric value) {
            this.validate(this.fields()[22], (Object)value);
            this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder = null;
            this.respiratoryRateDuringNonRapidEyeMovement2Duration = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasRespiratoryRateDuringNonRapidEyeMovement2Duration() {
            return this.fieldSetFlags()[22];
        }

        public DreemMetric.Builder getRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder() {
            if (this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder == null) {
                if (this.hasRespiratoryRateDuringNonRapidEyeMovement2Duration()) {
                    this.setRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder(DreemMetric.newBuilder(this.respiratoryRateDuringNonRapidEyeMovement2Duration));
                } else {
                    this.setRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder;
        }

        public Builder setRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder(DreemMetric.Builder value) {
            this.clearRespiratoryRateDuringNonRapidEyeMovement2Duration();
            this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder = value;
            return this;
        }

        public boolean hasRespiratoryRateDuringNonRapidEyeMovement2DurationBuilder() {
            return this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder != null;
        }

        public Builder clearRespiratoryRateDuringNonRapidEyeMovement2Duration() {
            this.respiratoryRateDuringNonRapidEyeMovement2Duration = null;
            this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public DreemMetric getRespiratoryRateDuringNonRapidEyeMovement3Duration() {
            return this.respiratoryRateDuringNonRapidEyeMovement3Duration;
        }

        public Builder setRespiratoryRateDuringNonRapidEyeMovement3Duration(DreemMetric value) {
            this.validate(this.fields()[23], (Object)value);
            this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder = null;
            this.respiratoryRateDuringNonRapidEyeMovement3Duration = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasRespiratoryRateDuringNonRapidEyeMovement3Duration() {
            return this.fieldSetFlags()[23];
        }

        public DreemMetric.Builder getRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder() {
            if (this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder == null) {
                if (this.hasRespiratoryRateDuringNonRapidEyeMovement3Duration()) {
                    this.setRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder(DreemMetric.newBuilder(this.respiratoryRateDuringNonRapidEyeMovement3Duration));
                } else {
                    this.setRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder(DreemMetric.newBuilder());
                }
            }
            return this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder;
        }

        public Builder setRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder(DreemMetric.Builder value) {
            this.clearRespiratoryRateDuringNonRapidEyeMovement3Duration();
            this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder = value;
            return this;
        }

        public boolean hasRespiratoryRateDuringNonRapidEyeMovement3DurationBuilder() {
            return this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder != null;
        }

        public Builder clearRespiratoryRateDuringNonRapidEyeMovement3Duration() {
            this.respiratoryRateDuringNonRapidEyeMovement3Duration = null;
            this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public DreemMetric getRecordingQuality() {
            return this.recordingQuality;
        }

        public Builder setRecordingQuality(DreemMetric value) {
            this.validate(this.fields()[24], (Object)value);
            this.recordingQualityBuilder = null;
            this.recordingQuality = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasRecordingQuality() {
            return this.fieldSetFlags()[24];
        }

        public DreemMetric.Builder getRecordingQualityBuilder() {
            if (this.recordingQualityBuilder == null) {
                if (this.hasRecordingQuality()) {
                    this.setRecordingQualityBuilder(DreemMetric.newBuilder(this.recordingQuality));
                } else {
                    this.setRecordingQualityBuilder(DreemMetric.newBuilder());
                }
            }
            return this.recordingQualityBuilder;
        }

        public Builder setRecordingQualityBuilder(DreemMetric.Builder value) {
            this.clearRecordingQuality();
            this.recordingQualityBuilder = value;
            return this;
        }

        public boolean hasRecordingQualityBuilder() {
            return this.recordingQualityBuilder != null;
        }

        public Builder clearRecordingQuality() {
            this.recordingQuality = null;
            this.recordingQualityBuilder = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public DreemSleepEndpoints build() {
            try {
                DreemSleepEndpoints record = new DreemSleepEndpoints();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                float f = record.offHead = this.fieldSetFlags()[2] ? this.offHead : ((Float)this.defaultValue(this.fields()[2])).floatValue();
                if (this.totalRecordingTimeBuilder != null) {
                    try {
                        record.totalRecordingTime = this.totalRecordingTimeBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalRecordingTime"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalRecordingTime = this.fieldSetFlags()[3] ? this.totalRecordingTime : (DreemMetric)((Object)this.defaultValue(this.fields()[3]));
                }
                if (this.totalSleepTimeBuilder != null) {
                    try {
                        record.totalSleepTime = this.totalSleepTimeBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalSleepTime"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalSleepTime = this.fieldSetFlags()[4] ? this.totalSleepTime : (DreemMetric)((Object)this.defaultValue(this.fields()[4]));
                }
                if (this.sleepEfficiencyBuilder != null) {
                    try {
                        record.sleepEfficiency = this.sleepEfficiencyBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("sleepEfficiency"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.sleepEfficiency = this.fieldSetFlags()[5] ? this.sleepEfficiency : (DreemMetric)((Object)this.defaultValue(this.fields()[5]));
                }
                if (this.sleepOnsetLatencyBuilder != null) {
                    try {
                        record.sleepOnsetLatency = this.sleepOnsetLatencyBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("sleepOnsetLatency"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.sleepOnsetLatency = this.fieldSetFlags()[6] ? this.sleepOnsetLatency : (DreemMetric)((Object)this.defaultValue(this.fields()[6]));
                }
                if (this.latencyPersistentSleepBuilder != null) {
                    try {
                        record.latencyPersistentSleep = this.latencyPersistentSleepBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("latencyPersistentSleep"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.latencyPersistentSleep = this.fieldSetFlags()[7] ? this.latencyPersistentSleep : (DreemMetric)((Object)this.defaultValue(this.fields()[7]));
                }
                if (this.wakeAfterSleepOnsetBuilder != null) {
                    try {
                        record.wakeAfterSleepOnset = this.wakeAfterSleepOnsetBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("wakeAfterSleepOnset"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.wakeAfterSleepOnset = this.fieldSetFlags()[8] ? this.wakeAfterSleepOnset : (DreemMetric)((Object)this.defaultValue(this.fields()[8]));
                }
                if (this.rapidEyeMovementLatencyBuilder != null) {
                    try {
                        record.rapidEyeMovementLatency = this.rapidEyeMovementLatencyBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("rapidEyeMovementLatency"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.rapidEyeMovementLatency = this.fieldSetFlags()[9] ? this.rapidEyeMovementLatency : (DreemMetric)((Object)this.defaultValue(this.fields()[9]));
                }
                if (this.nonRapidEyeMovementBuilder != null) {
                    try {
                        record.nonRapidEyeMovement = this.nonRapidEyeMovementBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("nonRapidEyeMovement"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.nonRapidEyeMovement = this.fieldSetFlags()[10] ? this.nonRapidEyeMovement : (DreemMetric)((Object)this.defaultValue(this.fields()[10]));
                }
                if (this.nonRapidEyeMovement1DurationBuilder != null) {
                    try {
                        record.nonRapidEyeMovement1Duration = this.nonRapidEyeMovement1DurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("nonRapidEyeMovement1Duration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.nonRapidEyeMovement1Duration = this.fieldSetFlags()[11] ? this.nonRapidEyeMovement1Duration : (DreemMetric)((Object)this.defaultValue(this.fields()[11]));
                }
                if (this.nonRapidEyeMovement2DurationBuilder != null) {
                    try {
                        record.nonRapidEyeMovement2Duration = this.nonRapidEyeMovement2DurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("nonRapidEyeMovement2Duration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.nonRapidEyeMovement2Duration = this.fieldSetFlags()[12] ? this.nonRapidEyeMovement2Duration : (DreemMetric)((Object)this.defaultValue(this.fields()[12]));
                }
                if (this.nonRapidEyeMovement3DurationBuilder != null) {
                    try {
                        record.nonRapidEyeMovement3Duration = this.nonRapidEyeMovement3DurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("nonRapidEyeMovement3Duration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.nonRapidEyeMovement3Duration = this.fieldSetFlags()[13] ? this.nonRapidEyeMovement3Duration : (DreemMetric)((Object)this.defaultValue(this.fields()[13]));
                }
                if (this.totalRapidEyeMovementSleepDurationBuilder != null) {
                    try {
                        record.totalRapidEyeMovementSleepDuration = this.totalRapidEyeMovementSleepDurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalRapidEyeMovementSleepDuration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalRapidEyeMovementSleepDuration = this.fieldSetFlags()[14] ? this.totalRapidEyeMovementSleepDuration : (DreemMetric)((Object)this.defaultValue(this.fields()[14]));
                }
                if (this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder != null) {
                    try {
                        record.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = this.totalSleepTimeSpentInNonRapidEyeMovement1SleepBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalSleepTimeSpentInNonRapidEyeMovement1Sleep"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalSleepTimeSpentInNonRapidEyeMovement1Sleep = this.fieldSetFlags()[15] ? this.totalSleepTimeSpentInNonRapidEyeMovement1Sleep : (DreemMetric)((Object)this.defaultValue(this.fields()[15]));
                }
                if (this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder != null) {
                    try {
                        record.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = this.totalSleepTimeSpentInNonRapidEyeMovement2SleepBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalSleepTimeSpentInNonRapidEyeMovement2Sleep"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalSleepTimeSpentInNonRapidEyeMovement2Sleep = this.fieldSetFlags()[16] ? this.totalSleepTimeSpentInNonRapidEyeMovement2Sleep : (DreemMetric)((Object)this.defaultValue(this.fields()[16]));
                }
                if (this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder != null) {
                    try {
                        record.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = this.totalSleepTimeSpentInNonRapidEyeMovement3SleepBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalSleepTimeSpentInNonRapidEyeMovement3Sleep"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalSleepTimeSpentInNonRapidEyeMovement3Sleep = this.fieldSetFlags()[17] ? this.totalSleepTimeSpentInNonRapidEyeMovement3Sleep : (DreemMetric)((Object)this.defaultValue(this.fields()[17]));
                }
                if (this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder != null) {
                    try {
                        record.totalSleepTimeSpentInRapidEyeMovementSleep = this.totalSleepTimeSpentInRapidEyeMovementSleepBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalSleepTimeSpentInRapidEyeMovementSleep"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalSleepTimeSpentInRapidEyeMovementSleep = this.fieldSetFlags()[18] ? this.totalSleepTimeSpentInRapidEyeMovementSleep : (DreemMetric)((Object)this.defaultValue(this.fields()[18]));
                }
                if (this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder != null) {
                    try {
                        record.totalSleepTimeSpentInNonRapidEyeMovementSleep = this.totalSleepTimeSpentInNonRapidEyeMovementSleepBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("totalSleepTimeSpentInNonRapidEyeMovementSleep"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.totalSleepTimeSpentInNonRapidEyeMovementSleep = this.fieldSetFlags()[19] ? this.totalSleepTimeSpentInNonRapidEyeMovementSleep : (DreemMetric)((Object)this.defaultValue(this.fields()[19]));
                }
                if (this.meanRespiratoryRateBuilder != null) {
                    try {
                        record.meanRespiratoryRate = this.meanRespiratoryRateBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("meanRespiratoryRate"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.meanRespiratoryRate = this.fieldSetFlags()[20] ? this.meanRespiratoryRate : (DreemMetric)((Object)this.defaultValue(this.fields()[20]));
                }
                if (this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder != null) {
                    try {
                        record.respiratoryRateDuringNonRapidEyeMovement1Duration = this.respiratoryRateDuringNonRapidEyeMovement1DurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("respiratoryRateDuringNonRapidEyeMovement1Duration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.respiratoryRateDuringNonRapidEyeMovement1Duration = this.fieldSetFlags()[21] ? this.respiratoryRateDuringNonRapidEyeMovement1Duration : (DreemMetric)((Object)this.defaultValue(this.fields()[21]));
                }
                if (this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder != null) {
                    try {
                        record.respiratoryRateDuringNonRapidEyeMovement2Duration = this.respiratoryRateDuringNonRapidEyeMovement2DurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("respiratoryRateDuringNonRapidEyeMovement2Duration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.respiratoryRateDuringNonRapidEyeMovement2Duration = this.fieldSetFlags()[22] ? this.respiratoryRateDuringNonRapidEyeMovement2Duration : (DreemMetric)((Object)this.defaultValue(this.fields()[22]));
                }
                if (this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder != null) {
                    try {
                        record.respiratoryRateDuringNonRapidEyeMovement3Duration = this.respiratoryRateDuringNonRapidEyeMovement3DurationBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("respiratoryRateDuringNonRapidEyeMovement3Duration"));
                        throw e;
                    }
                } else {
                    DreemMetric dreemMetric = record.respiratoryRateDuringNonRapidEyeMovement3Duration = this.fieldSetFlags()[23] ? this.respiratoryRateDuringNonRapidEyeMovement3Duration : (DreemMetric)((Object)this.defaultValue(this.fields()[23]));
                }
                if (this.recordingQualityBuilder != null) {
                    try {
                        record.recordingQuality = this.recordingQualityBuilder.build();
                    }
                    catch (AvroMissingFieldException e) {
                        e.addParentField(record.getSchema().getField("recordingQuality"));
                        throw e;
                    }
                } else {
                    record.recordingQuality = this.fieldSetFlags()[24] ? this.recordingQuality : (DreemMetric)((Object)this.defaultValue(this.fields()[24]));
                }
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

