/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.dreem;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.dreem.SleepStageType;

@AvroGenerated
public class DreemSleepStage
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 7264128928576085124L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"DreemSleepStage\",\"namespace\":\"org.radarcns.passive.dreem\",\"doc\":\"AVRO Schema for DREEM hypnogram data.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"This refers to the sleepDateTime field from the dataset.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"This is the processing time in UTC (s).\"},{\"name\":\"recDateTime\",\"type\":\"double\",\"doc\":\"This refers to the session start time.\"},{\"name\":\"epochNumber\",\"type\":\"int\",\"doc\":\"Interval number (30 seconds) since the measurement was started. It starts at 1.\"},{\"name\":\"sleepStage\",\"type\":{\"type\":\"enum\",\"name\":\"SleepStageType\",\"doc\":\"Types of sleep stage Wk: Wakefulness, RM: Rapid eye movements, N1: non-REM stage 1, N2 non rem stage 2, N3 is non rem stage 3, NS stands for non scorable. NS is defined as an epoch that was either off head or had low record quality indication (at epoch level). UNKNOWN indicates that another unknown sleep stage was detected.\",\"symbols\":[\"UNKNOWN\",\"WK\",\"REM\",\"N1\",\"N2\",\"N3\",\"NS\"]},\"doc\":\"Sleep stage that the user is in at this particular time point.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<DreemSleepStage> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<DreemSleepStage> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private double recDateTime;
    private int epochNumber;
    private SleepStageType sleepStage;
    private static final DatumWriter<DreemSleepStage> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<DreemSleepStage> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<DreemSleepStage> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<DreemSleepStage> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<DreemSleepStage> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static DreemSleepStage fromByteBuffer(ByteBuffer b) throws IOException {
        return (DreemSleepStage)((Object)DECODER.decode(b));
    }

    public DreemSleepStage() {
    }

    public DreemSleepStage(Double time, Double timeReceived, Double recDateTime, Integer epochNumber, SleepStageType sleepStage) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.recDateTime = recDateTime;
        this.epochNumber = epochNumber;
        this.sleepStage = sleepStage;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.recDateTime;
            }
            case 3: {
                return this.epochNumber;
            }
            case 4: {
                return this.sleepStage;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.recDateTime = (Double)value$;
                break;
            }
            case 3: {
                this.epochNumber = (Integer)value$;
                break;
            }
            case 4: {
                this.sleepStage = (SleepStageType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public double getRecDateTime() {
        return this.recDateTime;
    }

    public void setRecDateTime(double value) {
        this.recDateTime = value;
    }

    public int getEpochNumber() {
        return this.epochNumber;
    }

    public void setEpochNumber(int value) {
        this.epochNumber = value;
    }

    public SleepStageType getSleepStage() {
        return this.sleepStage;
    }

    public void setSleepStage(SleepStageType value) {
        this.sleepStage = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(DreemSleepStage other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeDouble(this.recDateTime);
        out.writeInt(this.epochNumber);
        out.writeEnum(this.sleepStage.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.recDateTime = in.readDouble();
            this.epochNumber = in.readInt();
            this.sleepStage = SleepStageType.values()[in.readEnum()];
        } else {
            block7: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block7;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block7;
                    }
                    case 2: {
                        this.recDateTime = in.readDouble();
                        continue block7;
                    }
                    case 3: {
                        this.epochNumber = in.readInt();
                        continue block7;
                    }
                    case 4: {
                        this.sleepStage = SleepStageType.values()[in.readEnum()];
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<DreemSleepStage>
    implements RecordBuilder<DreemSleepStage> {
        private double time;
        private double timeReceived;
        private double recDateTime;
        private int epochNumber;
        private SleepStageType sleepStage;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.recDateTime)) {
                this.recDateTime = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.recDateTime);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.epochNumber)) {
                this.epochNumber = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.epochNumber);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.sleepStage))) {
                this.sleepStage = (SleepStageType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.sleepStage));
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(DreemSleepStage other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.recDateTime)) {
                this.recDateTime = (Double)this.data().deepCopy(this.fields()[2].schema(), (Object)other.recDateTime);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.epochNumber)) {
                this.epochNumber = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.epochNumber);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.sleepStage))) {
                this.sleepStage = (SleepStageType)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.sleepStage));
                this.fieldSetFlags()[4] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public double getRecDateTime() {
            return this.recDateTime;
        }

        public Builder setRecDateTime(double value) {
            this.validate(this.fields()[2], value);
            this.recDateTime = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasRecDateTime() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearRecDateTime() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getEpochNumber() {
            return this.epochNumber;
        }

        public Builder setEpochNumber(int value) {
            this.validate(this.fields()[3], value);
            this.epochNumber = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasEpochNumber() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearEpochNumber() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public SleepStageType getSleepStage() {
            return this.sleepStage;
        }

        public Builder setSleepStage(SleepStageType value) {
            this.validate(this.fields()[4], (Object)value);
            this.sleepStage = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasSleepStage() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearSleepStage() {
            this.sleepStage = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public DreemSleepStage build() {
            try {
                DreemSleepStage record = new DreemSleepStage();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.recDateTime = this.fieldSetFlags()[2] ? this.recDateTime : (Double)this.defaultValue(this.fields()[2]);
                record.epochNumber = this.fieldSetFlags()[3] ? this.epochNumber : (Integer)this.defaultValue(this.fields()[3]);
                record.sleepStage = this.fieldSetFlags()[4] ? this.sleepStage : (SleepStageType)((Object)this.defaultValue(this.fields()[4]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

