/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.garmin.Source;

@AvroGenerated
public class GarminGenericHeartRate
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3061827538034380217L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminGenericHeartRate\",\"namespace\":\"org.radarcns.passive.garmin\",\"doc\":\"Provides the data about real time Heart rate data.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Last updated time.\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"heartRate\",\"type\":\"int\",\"doc\":\"Heart rate (bpm).\"},{\"name\":\"restingHeartRate\",\"type\":\"int\",\"doc\":\"Resting heart rate (bpm).\"},{\"name\":\"dailyHighHeartRate\",\"type\":\"int\",\"doc\":\"Daily high heart rate (bpm). High and low heart rate are simply the highest and lowest individual HR values recorded daily up to a given point, when the RestingHeartRate message is written. Resting heart rate itself is calculated algorithmically based on recordings taken during periods of sustained low motion. 'Daily' values provided by the SDK are always reset at midnight of the local user-day.\"},{\"name\":\"dailyLowHeartRate\",\"type\":\"int\",\"doc\":\"Daily low heart rate (bpm). High and low heart rate are simply the highest and lowest individual HR values recorded daily up to a given point, when the RestingHeartRate message is written. Resting heart rate itself is calculated algorithmically based on recordings taken during periods of sustained low motion. 'Daily' values provided by the SDK are always reset at midnight of the local user-day.\"},{\"name\":\"heartRateSource\",\"type\":{\"type\":\"enum\",\"name\":\"Source\",\"doc\":\"Possible connection state values - UNKNOWN (heart rate is recorded with value for source that is not understood), NO_SOURCE (Heart rate is received but no source is recorded), HR_STRAP(hear rate is read from heart rate strap), OHR_NO_LOCK (Indicates that the reading is from watch with optical heart rate sensor not locked), OHR_LOCKED (Indicates that the reading is from watch with optical heart rate sensor locked).\",\"symbols\":[\"UNKNOWN\",\"NO_SOURCE\",\"HR_STRAP\",\"OHR_NO_LOCK\",\"OHR_LOCKED\"]},\"doc\":\"Source from where the heart rate is measured.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminGenericHeartRate> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminGenericHeartRate> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private int heartRate;
    private int restingHeartRate;
    private int dailyHighHeartRate;
    private int dailyLowHeartRate;
    private Source heartRateSource;
    private static final DatumWriter<GarminGenericHeartRate> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminGenericHeartRate> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminGenericHeartRate> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminGenericHeartRate> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminGenericHeartRate> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminGenericHeartRate fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminGenericHeartRate)((Object)DECODER.decode(b));
    }

    public GarminGenericHeartRate() {
    }

    public GarminGenericHeartRate(Double time, Double timeReceived, Integer heartRate, Integer restingHeartRate, Integer dailyHighHeartRate, Integer dailyLowHeartRate, Source heartRateSource) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.heartRate = heartRate;
        this.restingHeartRate = restingHeartRate;
        this.dailyHighHeartRate = dailyHighHeartRate;
        this.dailyLowHeartRate = dailyLowHeartRate;
        this.heartRateSource = heartRateSource;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.heartRate;
            }
            case 3: {
                return this.restingHeartRate;
            }
            case 4: {
                return this.dailyHighHeartRate;
            }
            case 5: {
                return this.dailyLowHeartRate;
            }
            case 6: {
                return this.heartRateSource;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.heartRate = (Integer)value$;
                break;
            }
            case 3: {
                this.restingHeartRate = (Integer)value$;
                break;
            }
            case 4: {
                this.dailyHighHeartRate = (Integer)value$;
                break;
            }
            case 5: {
                this.dailyLowHeartRate = (Integer)value$;
                break;
            }
            case 6: {
                this.heartRateSource = (Source)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public int getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(int value) {
        this.heartRate = value;
    }

    public int getRestingHeartRate() {
        return this.restingHeartRate;
    }

    public void setRestingHeartRate(int value) {
        this.restingHeartRate = value;
    }

    public int getDailyHighHeartRate() {
        return this.dailyHighHeartRate;
    }

    public void setDailyHighHeartRate(int value) {
        this.dailyHighHeartRate = value;
    }

    public int getDailyLowHeartRate() {
        return this.dailyLowHeartRate;
    }

    public void setDailyLowHeartRate(int value) {
        this.dailyLowHeartRate = value;
    }

    public Source getHeartRateSource() {
        return this.heartRateSource;
    }

    public void setHeartRateSource(Source value) {
        this.heartRateSource = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminGenericHeartRate other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeInt(this.heartRate);
        out.writeInt(this.restingHeartRate);
        out.writeInt(this.dailyHighHeartRate);
        out.writeInt(this.dailyLowHeartRate);
        out.writeEnum(this.heartRateSource.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.heartRate = in.readInt();
            this.restingHeartRate = in.readInt();
            this.dailyHighHeartRate = in.readInt();
            this.dailyLowHeartRate = in.readInt();
            this.heartRateSource = Source.values()[in.readEnum()];
        } else {
            block9: for (int i = 0; i < 7; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block9;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block9;
                    }
                    case 2: {
                        this.heartRate = in.readInt();
                        continue block9;
                    }
                    case 3: {
                        this.restingHeartRate = in.readInt();
                        continue block9;
                    }
                    case 4: {
                        this.dailyHighHeartRate = in.readInt();
                        continue block9;
                    }
                    case 5: {
                        this.dailyLowHeartRate = in.readInt();
                        continue block9;
                    }
                    case 6: {
                        this.heartRateSource = Source.values()[in.readEnum()];
                        continue block9;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminGenericHeartRate>
    implements RecordBuilder<GarminGenericHeartRate> {
        private double time;
        private double timeReceived;
        private int heartRate;
        private int restingHeartRate;
        private int dailyHighHeartRate;
        private int dailyLowHeartRate;
        private Source heartRateSource;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.heartRate)) {
                this.heartRate = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.heartRate);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.restingHeartRate)) {
                this.restingHeartRate = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.restingHeartRate);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.dailyHighHeartRate)) {
                this.dailyHighHeartRate = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.dailyHighHeartRate);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.dailyLowHeartRate)) {
                this.dailyLowHeartRate = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.dailyLowHeartRate);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.heartRateSource))) {
                this.heartRateSource = (Source)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.heartRateSource));
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
        }

        private Builder(GarminGenericHeartRate other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.heartRate)) {
                this.heartRate = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.heartRate);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.restingHeartRate)) {
                this.restingHeartRate = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.restingHeartRate);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.dailyHighHeartRate)) {
                this.dailyHighHeartRate = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.dailyHighHeartRate);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.dailyLowHeartRate)) {
                this.dailyLowHeartRate = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.dailyLowHeartRate);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.heartRateSource))) {
                this.heartRateSource = (Source)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.heartRateSource));
                this.fieldSetFlags()[6] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public int getHeartRate() {
            return this.heartRate;
        }

        public Builder setHeartRate(int value) {
            this.validate(this.fields()[2], value);
            this.heartRate = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasHeartRate() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearHeartRate() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public int getRestingHeartRate() {
            return this.restingHeartRate;
        }

        public Builder setRestingHeartRate(int value) {
            this.validate(this.fields()[3], value);
            this.restingHeartRate = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasRestingHeartRate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearRestingHeartRate() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public int getDailyHighHeartRate() {
            return this.dailyHighHeartRate;
        }

        public Builder setDailyHighHeartRate(int value) {
            this.validate(this.fields()[4], value);
            this.dailyHighHeartRate = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDailyHighHeartRate() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDailyHighHeartRate() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public int getDailyLowHeartRate() {
            return this.dailyLowHeartRate;
        }

        public Builder setDailyLowHeartRate(int value) {
            this.validate(this.fields()[5], value);
            this.dailyLowHeartRate = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasDailyLowHeartRate() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearDailyLowHeartRate() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Source getHeartRateSource() {
            return this.heartRateSource;
        }

        public Builder setHeartRateSource(Source value) {
            this.validate(this.fields()[6], (Object)value);
            this.heartRateSource = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasHeartRateSource() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearHeartRateSource() {
            this.heartRateSource = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public GarminGenericHeartRate build() {
            try {
                GarminGenericHeartRate record = new GarminGenericHeartRate();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.heartRate = this.fieldSetFlags()[2] ? this.heartRate : (Integer)this.defaultValue(this.fields()[2]);
                record.restingHeartRate = this.fieldSetFlags()[3] ? this.restingHeartRate : (Integer)this.defaultValue(this.fields()[3]);
                record.dailyHighHeartRate = this.fieldSetFlags()[4] ? this.dailyHighHeartRate : (Integer)this.defaultValue(this.fields()[4]);
                record.dailyLowHeartRate = this.fieldSetFlags()[5] ? this.dailyLowHeartRate : (Integer)this.defaultValue(this.fields()[5]);
                record.heartRateSource = this.fieldSetFlags()[6] ? this.heartRateSource : (Source)((Object)this.defaultValue(this.fields()[6]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

