/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.google;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.google.ActivityType;
import org.radarcns.passive.google.TransitionType;

@AvroGenerated
public class GoogleActivityTransitionEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -8617615522544227987L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GoogleActivityTransitionEvent\",\"namespace\":\"org.radarcns.passive.google\",\"doc\":\"Represents an activity transition event, for example start to walk, stop running etc.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"The UNIX epoch time (s) for the moment when the activity takes place..\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"activity\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"ActivityType\",\"doc\":\"The detected activity of the device. \\nIN_VEHICLE indicates the device is in a vehicle, such as a car. \\nON_BICYCLE indicates the device is on a bicycle. \\n ON_FOOT indicates the device is on a user who is walking or running. \\nRUNNING indicates the device is on a user who is running. This is a sub-activity of ON_FOOT. \\nSTILL indicates the device is still (not moving). \\nWALKING indicates the device is on a user who is walking. This is a sub-activity of ON_FOOT.\",\"symbols\":[\"IN_VEHICLE\",\"ON_BICYCLE\",\"ON_FOOT\",\"RUNNING\",\"STILL\",\"WALKING\",\"UNKNOWN\"]}],\"doc\":\"Gets the type of the activity of the transition.\",\"default\":null},{\"name\":\"transition\",\"type\":{\"type\":\"enum\",\"name\":\"TransitionType\",\"doc\":\"Represents the transition associated with an activity listed in ActivityType. For instance start to walk, stop running etc. \\nENTER represents user enters the given activity from ActivityType. \\nEXIT represents user exits the given activity from ActivityType.\",\"symbols\":[\"ENTER\",\"EXIT\",\"UNKNOWN\"]},\"doc\":\"Represents the transition associated with an activity listed in ActivityType.\",\"default\":\"UNKNOWN\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GoogleActivityTransitionEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GoogleActivityTransitionEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private ActivityType activity;
    private TransitionType transition;
    private static final DatumWriter<GoogleActivityTransitionEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GoogleActivityTransitionEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GoogleActivityTransitionEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GoogleActivityTransitionEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GoogleActivityTransitionEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GoogleActivityTransitionEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (GoogleActivityTransitionEvent)((Object)DECODER.decode(b));
    }

    public GoogleActivityTransitionEvent() {
    }

    public GoogleActivityTransitionEvent(Double time, Double timeReceived, ActivityType activity, TransitionType transition) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.activity = activity;
        this.transition = transition;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.activity;
            }
            case 3: {
                return this.transition;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.activity = (ActivityType)((Object)value$);
                break;
            }
            case 3: {
                this.transition = (TransitionType)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public ActivityType getActivity() {
        return this.activity;
    }

    public void setActivity(ActivityType value) {
        this.activity = value;
    }

    public TransitionType getTransition() {
        return this.transition;
    }

    public void setTransition(TransitionType value) {
        this.transition = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GoogleActivityTransitionEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.activity == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.activity.ordinal());
        }
        out.writeEnum(this.transition.ordinal());
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.activity = null;
            } else {
                this.activity = ActivityType.values()[in.readEnum()];
            }
            this.transition = TransitionType.values()[in.readEnum()];
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activity = null;
                            continue block6;
                        }
                        this.activity = ActivityType.values()[in.readEnum()];
                        continue block6;
                    }
                    case 3: {
                        this.transition = TransitionType.values()[in.readEnum()];
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GoogleActivityTransitionEvent>
    implements RecordBuilder<GoogleActivityTransitionEvent> {
        private double time;
        private double timeReceived;
        private ActivityType activity;
        private TransitionType transition;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.activity))) {
                this.activity = (ActivityType)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.activity));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.transition))) {
                this.transition = (TransitionType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.transition));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(GoogleActivityTransitionEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.activity))) {
                this.activity = (ActivityType)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.activity));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.transition))) {
                this.transition = (TransitionType)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.transition));
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public ActivityType getActivity() {
            return this.activity;
        }

        public Builder setActivity(ActivityType value) {
            this.validate(this.fields()[2], (Object)value);
            this.activity = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasActivity() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearActivity() {
            this.activity = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public TransitionType getTransition() {
            return this.transition;
        }

        public Builder setTransition(TransitionType value) {
            this.validate(this.fields()[3], (Object)value);
            this.transition = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasTransition() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearTransition() {
            this.transition = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public GoogleActivityTransitionEvent build() {
            try {
                GoogleActivityTransitionEvent record = new GoogleActivityTransitionEvent();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.activity = this.fieldSetFlags()[2] ? this.activity : (ActivityType)((Object)this.defaultValue(this.fields()[2]));
                record.transition = this.fieldSetFlags()[3] ? this.transition : (TransitionType)((Object)this.defaultValue(this.fields()[3]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

