/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.opensmile;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class OpenSmile2PhoneAudio
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 7675140421221174482L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"OpenSmile2PhoneAudio\",\"namespace\":\"org.radarcns.passive.opensmile\",\"doc\":\"Audio data collected by a phone audio input and processed using openSMILE 2.x.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device time since the Unix Epoch at start of recording (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device time since the Unix Epoch when recording is processed (s).\"},{\"name\":\"config\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"OpenSMILE configuration file.\"},{\"name\":\"data\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Audio features computed by openSMILE recorded in Base64 format.\"}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<OpenSmile2PhoneAudio> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<OpenSmile2PhoneAudio> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String config;
    private String data;
    private static final DatumWriter<OpenSmile2PhoneAudio> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<OpenSmile2PhoneAudio> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<OpenSmile2PhoneAudio> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<OpenSmile2PhoneAudio> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<OpenSmile2PhoneAudio> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static OpenSmile2PhoneAudio fromByteBuffer(ByteBuffer b) throws IOException {
        return (OpenSmile2PhoneAudio)((Object)DECODER.decode(b));
    }

    public OpenSmile2PhoneAudio() {
    }

    public OpenSmile2PhoneAudio(Double time, Double timeReceived, String config, String data) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.config = config;
        this.data = data;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.config;
            }
            case 3: {
                return this.data;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.config = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.data = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String value) {
        this.config = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String value) {
        this.data = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(OpenSmile2PhoneAudio other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.config);
        out.writeString(this.data);
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.config = in.readString();
            this.data = in.readString();
        } else {
            block6: for (int i = 0; i < 4; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block6;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block6;
                    }
                    case 2: {
                        this.config = in.readString();
                        continue block6;
                    }
                    case 3: {
                        this.data = in.readString();
                        continue block6;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<OpenSmile2PhoneAudio>
    implements RecordBuilder<OpenSmile2PhoneAudio> {
        private double time;
        private double timeReceived;
        private String config;
        private String data;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.config)) {
                this.config = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.config);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.data)) {
                this.data = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.data);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
        }

        private Builder(OpenSmile2PhoneAudio other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.config)) {
                this.config = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.config);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.data)) {
                this.data = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.data);
                this.fieldSetFlags()[3] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getConfig() {
            return this.config;
        }

        public Builder setConfig(String value) {
            this.validate(this.fields()[2], value);
            this.config = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasConfig() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearConfig() {
            this.config = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getData() {
            return this.data;
        }

        public Builder setData(String value) {
            this.validate(this.fields()[3], value);
            this.data = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasData() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearData() {
            this.data = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public OpenSmile2PhoneAudio build() {
            try {
                OpenSmile2PhoneAudio record = new OpenSmile2PhoneAudio();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.config = this.fieldSetFlags()[2] ? this.config : (String)this.defaultValue(this.fields()[2]);
                record.data = this.fieldSetFlags()[3] ? this.data : (String)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

