/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.passive.phone;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.radarcns.passive.phone.PairedState;

@AvroGenerated
public class PhoneBluetoothDeviceScanned
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6815393407964563910L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"PhoneBluetoothDeviceScanned\",\"namespace\":\"org.radarcns.passive.phone\",\"doc\":\"Phone Bluetooth device info.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Device timestamp in UTC (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Device receiver timestamp in UTC (s).\"},{\"name\":\"macAddressHash\",\"type\":[\"null\",\"bytes\"],\"doc\":\"Hash of Nearby Bluetooth device MAC address.\",\"default\":null},{\"name\":\"hashSaltReference\",\"type\":[\"null\",\"int\"],\"doc\":\"Random identifier associated with the device or installation of the app. If the app gets reinstalled or installed on another device, it's clear during analysis that the mac addresses between iterations are not comparable.\",\"default\":null},{\"name\":\"isPaired\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Whether the bluetooth device is paired. This has been deprecated in favor of pairedState in newer versions.\",\"default\":null},{\"name\":\"pairedState\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"PairedState\",\"doc\":\"Represent the bond state of the remote device. \\nNOT_PAIRED indicates the remote device is not paired. \\nPAIRING indicates pairing is in progress with the remote device. \\nPAIRED Indicates the remote device is paired. \\nUNKNOWN indicates the pairing status is not known.\",\"symbols\":[\"NOT_PAIRED\",\"PAIRING\",\"PAIRED\",\"UNKNOWN\"]}],\"doc\":\"Indicates the current paired status of the remote device.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<PhoneBluetoothDeviceScanned> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<PhoneBluetoothDeviceScanned> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private ByteBuffer macAddressHash;
    private Integer hashSaltReference;
    private Boolean isPaired;
    private PairedState pairedState;
    private static final DatumWriter<PhoneBluetoothDeviceScanned> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<PhoneBluetoothDeviceScanned> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<PhoneBluetoothDeviceScanned> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<PhoneBluetoothDeviceScanned> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<PhoneBluetoothDeviceScanned> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static PhoneBluetoothDeviceScanned fromByteBuffer(ByteBuffer b) throws IOException {
        return (PhoneBluetoothDeviceScanned)((Object)DECODER.decode(b));
    }

    public PhoneBluetoothDeviceScanned() {
    }

    public PhoneBluetoothDeviceScanned(Double time, Double timeReceived, ByteBuffer macAddressHash, Integer hashSaltReference, Boolean isPaired, PairedState pairedState) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.macAddressHash = macAddressHash;
        this.hashSaltReference = hashSaltReference;
        this.isPaired = isPaired;
        this.pairedState = pairedState;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.macAddressHash;
            }
            case 3: {
                return this.hashSaltReference;
            }
            case 4: {
                return this.isPaired;
            }
            case 5: {
                return this.pairedState;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.macAddressHash = (ByteBuffer)value$;
                break;
            }
            case 3: {
                this.hashSaltReference = (Integer)value$;
                break;
            }
            case 4: {
                this.isPaired = (Boolean)value$;
                break;
            }
            case 5: {
                this.pairedState = (PairedState)((Object)value$);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public ByteBuffer getMacAddressHash() {
        return this.macAddressHash;
    }

    public void setMacAddressHash(ByteBuffer value) {
        this.macAddressHash = value;
    }

    public Integer getHashSaltReference() {
        return this.hashSaltReference;
    }

    public void setHashSaltReference(Integer value) {
        this.hashSaltReference = value;
    }

    public Boolean getIsPaired() {
        return this.isPaired;
    }

    public void setIsPaired(Boolean value) {
        this.isPaired = value;
    }

    public PairedState getPairedState() {
        return this.pairedState;
    }

    public void setPairedState(PairedState value) {
        this.pairedState = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(PhoneBluetoothDeviceScanned other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        if (this.macAddressHash == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBytes(this.macAddressHash);
        }
        if (this.hashSaltReference == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.hashSaltReference.intValue());
        }
        if (this.isPaired == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeBoolean(this.isPaired.booleanValue());
        }
        if (this.pairedState == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeEnum(this.pairedState.ordinal());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            if (in.readIndex() != 1) {
                in.readNull();
                this.macAddressHash = null;
            } else {
                this.macAddressHash = in.readBytes(this.macAddressHash);
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.hashSaltReference = null;
            } else {
                this.hashSaltReference = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.isPaired = null;
            } else {
                this.isPaired = in.readBoolean();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.pairedState = null;
            } else {
                this.pairedState = PairedState.values()[in.readEnum()];
            }
        } else {
            block8: for (int i = 0; i < 6; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block8;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block8;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.macAddressHash = null;
                            continue block8;
                        }
                        this.macAddressHash = in.readBytes(this.macAddressHash);
                        continue block8;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.hashSaltReference = null;
                            continue block8;
                        }
                        this.hashSaltReference = in.readInt();
                        continue block8;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.isPaired = null;
                            continue block8;
                        }
                        this.isPaired = in.readBoolean();
                        continue block8;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.pairedState = null;
                            continue block8;
                        }
                        this.pairedState = PairedState.values()[in.readEnum()];
                        continue block8;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<PhoneBluetoothDeviceScanned>
    implements RecordBuilder<PhoneBluetoothDeviceScanned> {
        private double time;
        private double timeReceived;
        private ByteBuffer macAddressHash;
        private Integer hashSaltReference;
        private Boolean isPaired;
        private PairedState pairedState;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.macAddressHash)) {
                this.macAddressHash = (ByteBuffer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.macAddressHash);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.hashSaltReference)) {
                this.hashSaltReference = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.hashSaltReference);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.isPaired)) {
                this.isPaired = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.isPaired);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.pairedState))) {
                this.pairedState = (PairedState)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.pairedState));
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
        }

        private Builder(PhoneBluetoothDeviceScanned other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.macAddressHash)) {
                this.macAddressHash = (ByteBuffer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.macAddressHash);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.hashSaltReference)) {
                this.hashSaltReference = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.hashSaltReference);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.isPaired)) {
                this.isPaired = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.isPaired);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)((Object)other.pairedState))) {
                this.pairedState = (PairedState)((Object)this.data().deepCopy(this.fields()[5].schema(), (Object)other.pairedState));
                this.fieldSetFlags()[5] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public ByteBuffer getMacAddressHash() {
            return this.macAddressHash;
        }

        public Builder setMacAddressHash(ByteBuffer value) {
            this.validate(this.fields()[2], value);
            this.macAddressHash = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasMacAddressHash() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearMacAddressHash() {
            this.macAddressHash = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getHashSaltReference() {
            return this.hashSaltReference;
        }

        public Builder setHashSaltReference(Integer value) {
            this.validate(this.fields()[3], value);
            this.hashSaltReference = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasHashSaltReference() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearHashSaltReference() {
            this.hashSaltReference = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Boolean getIsPaired() {
            return this.isPaired;
        }

        public Builder setIsPaired(Boolean value) {
            this.validate(this.fields()[4], value);
            this.isPaired = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasIsPaired() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearIsPaired() {
            this.isPaired = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public PairedState getPairedState() {
            return this.pairedState;
        }

        public Builder setPairedState(PairedState value) {
            this.validate(this.fields()[5], (Object)value);
            this.pairedState = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasPairedState() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearPairedState() {
            this.pairedState = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public PhoneBluetoothDeviceScanned build() {
            try {
                PhoneBluetoothDeviceScanned record = new PhoneBluetoothDeviceScanned();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.macAddressHash = this.fieldSetFlags()[2] ? this.macAddressHash : (ByteBuffer)this.defaultValue(this.fields()[2]);
                record.hashSaltReference = this.fieldSetFlags()[3] ? this.hashSaltReference : (Integer)this.defaultValue(this.fields()[3]);
                record.isPaired = this.fieldSetFlags()[4] ? this.isPaired : (Boolean)this.defaultValue(this.fields()[4]);
                record.pairedState = this.fieldSetFlags()[5] ? this.pairedState : (PairedState)((Object)this.defaultValue(this.fields()[5]));
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

