/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminBodyComposition
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -900027890376546625L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminBodyComposition\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Body Composition summaries contain information about the user\u2019s biometric data, like weight or body mass index. This data can be generated three ways. Users can manually enter their weight on Garmin Connect. This results in a summary with only time and weight. Users may also connect their MyFitnessPal account to their Garmin Connect account and update their weight on MyFitnessPal. This results in a summary that also just has a time and weight. Finally, a user might have a Garmin Index body composition scale and sync data from this device. This will generate a summary with all possible biometric fields.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"muscleMass\",\"type\":[\"null\",\"int\"],\"doc\":\"Muscle mass in grams.\",\"default\":null},{\"name\":\"boneMass\",\"type\":[\"null\",\"int\"],\"doc\":\"Bone mass in grams.\",\"default\":null},{\"name\":\"measurementTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"bodyWater\",\"type\":[\"null\",\"float\"],\"doc\":\"Percentage of body water (range 0.0 - 100.0).\",\"default\":null},{\"name\":\"bodyFat\",\"type\":[\"null\",\"float\"],\"doc\":\"Percentage of body fat. (range 0.0 - 100.0).\",\"default\":null},{\"name\":\"bodyMassIndex\",\"type\":[\"null\",\"float\"],\"doc\":\"Body mass index, or BMI.\",\"default\":null},{\"name\":\"weight\",\"type\":[\"null\",\"int\"],\"doc\":\"Weight in grams.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminBodyComposition> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminBodyComposition> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private Integer muscleMass;
    private Integer boneMass;
    private Integer measurementTimeOffset;
    private Float bodyWater;
    private Float bodyFat;
    private Float bodyMassIndex;
    private Integer weight;
    private static final DatumWriter<GarminBodyComposition> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminBodyComposition> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminBodyComposition> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminBodyComposition> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminBodyComposition> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminBodyComposition fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminBodyComposition)((Object)DECODER.decode(b));
    }

    public GarminBodyComposition() {
    }

    public GarminBodyComposition(Double time, Double timeReceived, String summaryId, Integer muscleMass, Integer boneMass, Integer measurementTimeOffset, Float bodyWater, Float bodyFat, Float bodyMassIndex, Integer weight) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.muscleMass = muscleMass;
        this.boneMass = boneMass;
        this.measurementTimeOffset = measurementTimeOffset;
        this.bodyWater = bodyWater;
        this.bodyFat = bodyFat;
        this.bodyMassIndex = bodyMassIndex;
        this.weight = weight;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.muscleMass;
            }
            case 4: {
                return this.boneMass;
            }
            case 5: {
                return this.measurementTimeOffset;
            }
            case 6: {
                return this.bodyWater;
            }
            case 7: {
                return this.bodyFat;
            }
            case 8: {
                return this.bodyMassIndex;
            }
            case 9: {
                return this.weight;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.muscleMass = (Integer)value$;
                break;
            }
            case 4: {
                this.boneMass = (Integer)value$;
                break;
            }
            case 5: {
                this.measurementTimeOffset = (Integer)value$;
                break;
            }
            case 6: {
                this.bodyWater = (Float)value$;
                break;
            }
            case 7: {
                this.bodyFat = (Float)value$;
                break;
            }
            case 8: {
                this.bodyMassIndex = (Float)value$;
                break;
            }
            case 9: {
                this.weight = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public Integer getMuscleMass() {
        return this.muscleMass;
    }

    public void setMuscleMass(Integer value) {
        this.muscleMass = value;
    }

    public Integer getBoneMass() {
        return this.boneMass;
    }

    public void setBoneMass(Integer value) {
        this.boneMass = value;
    }

    public Integer getMeasurementTimeOffset() {
        return this.measurementTimeOffset;
    }

    public void setMeasurementTimeOffset(Integer value) {
        this.measurementTimeOffset = value;
    }

    public Float getBodyWater() {
        return this.bodyWater;
    }

    public void setBodyWater(Float value) {
        this.bodyWater = value;
    }

    public Float getBodyFat() {
        return this.bodyFat;
    }

    public void setBodyFat(Float value) {
        this.bodyFat = value;
    }

    public Float getBodyMassIndex() {
        return this.bodyMassIndex;
    }

    public void setBodyMassIndex(Float value) {
        this.bodyMassIndex = value;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer value) {
        this.weight = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminBodyComposition other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.muscleMass == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.muscleMass.intValue());
        }
        if (this.boneMass == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.boneMass.intValue());
        }
        if (this.measurementTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.measurementTimeOffset.intValue());
        }
        if (this.bodyWater == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.bodyWater.floatValue());
        }
        if (this.bodyFat == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.bodyFat.floatValue());
        }
        if (this.bodyMassIndex == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.bodyMassIndex.floatValue());
        }
        if (this.weight == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.weight.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.muscleMass = null;
            } else {
                this.muscleMass = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.boneMass = null;
            } else {
                this.boneMass = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.measurementTimeOffset = null;
            } else {
                this.measurementTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bodyWater = null;
            } else {
                this.bodyWater = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bodyFat = null;
            } else {
                this.bodyFat = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bodyMassIndex = null;
            } else {
                this.bodyMassIndex = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.weight = null;
            } else {
                this.weight = in.readInt();
            }
        } else {
            block12: for (int i = 0; i < 10; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block12;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block12;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block12;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.muscleMass = null;
                            continue block12;
                        }
                        this.muscleMass = in.readInt();
                        continue block12;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.boneMass = null;
                            continue block12;
                        }
                        this.boneMass = in.readInt();
                        continue block12;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.measurementTimeOffset = null;
                            continue block12;
                        }
                        this.measurementTimeOffset = in.readInt();
                        continue block12;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bodyWater = null;
                            continue block12;
                        }
                        this.bodyWater = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bodyFat = null;
                            continue block12;
                        }
                        this.bodyFat = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bodyMassIndex = null;
                            continue block12;
                        }
                        this.bodyMassIndex = Float.valueOf(in.readFloat());
                        continue block12;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.weight = null;
                            continue block12;
                        }
                        this.weight = in.readInt();
                        continue block12;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminBodyComposition>
    implements RecordBuilder<GarminBodyComposition> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private Integer muscleMass;
        private Integer boneMass;
        private Integer measurementTimeOffset;
        private Float bodyWater;
        private Float bodyFat;
        private Float bodyMassIndex;
        private Integer weight;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.muscleMass)) {
                this.muscleMass = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.muscleMass);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.boneMass)) {
                this.boneMass = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.boneMass);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.measurementTimeOffset)) {
                this.measurementTimeOffset = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.measurementTimeOffset);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.bodyWater)) {
                this.bodyWater = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.bodyWater);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.bodyFat)) {
                this.bodyFat = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.bodyFat);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.bodyMassIndex)) {
                this.bodyMassIndex = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.bodyMassIndex);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.weight)) {
                this.weight = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.weight);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
        }

        private Builder(GarminBodyComposition other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.muscleMass)) {
                this.muscleMass = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.muscleMass);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.boneMass)) {
                this.boneMass = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.boneMass);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.measurementTimeOffset)) {
                this.measurementTimeOffset = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.measurementTimeOffset);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.bodyWater)) {
                this.bodyWater = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.bodyWater);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.bodyFat)) {
                this.bodyFat = (Float)this.data().deepCopy(this.fields()[7].schema(), (Object)other.bodyFat);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.bodyMassIndex)) {
                this.bodyMassIndex = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.bodyMassIndex);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.weight)) {
                this.weight = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.weight);
                this.fieldSetFlags()[9] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getMuscleMass() {
            return this.muscleMass;
        }

        public Builder setMuscleMass(Integer value) {
            this.validate(this.fields()[3], value);
            this.muscleMass = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasMuscleMass() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearMuscleMass() {
            this.muscleMass = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getBoneMass() {
            return this.boneMass;
        }

        public Builder setBoneMass(Integer value) {
            this.validate(this.fields()[4], value);
            this.boneMass = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasBoneMass() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearBoneMass() {
            this.boneMass = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getMeasurementTimeOffset() {
            return this.measurementTimeOffset;
        }

        public Builder setMeasurementTimeOffset(Integer value) {
            this.validate(this.fields()[5], value);
            this.measurementTimeOffset = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasMeasurementTimeOffset() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearMeasurementTimeOffset() {
            this.measurementTimeOffset = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getBodyWater() {
            return this.bodyWater;
        }

        public Builder setBodyWater(Float value) {
            this.validate(this.fields()[6], value);
            this.bodyWater = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasBodyWater() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearBodyWater() {
            this.bodyWater = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Float getBodyFat() {
            return this.bodyFat;
        }

        public Builder setBodyFat(Float value) {
            this.validate(this.fields()[7], value);
            this.bodyFat = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasBodyFat() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearBodyFat() {
            this.bodyFat = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getBodyMassIndex() {
            return this.bodyMassIndex;
        }

        public Builder setBodyMassIndex(Float value) {
            this.validate(this.fields()[8], value);
            this.bodyMassIndex = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasBodyMassIndex() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearBodyMassIndex() {
            this.bodyMassIndex = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public Builder setWeight(Integer value) {
            this.validate(this.fields()[9], value);
            this.weight = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasWeight() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearWeight() {
            this.weight = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public GarminBodyComposition build() {
            try {
                GarminBodyComposition record = new GarminBodyComposition();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.muscleMass = this.fieldSetFlags()[3] ? this.muscleMass : (Integer)this.defaultValue(this.fields()[3]);
                record.boneMass = this.fieldSetFlags()[4] ? this.boneMass : (Integer)this.defaultValue(this.fields()[4]);
                record.measurementTimeOffset = this.fieldSetFlags()[5] ? this.measurementTimeOffset : (Integer)this.defaultValue(this.fields()[5]);
                record.bodyWater = this.fieldSetFlags()[6] ? this.bodyWater : (Float)this.defaultValue(this.fields()[6]);
                record.bodyFat = this.fieldSetFlags()[7] ? this.bodyFat : (Float)this.defaultValue(this.fields()[7]);
                record.bodyMassIndex = this.fieldSetFlags()[8] ? this.bodyMassIndex : (Float)this.defaultValue(this.fields()[8]);
                record.weight = this.fieldSetFlags()[9] ? this.weight : (Integer)this.defaultValue(this.fields()[9]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

