/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminDailySummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 8000211548883211299L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminDailySummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Daily summaries offer a high-level view of the user\u2019s entire day. They generally correspond to the data found on the \u201cMy Day\u201d section of Garmin Connect. Daily summaries are the most commonly used and are often the foundation of a Health API integration.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the activity in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"activityType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"This field is included in daily summaries for backwards compatibility purposes. It can be ignored and will always default to WALKING.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"Length of the monitoring period in seconds. 86400 once a full day is complete, but less if a user syncs mid-day.\",\"default\":null},{\"name\":\"steps\",\"type\":[\"null\",\"int\"],\"doc\":\"Count of steps recorded during the monitoring period.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"float\"],\"doc\":\"Distance traveled in meters.\",\"default\":null},{\"name\":\"activeTime\",\"type\":[\"null\",\"int\"],\"doc\":\"Portion of the monitoring period (in seconds) in which the device wearer was considered Active. This relies on heuristics internal to each device.\",\"default\":null},{\"name\":\"activeKilocalories\",\"type\":[\"null\",\"int\"],\"doc\":\"Active kilocalories (dietary calories) burned through actual movement and activity during the monitoring period. This includes only the calories burned by the activity and not calories burned as part of the basal metabolic rate (BMR).\",\"default\":null},{\"name\":\"bmrKilocalories\",\"type\":[\"null\",\"int\"],\"doc\":\"BMR Kilocalories burned by existing Basal Metabolic Rate (calculated based on user height/weight/age/other demographic data).\",\"default\":null},{\"name\":\"consumedCalories\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of calories that have been consumed by the user through food for that day (value subtracted from calorie goal). This value is received from MyFitnessPal and is not entered within Connect.\",\"default\":null},{\"name\":\"moderateIntensityDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Cumulative duration of activities of moderate intensity, lasting at least 600 seconds at a time. Moderate intensity is defined as activity with MET value range 3-6.\",\"default\":null},{\"name\":\"vigorousIntensityDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"Cumulative duration of activities of vigorous intensity, lasting at least 600 seconds at a time. Vigorous intensity is defined as activity with MET value greater than 6.\",\"default\":null},{\"name\":\"floorsClimbed\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of floors climbed during the monitoring period.\",\"default\":null},{\"name\":\"minHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Minimum of heart rate values captured during the monitoring period, in beats per minute.\",\"default\":null},{\"name\":\"averageHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Average of heart rate values captured during the last 7 days, in beats per minute. The average heart rate value for the monitoring period can be calculated based on the data from timeOffsetHeartRateSamples.\",\"default\":null},{\"name\":\"maxHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Maximum of heart rate values captured during the monitoring period, in beats per minute.\",\"default\":null},{\"name\":\"restingHeartRate\",\"type\":[\"null\",\"int\"],\"doc\":\"Average heart rate at rest during the monitoring period, in beats per minute.\",\"default\":null},{\"name\":\"averageStressLevel\",\"type\":[\"null\",\"int\"],\"doc\":\"An abstraction of the user\u2019s average stress level in this monitoring period, measured from 1 to 100, or -1 if there is not enough data to calculate average stress. Scores between 1 and 25 are considered \u201crest\u201d (i.e not stressful), 26-50 as \u201clow\u201d stress, 51-75 \u201cmedium\u201d stress, and 76-100 as \u201chigh\u201d stress.\",\"default\":null},{\"name\":\"maxStressLevel\",\"type\":[\"null\",\"int\"],\"doc\":\"The highest stress level measurement taken during this monitoring period.\",\"default\":null},{\"name\":\"stressDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of seconds in this monitoring period where stress level measurements were in the stressful range (26-100).\",\"default\":null},{\"name\":\"restStressDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of seconds in this monitoring period where stress level measurements were in the restful range (1 to 25).\",\"default\":null},{\"name\":\"activityStressDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of seconds in this monitoring period where the user was engaging in physical activity and so stress measurement was unreliable. All duration in this monitoring period not covered by stress, rest, and activity stress should be considered Uncategorized, either because the device was not worn or because not enough data could be taken to generate a stress score.\",\"default\":null},{\"name\":\"lowStressDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The portion of the user\u2019s stress duration where the measured stress score was in the low range (26-50).\",\"default\":null},{\"name\":\"mediumStressDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The portion of the user\u2019s stress duration where the measured stress score was in the medium range (51-75).\",\"default\":null},{\"name\":\"highStressDuration\",\"type\":[\"null\",\"int\"],\"doc\":\"The portion of the user\u2019s stress duration where the measured stress score was in the high range (76-100).\",\"default\":null},{\"name\":\"stressQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualitative label applied based on all stress measurements in this monitoring period. Possible values: unknown, calm, balanced, stressful, very_stressful, calm_awake, balanced_awake, stressful_awake, very_stressful_awake. This matches what the user will see in Garmin Connect. It is recommended that implementations that use the stressQualifier be tolerant of unknown values in case more granular values are added.\",\"default\":null},{\"name\":\"stepsGoal\",\"type\":[\"null\",\"int\"],\"doc\":\"The user\u2019s steps goal for this monitoring period.\",\"default\":null},{\"name\":\"netKilocaloriesGoal\",\"type\":[\"null\",\"int\"],\"doc\":\"The user\u2019s goal for net caloric intake (consumed calories minus active calories) for this monitoring period. This field is related to integration with MyFitnessPal and may not be present for many users.\",\"default\":null},{\"name\":\"intensityDurationGoal\",\"type\":[\"null\",\"int\"],\"doc\":\"The user\u2019s goal for consecutive seconds of moderate to vigorous intensity activity for this monitoring period.\",\"default\":null},{\"name\":\"floorsClimbedGoal\",\"type\":[\"null\",\"int\"],\"doc\":\"The user\u2019s goal for floors climbed in this monitoring period.\",\"default\":null},{\"name\":\"source\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of the source of the third party data. For example FITBIT. Only present in Third Party summaries.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminDailySummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminDailySummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private String date;
    private Integer startTimeOffset;
    private String activityType;
    private Integer duration;
    private Integer steps;
    private Float distance;
    private Integer activeTime;
    private Integer activeKilocalories;
    private Integer bmrKilocalories;
    private Integer consumedCalories;
    private Integer moderateIntensityDuration;
    private Integer vigorousIntensityDuration;
    private Integer floorsClimbed;
    private Integer minHeartRate;
    private Integer averageHeartRate;
    private Integer maxHeartRate;
    private Integer restingHeartRate;
    private Integer averageStressLevel;
    private Integer maxStressLevel;
    private Integer stressDuration;
    private Integer restStressDuration;
    private Integer activityStressDuration;
    private Integer lowStressDuration;
    private Integer mediumStressDuration;
    private Integer highStressDuration;
    private String stressQualifier;
    private Integer stepsGoal;
    private Integer netKilocaloriesGoal;
    private Integer intensityDurationGoal;
    private Integer floorsClimbedGoal;
    private String source;
    private static final DatumWriter<GarminDailySummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminDailySummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminDailySummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminDailySummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminDailySummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminDailySummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminDailySummary)((Object)DECODER.decode(b));
    }

    public GarminDailySummary() {
    }

    public GarminDailySummary(Double time, Double timeReceived, String summaryId, String date, Integer startTimeOffset, String activityType, Integer duration, Integer steps, Float distance, Integer activeTime, Integer activeKilocalories, Integer bmrKilocalories, Integer consumedCalories, Integer moderateIntensityDuration, Integer vigorousIntensityDuration, Integer floorsClimbed, Integer minHeartRate, Integer averageHeartRate, Integer maxHeartRate, Integer restingHeartRate, Integer averageStressLevel, Integer maxStressLevel, Integer stressDuration, Integer restStressDuration, Integer activityStressDuration, Integer lowStressDuration, Integer mediumStressDuration, Integer highStressDuration, String stressQualifier, Integer stepsGoal, Integer netKilocaloriesGoal, Integer intensityDurationGoal, Integer floorsClimbedGoal, String source) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.startTimeOffset = startTimeOffset;
        this.activityType = activityType;
        this.duration = duration;
        this.steps = steps;
        this.distance = distance;
        this.activeTime = activeTime;
        this.activeKilocalories = activeKilocalories;
        this.bmrKilocalories = bmrKilocalories;
        this.consumedCalories = consumedCalories;
        this.moderateIntensityDuration = moderateIntensityDuration;
        this.vigorousIntensityDuration = vigorousIntensityDuration;
        this.floorsClimbed = floorsClimbed;
        this.minHeartRate = minHeartRate;
        this.averageHeartRate = averageHeartRate;
        this.maxHeartRate = maxHeartRate;
        this.restingHeartRate = restingHeartRate;
        this.averageStressLevel = averageStressLevel;
        this.maxStressLevel = maxStressLevel;
        this.stressDuration = stressDuration;
        this.restStressDuration = restStressDuration;
        this.activityStressDuration = activityStressDuration;
        this.lowStressDuration = lowStressDuration;
        this.mediumStressDuration = mediumStressDuration;
        this.highStressDuration = highStressDuration;
        this.stressQualifier = stressQualifier;
        this.stepsGoal = stepsGoal;
        this.netKilocaloriesGoal = netKilocaloriesGoal;
        this.intensityDurationGoal = intensityDurationGoal;
        this.floorsClimbedGoal = floorsClimbedGoal;
        this.source = source;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.startTimeOffset;
            }
            case 5: {
                return this.activityType;
            }
            case 6: {
                return this.duration;
            }
            case 7: {
                return this.steps;
            }
            case 8: {
                return this.distance;
            }
            case 9: {
                return this.activeTime;
            }
            case 10: {
                return this.activeKilocalories;
            }
            case 11: {
                return this.bmrKilocalories;
            }
            case 12: {
                return this.consumedCalories;
            }
            case 13: {
                return this.moderateIntensityDuration;
            }
            case 14: {
                return this.vigorousIntensityDuration;
            }
            case 15: {
                return this.floorsClimbed;
            }
            case 16: {
                return this.minHeartRate;
            }
            case 17: {
                return this.averageHeartRate;
            }
            case 18: {
                return this.maxHeartRate;
            }
            case 19: {
                return this.restingHeartRate;
            }
            case 20: {
                return this.averageStressLevel;
            }
            case 21: {
                return this.maxStressLevel;
            }
            case 22: {
                return this.stressDuration;
            }
            case 23: {
                return this.restStressDuration;
            }
            case 24: {
                return this.activityStressDuration;
            }
            case 25: {
                return this.lowStressDuration;
            }
            case 26: {
                return this.mediumStressDuration;
            }
            case 27: {
                return this.highStressDuration;
            }
            case 28: {
                return this.stressQualifier;
            }
            case 29: {
                return this.stepsGoal;
            }
            case 30: {
                return this.netKilocaloriesGoal;
            }
            case 31: {
                return this.intensityDurationGoal;
            }
            case 32: {
                return this.floorsClimbedGoal;
            }
            case 33: {
                return this.source;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 5: {
                this.activityType = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.duration = (Integer)value$;
                break;
            }
            case 7: {
                this.steps = (Integer)value$;
                break;
            }
            case 8: {
                this.distance = (Float)value$;
                break;
            }
            case 9: {
                this.activeTime = (Integer)value$;
                break;
            }
            case 10: {
                this.activeKilocalories = (Integer)value$;
                break;
            }
            case 11: {
                this.bmrKilocalories = (Integer)value$;
                break;
            }
            case 12: {
                this.consumedCalories = (Integer)value$;
                break;
            }
            case 13: {
                this.moderateIntensityDuration = (Integer)value$;
                break;
            }
            case 14: {
                this.vigorousIntensityDuration = (Integer)value$;
                break;
            }
            case 15: {
                this.floorsClimbed = (Integer)value$;
                break;
            }
            case 16: {
                this.minHeartRate = (Integer)value$;
                break;
            }
            case 17: {
                this.averageHeartRate = (Integer)value$;
                break;
            }
            case 18: {
                this.maxHeartRate = (Integer)value$;
                break;
            }
            case 19: {
                this.restingHeartRate = (Integer)value$;
                break;
            }
            case 20: {
                this.averageStressLevel = (Integer)value$;
                break;
            }
            case 21: {
                this.maxStressLevel = (Integer)value$;
                break;
            }
            case 22: {
                this.stressDuration = (Integer)value$;
                break;
            }
            case 23: {
                this.restStressDuration = (Integer)value$;
                break;
            }
            case 24: {
                this.activityStressDuration = (Integer)value$;
                break;
            }
            case 25: {
                this.lowStressDuration = (Integer)value$;
                break;
            }
            case 26: {
                this.mediumStressDuration = (Integer)value$;
                break;
            }
            case 27: {
                this.highStressDuration = (Integer)value$;
                break;
            }
            case 28: {
                this.stressQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 29: {
                this.stepsGoal = (Integer)value$;
                break;
            }
            case 30: {
                this.netKilocaloriesGoal = (Integer)value$;
                break;
            }
            case 31: {
                this.intensityDurationGoal = (Integer)value$;
                break;
            }
            case 32: {
                this.floorsClimbedGoal = (Integer)value$;
                break;
            }
            case 33: {
                this.source = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String value) {
        this.activityType = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public void setSteps(Integer value) {
        this.steps = value;
    }

    public Float getDistance() {
        return this.distance;
    }

    public void setDistance(Float value) {
        this.distance = value;
    }

    public Integer getActiveTime() {
        return this.activeTime;
    }

    public void setActiveTime(Integer value) {
        this.activeTime = value;
    }

    public Integer getActiveKilocalories() {
        return this.activeKilocalories;
    }

    public void setActiveKilocalories(Integer value) {
        this.activeKilocalories = value;
    }

    public Integer getBmrKilocalories() {
        return this.bmrKilocalories;
    }

    public void setBmrKilocalories(Integer value) {
        this.bmrKilocalories = value;
    }

    public Integer getConsumedCalories() {
        return this.consumedCalories;
    }

    public void setConsumedCalories(Integer value) {
        this.consumedCalories = value;
    }

    public Integer getModerateIntensityDuration() {
        return this.moderateIntensityDuration;
    }

    public void setModerateIntensityDuration(Integer value) {
        this.moderateIntensityDuration = value;
    }

    public Integer getVigorousIntensityDuration() {
        return this.vigorousIntensityDuration;
    }

    public void setVigorousIntensityDuration(Integer value) {
        this.vigorousIntensityDuration = value;
    }

    public Integer getFloorsClimbed() {
        return this.floorsClimbed;
    }

    public void setFloorsClimbed(Integer value) {
        this.floorsClimbed = value;
    }

    public Integer getMinHeartRate() {
        return this.minHeartRate;
    }

    public void setMinHeartRate(Integer value) {
        this.minHeartRate = value;
    }

    public Integer getAverageHeartRate() {
        return this.averageHeartRate;
    }

    public void setAverageHeartRate(Integer value) {
        this.averageHeartRate = value;
    }

    public Integer getMaxHeartRate() {
        return this.maxHeartRate;
    }

    public void setMaxHeartRate(Integer value) {
        this.maxHeartRate = value;
    }

    public Integer getRestingHeartRate() {
        return this.restingHeartRate;
    }

    public void setRestingHeartRate(Integer value) {
        this.restingHeartRate = value;
    }

    public Integer getAverageStressLevel() {
        return this.averageStressLevel;
    }

    public void setAverageStressLevel(Integer value) {
        this.averageStressLevel = value;
    }

    public Integer getMaxStressLevel() {
        return this.maxStressLevel;
    }

    public void setMaxStressLevel(Integer value) {
        this.maxStressLevel = value;
    }

    public Integer getStressDuration() {
        return this.stressDuration;
    }

    public void setStressDuration(Integer value) {
        this.stressDuration = value;
    }

    public Integer getRestStressDuration() {
        return this.restStressDuration;
    }

    public void setRestStressDuration(Integer value) {
        this.restStressDuration = value;
    }

    public Integer getActivityStressDuration() {
        return this.activityStressDuration;
    }

    public void setActivityStressDuration(Integer value) {
        this.activityStressDuration = value;
    }

    public Integer getLowStressDuration() {
        return this.lowStressDuration;
    }

    public void setLowStressDuration(Integer value) {
        this.lowStressDuration = value;
    }

    public Integer getMediumStressDuration() {
        return this.mediumStressDuration;
    }

    public void setMediumStressDuration(Integer value) {
        this.mediumStressDuration = value;
    }

    public Integer getHighStressDuration() {
        return this.highStressDuration;
    }

    public void setHighStressDuration(Integer value) {
        this.highStressDuration = value;
    }

    public String getStressQualifier() {
        return this.stressQualifier;
    }

    public void setStressQualifier(String value) {
        this.stressQualifier = value;
    }

    public Integer getStepsGoal() {
        return this.stepsGoal;
    }

    public void setStepsGoal(Integer value) {
        this.stepsGoal = value;
    }

    public Integer getNetKilocaloriesGoal() {
        return this.netKilocaloriesGoal;
    }

    public void setNetKilocaloriesGoal(Integer value) {
        this.netKilocaloriesGoal = value;
    }

    public Integer getIntensityDurationGoal() {
        return this.intensityDurationGoal;
    }

    public void setIntensityDurationGoal(Integer value) {
        this.intensityDurationGoal = value;
    }

    public Integer getFloorsClimbedGoal() {
        return this.floorsClimbedGoal;
    }

    public void setFloorsClimbedGoal(Integer value) {
        this.floorsClimbedGoal = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminDailySummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.activityType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.activityType);
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
        if (this.steps == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.steps.intValue());
        }
        if (this.distance == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.distance.floatValue());
        }
        if (this.activeTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activeTime.intValue());
        }
        if (this.activeKilocalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activeKilocalories.intValue());
        }
        if (this.bmrKilocalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.bmrKilocalories.intValue());
        }
        if (this.consumedCalories == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.consumedCalories.intValue());
        }
        if (this.moderateIntensityDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.moderateIntensityDuration.intValue());
        }
        if (this.vigorousIntensityDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.vigorousIntensityDuration.intValue());
        }
        if (this.floorsClimbed == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.floorsClimbed.intValue());
        }
        if (this.minHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.minHeartRate.intValue());
        }
        if (this.averageHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.averageHeartRate.intValue());
        }
        if (this.maxHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.maxHeartRate.intValue());
        }
        if (this.restingHeartRate == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.restingHeartRate.intValue());
        }
        if (this.averageStressLevel == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.averageStressLevel.intValue());
        }
        if (this.maxStressLevel == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.maxStressLevel.intValue());
        }
        if (this.stressDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.stressDuration.intValue());
        }
        if (this.restStressDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.restStressDuration.intValue());
        }
        if (this.activityStressDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.activityStressDuration.intValue());
        }
        if (this.lowStressDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.lowStressDuration.intValue());
        }
        if (this.mediumStressDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.mediumStressDuration.intValue());
        }
        if (this.highStressDuration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.highStressDuration.intValue());
        }
        if (this.stressQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.stressQualifier);
        }
        if (this.stepsGoal == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.stepsGoal.intValue());
        }
        if (this.netKilocaloriesGoal == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.netKilocaloriesGoal.intValue());
        }
        if (this.intensityDurationGoal == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.intensityDurationGoal.intValue());
        }
        if (this.floorsClimbedGoal == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.floorsClimbedGoal.intValue());
        }
        if (this.source == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.source);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activityType = null;
            } else {
                this.activityType = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.steps = null;
            } else {
                this.steps = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.distance = null;
            } else {
                this.distance = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activeTime = null;
            } else {
                this.activeTime = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activeKilocalories = null;
            } else {
                this.activeKilocalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.bmrKilocalories = null;
            } else {
                this.bmrKilocalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.consumedCalories = null;
            } else {
                this.consumedCalories = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.moderateIntensityDuration = null;
            } else {
                this.moderateIntensityDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.vigorousIntensityDuration = null;
            } else {
                this.vigorousIntensityDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.floorsClimbed = null;
            } else {
                this.floorsClimbed = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.minHeartRate = null;
            } else {
                this.minHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageHeartRate = null;
            } else {
                this.averageHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxHeartRate = null;
            } else {
                this.maxHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.restingHeartRate = null;
            } else {
                this.restingHeartRate = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.averageStressLevel = null;
            } else {
                this.averageStressLevel = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.maxStressLevel = null;
            } else {
                this.maxStressLevel = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stressDuration = null;
            } else {
                this.stressDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.restStressDuration = null;
            } else {
                this.restStressDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.activityStressDuration = null;
            } else {
                this.activityStressDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lowStressDuration = null;
            } else {
                this.lowStressDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.mediumStressDuration = null;
            } else {
                this.mediumStressDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.highStressDuration = null;
            } else {
                this.highStressDuration = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stressQualifier = null;
            } else {
                this.stressQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stepsGoal = null;
            } else {
                this.stepsGoal = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.netKilocaloriesGoal = null;
            } else {
                this.netKilocaloriesGoal = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.intensityDurationGoal = null;
            } else {
                this.intensityDurationGoal = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.floorsClimbedGoal = null;
            } else {
                this.floorsClimbedGoal = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.source = null;
            } else {
                this.source = in.readString();
            }
        } else {
            block36: for (int i = 0; i < 34; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block36;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block36;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block36;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block36;
                        }
                        this.date = in.readString();
                        continue block36;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block36;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block36;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activityType = null;
                            continue block36;
                        }
                        this.activityType = in.readString();
                        continue block36;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block36;
                        }
                        this.duration = in.readInt();
                        continue block36;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.steps = null;
                            continue block36;
                        }
                        this.steps = in.readInt();
                        continue block36;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.distance = null;
                            continue block36;
                        }
                        this.distance = Float.valueOf(in.readFloat());
                        continue block36;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activeTime = null;
                            continue block36;
                        }
                        this.activeTime = in.readInt();
                        continue block36;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activeKilocalories = null;
                            continue block36;
                        }
                        this.activeKilocalories = in.readInt();
                        continue block36;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.bmrKilocalories = null;
                            continue block36;
                        }
                        this.bmrKilocalories = in.readInt();
                        continue block36;
                    }
                    case 12: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.consumedCalories = null;
                            continue block36;
                        }
                        this.consumedCalories = in.readInt();
                        continue block36;
                    }
                    case 13: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.moderateIntensityDuration = null;
                            continue block36;
                        }
                        this.moderateIntensityDuration = in.readInt();
                        continue block36;
                    }
                    case 14: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.vigorousIntensityDuration = null;
                            continue block36;
                        }
                        this.vigorousIntensityDuration = in.readInt();
                        continue block36;
                    }
                    case 15: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.floorsClimbed = null;
                            continue block36;
                        }
                        this.floorsClimbed = in.readInt();
                        continue block36;
                    }
                    case 16: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.minHeartRate = null;
                            continue block36;
                        }
                        this.minHeartRate = in.readInt();
                        continue block36;
                    }
                    case 17: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageHeartRate = null;
                            continue block36;
                        }
                        this.averageHeartRate = in.readInt();
                        continue block36;
                    }
                    case 18: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxHeartRate = null;
                            continue block36;
                        }
                        this.maxHeartRate = in.readInt();
                        continue block36;
                    }
                    case 19: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.restingHeartRate = null;
                            continue block36;
                        }
                        this.restingHeartRate = in.readInt();
                        continue block36;
                    }
                    case 20: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.averageStressLevel = null;
                            continue block36;
                        }
                        this.averageStressLevel = in.readInt();
                        continue block36;
                    }
                    case 21: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.maxStressLevel = null;
                            continue block36;
                        }
                        this.maxStressLevel = in.readInt();
                        continue block36;
                    }
                    case 22: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stressDuration = null;
                            continue block36;
                        }
                        this.stressDuration = in.readInt();
                        continue block36;
                    }
                    case 23: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.restStressDuration = null;
                            continue block36;
                        }
                        this.restStressDuration = in.readInt();
                        continue block36;
                    }
                    case 24: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.activityStressDuration = null;
                            continue block36;
                        }
                        this.activityStressDuration = in.readInt();
                        continue block36;
                    }
                    case 25: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lowStressDuration = null;
                            continue block36;
                        }
                        this.lowStressDuration = in.readInt();
                        continue block36;
                    }
                    case 26: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.mediumStressDuration = null;
                            continue block36;
                        }
                        this.mediumStressDuration = in.readInt();
                        continue block36;
                    }
                    case 27: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.highStressDuration = null;
                            continue block36;
                        }
                        this.highStressDuration = in.readInt();
                        continue block36;
                    }
                    case 28: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stressQualifier = null;
                            continue block36;
                        }
                        this.stressQualifier = in.readString();
                        continue block36;
                    }
                    case 29: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stepsGoal = null;
                            continue block36;
                        }
                        this.stepsGoal = in.readInt();
                        continue block36;
                    }
                    case 30: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.netKilocaloriesGoal = null;
                            continue block36;
                        }
                        this.netKilocaloriesGoal = in.readInt();
                        continue block36;
                    }
                    case 31: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.intensityDurationGoal = null;
                            continue block36;
                        }
                        this.intensityDurationGoal = in.readInt();
                        continue block36;
                    }
                    case 32: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.floorsClimbedGoal = null;
                            continue block36;
                        }
                        this.floorsClimbedGoal = in.readInt();
                        continue block36;
                    }
                    case 33: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.source = null;
                            continue block36;
                        }
                        this.source = in.readString();
                        continue block36;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminDailySummary>
    implements RecordBuilder<GarminDailySummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Integer startTimeOffset;
        private String activityType;
        private Integer duration;
        private Integer steps;
        private Float distance;
        private Integer activeTime;
        private Integer activeKilocalories;
        private Integer bmrKilocalories;
        private Integer consumedCalories;
        private Integer moderateIntensityDuration;
        private Integer vigorousIntensityDuration;
        private Integer floorsClimbed;
        private Integer minHeartRate;
        private Integer averageHeartRate;
        private Integer maxHeartRate;
        private Integer restingHeartRate;
        private Integer averageStressLevel;
        private Integer maxStressLevel;
        private Integer stressDuration;
        private Integer restStressDuration;
        private Integer activityStressDuration;
        private Integer lowStressDuration;
        private Integer mediumStressDuration;
        private Integer highStressDuration;
        private String stressQualifier;
        private Integer stepsGoal;
        private Integer netKilocaloriesGoal;
        private Integer intensityDurationGoal;
        private Integer floorsClimbedGoal;
        private String source;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.activityType);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.duration);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.steps);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.distance);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.activeTime)) {
                this.activeTime = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.activeTime);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.activeKilocalories)) {
                this.activeKilocalories = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.activeKilocalories);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.bmrKilocalories)) {
                this.bmrKilocalories = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.bmrKilocalories);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.consumedCalories)) {
                this.consumedCalories = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.consumedCalories);
                this.fieldSetFlags()[12] = other.fieldSetFlags()[12];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.moderateIntensityDuration)) {
                this.moderateIntensityDuration = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.moderateIntensityDuration);
                this.fieldSetFlags()[13] = other.fieldSetFlags()[13];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.vigorousIntensityDuration)) {
                this.vigorousIntensityDuration = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.vigorousIntensityDuration);
                this.fieldSetFlags()[14] = other.fieldSetFlags()[14];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.floorsClimbed)) {
                this.floorsClimbed = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.floorsClimbed);
                this.fieldSetFlags()[15] = other.fieldSetFlags()[15];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.minHeartRate)) {
                this.minHeartRate = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.minHeartRate);
                this.fieldSetFlags()[16] = other.fieldSetFlags()[16];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.averageHeartRate)) {
                this.averageHeartRate = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.averageHeartRate);
                this.fieldSetFlags()[17] = other.fieldSetFlags()[17];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.maxHeartRate)) {
                this.maxHeartRate = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.maxHeartRate);
                this.fieldSetFlags()[18] = other.fieldSetFlags()[18];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.restingHeartRate)) {
                this.restingHeartRate = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.restingHeartRate);
                this.fieldSetFlags()[19] = other.fieldSetFlags()[19];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.averageStressLevel)) {
                this.averageStressLevel = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.averageStressLevel);
                this.fieldSetFlags()[20] = other.fieldSetFlags()[20];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.maxStressLevel)) {
                this.maxStressLevel = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.maxStressLevel);
                this.fieldSetFlags()[21] = other.fieldSetFlags()[21];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.stressDuration)) {
                this.stressDuration = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.stressDuration);
                this.fieldSetFlags()[22] = other.fieldSetFlags()[22];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.restStressDuration)) {
                this.restStressDuration = (Integer)this.data().deepCopy(this.fields()[23].schema(), (Object)other.restStressDuration);
                this.fieldSetFlags()[23] = other.fieldSetFlags()[23];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.activityStressDuration)) {
                this.activityStressDuration = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.activityStressDuration);
                this.fieldSetFlags()[24] = other.fieldSetFlags()[24];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.lowStressDuration)) {
                this.lowStressDuration = (Integer)this.data().deepCopy(this.fields()[25].schema(), (Object)other.lowStressDuration);
                this.fieldSetFlags()[25] = other.fieldSetFlags()[25];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.mediumStressDuration)) {
                this.mediumStressDuration = (Integer)this.data().deepCopy(this.fields()[26].schema(), (Object)other.mediumStressDuration);
                this.fieldSetFlags()[26] = other.fieldSetFlags()[26];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.highStressDuration)) {
                this.highStressDuration = (Integer)this.data().deepCopy(this.fields()[27].schema(), (Object)other.highStressDuration);
                this.fieldSetFlags()[27] = other.fieldSetFlags()[27];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.stressQualifier)) {
                this.stressQualifier = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.stressQualifier);
                this.fieldSetFlags()[28] = other.fieldSetFlags()[28];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.stepsGoal)) {
                this.stepsGoal = (Integer)this.data().deepCopy(this.fields()[29].schema(), (Object)other.stepsGoal);
                this.fieldSetFlags()[29] = other.fieldSetFlags()[29];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.netKilocaloriesGoal)) {
                this.netKilocaloriesGoal = (Integer)this.data().deepCopy(this.fields()[30].schema(), (Object)other.netKilocaloriesGoal);
                this.fieldSetFlags()[30] = other.fieldSetFlags()[30];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.intensityDurationGoal)) {
                this.intensityDurationGoal = (Integer)this.data().deepCopy(this.fields()[31].schema(), (Object)other.intensityDurationGoal);
                this.fieldSetFlags()[31] = other.fieldSetFlags()[31];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.floorsClimbedGoal)) {
                this.floorsClimbedGoal = (Integer)this.data().deepCopy(this.fields()[32].schema(), (Object)other.floorsClimbedGoal);
                this.fieldSetFlags()[32] = other.fieldSetFlags()[32];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[33].schema(), (Object)other.source);
                this.fieldSetFlags()[33] = other.fieldSetFlags()[33];
            }
        }

        private Builder(GarminDailySummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.activityType)) {
                this.activityType = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.activityType);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.duration);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.steps)) {
                this.steps = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.steps);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.distance)) {
                this.distance = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.distance);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.activeTime)) {
                this.activeTime = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.activeTime);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.activeKilocalories)) {
                this.activeKilocalories = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.activeKilocalories);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.bmrKilocalories)) {
                this.bmrKilocalories = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.bmrKilocalories);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.consumedCalories)) {
                this.consumedCalories = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.consumedCalories);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.moderateIntensityDuration)) {
                this.moderateIntensityDuration = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.moderateIntensityDuration);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.vigorousIntensityDuration)) {
                this.vigorousIntensityDuration = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.vigorousIntensityDuration);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.floorsClimbed)) {
                this.floorsClimbed = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.floorsClimbed);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.minHeartRate)) {
                this.minHeartRate = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.minHeartRate);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.averageHeartRate)) {
                this.averageHeartRate = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.averageHeartRate);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.maxHeartRate)) {
                this.maxHeartRate = (Integer)this.data().deepCopy(this.fields()[18].schema(), (Object)other.maxHeartRate);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.restingHeartRate)) {
                this.restingHeartRate = (Integer)this.data().deepCopy(this.fields()[19].schema(), (Object)other.restingHeartRate);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.averageStressLevel)) {
                this.averageStressLevel = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.averageStressLevel);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.maxStressLevel)) {
                this.maxStressLevel = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.maxStressLevel);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.stressDuration)) {
                this.stressDuration = (Integer)this.data().deepCopy(this.fields()[22].schema(), (Object)other.stressDuration);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.restStressDuration)) {
                this.restStressDuration = (Integer)this.data().deepCopy(this.fields()[23].schema(), (Object)other.restStressDuration);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.activityStressDuration)) {
                this.activityStressDuration = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.activityStressDuration);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.lowStressDuration)) {
                this.lowStressDuration = (Integer)this.data().deepCopy(this.fields()[25].schema(), (Object)other.lowStressDuration);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.mediumStressDuration)) {
                this.mediumStressDuration = (Integer)this.data().deepCopy(this.fields()[26].schema(), (Object)other.mediumStressDuration);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.highStressDuration)) {
                this.highStressDuration = (Integer)this.data().deepCopy(this.fields()[27].schema(), (Object)other.highStressDuration);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.stressQualifier)) {
                this.stressQualifier = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.stressQualifier);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.stepsGoal)) {
                this.stepsGoal = (Integer)this.data().deepCopy(this.fields()[29].schema(), (Object)other.stepsGoal);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.netKilocaloriesGoal)) {
                this.netKilocaloriesGoal = (Integer)this.data().deepCopy(this.fields()[30].schema(), (Object)other.netKilocaloriesGoal);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.intensityDurationGoal)) {
                this.intensityDurationGoal = (Integer)this.data().deepCopy(this.fields()[31].schema(), (Object)other.intensityDurationGoal);
                this.fieldSetFlags()[31] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[32], (Object)other.floorsClimbedGoal)) {
                this.floorsClimbedGoal = (Integer)this.data().deepCopy(this.fields()[32].schema(), (Object)other.floorsClimbedGoal);
                this.fieldSetFlags()[32] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[33], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[33].schema(), (Object)other.source);
                this.fieldSetFlags()[33] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getActivityType() {
            return this.activityType;
        }

        public Builder setActivityType(String value) {
            this.validate(this.fields()[5], value);
            this.activityType = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasActivityType() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearActivityType() {
            this.activityType = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[6], value);
            this.duration = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getSteps() {
            return this.steps;
        }

        public Builder setSteps(Integer value) {
            this.validate(this.fields()[7], value);
            this.steps = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasSteps() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearSteps() {
            this.steps = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getDistance() {
            return this.distance;
        }

        public Builder setDistance(Float value) {
            this.validate(this.fields()[8], value);
            this.distance = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasDistance() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearDistance() {
            this.distance = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getActiveTime() {
            return this.activeTime;
        }

        public Builder setActiveTime(Integer value) {
            this.validate(this.fields()[9], value);
            this.activeTime = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasActiveTime() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearActiveTime() {
            this.activeTime = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getActiveKilocalories() {
            return this.activeKilocalories;
        }

        public Builder setActiveKilocalories(Integer value) {
            this.validate(this.fields()[10], value);
            this.activeKilocalories = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasActiveKilocalories() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearActiveKilocalories() {
            this.activeKilocalories = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getBmrKilocalories() {
            return this.bmrKilocalories;
        }

        public Builder setBmrKilocalories(Integer value) {
            this.validate(this.fields()[11], value);
            this.bmrKilocalories = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasBmrKilocalories() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearBmrKilocalories() {
            this.bmrKilocalories = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getConsumedCalories() {
            return this.consumedCalories;
        }

        public Builder setConsumedCalories(Integer value) {
            this.validate(this.fields()[12], value);
            this.consumedCalories = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasConsumedCalories() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearConsumedCalories() {
            this.consumedCalories = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Integer getModerateIntensityDuration() {
            return this.moderateIntensityDuration;
        }

        public Builder setModerateIntensityDuration(Integer value) {
            this.validate(this.fields()[13], value);
            this.moderateIntensityDuration = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasModerateIntensityDuration() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearModerateIntensityDuration() {
            this.moderateIntensityDuration = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Integer getVigorousIntensityDuration() {
            return this.vigorousIntensityDuration;
        }

        public Builder setVigorousIntensityDuration(Integer value) {
            this.validate(this.fields()[14], value);
            this.vigorousIntensityDuration = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasVigorousIntensityDuration() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearVigorousIntensityDuration() {
            this.vigorousIntensityDuration = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Integer getFloorsClimbed() {
            return this.floorsClimbed;
        }

        public Builder setFloorsClimbed(Integer value) {
            this.validate(this.fields()[15], value);
            this.floorsClimbed = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasFloorsClimbed() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearFloorsClimbed() {
            this.floorsClimbed = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Integer getMinHeartRate() {
            return this.minHeartRate;
        }

        public Builder setMinHeartRate(Integer value) {
            this.validate(this.fields()[16], value);
            this.minHeartRate = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasMinHeartRate() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearMinHeartRate() {
            this.minHeartRate = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getAverageHeartRate() {
            return this.averageHeartRate;
        }

        public Builder setAverageHeartRate(Integer value) {
            this.validate(this.fields()[17], value);
            this.averageHeartRate = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasAverageHeartRate() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearAverageHeartRate() {
            this.averageHeartRate = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Integer getMaxHeartRate() {
            return this.maxHeartRate;
        }

        public Builder setMaxHeartRate(Integer value) {
            this.validate(this.fields()[18], value);
            this.maxHeartRate = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasMaxHeartRate() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearMaxHeartRate() {
            this.maxHeartRate = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Integer getRestingHeartRate() {
            return this.restingHeartRate;
        }

        public Builder setRestingHeartRate(Integer value) {
            this.validate(this.fields()[19], value);
            this.restingHeartRate = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasRestingHeartRate() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearRestingHeartRate() {
            this.restingHeartRate = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Integer getAverageStressLevel() {
            return this.averageStressLevel;
        }

        public Builder setAverageStressLevel(Integer value) {
            this.validate(this.fields()[20], value);
            this.averageStressLevel = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasAverageStressLevel() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearAverageStressLevel() {
            this.averageStressLevel = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Integer getMaxStressLevel() {
            return this.maxStressLevel;
        }

        public Builder setMaxStressLevel(Integer value) {
            this.validate(this.fields()[21], value);
            this.maxStressLevel = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasMaxStressLevel() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearMaxStressLevel() {
            this.maxStressLevel = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Integer getStressDuration() {
            return this.stressDuration;
        }

        public Builder setStressDuration(Integer value) {
            this.validate(this.fields()[22], value);
            this.stressDuration = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasStressDuration() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearStressDuration() {
            this.stressDuration = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Integer getRestStressDuration() {
            return this.restStressDuration;
        }

        public Builder setRestStressDuration(Integer value) {
            this.validate(this.fields()[23], value);
            this.restStressDuration = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasRestStressDuration() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearRestStressDuration() {
            this.restStressDuration = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Integer getActivityStressDuration() {
            return this.activityStressDuration;
        }

        public Builder setActivityStressDuration(Integer value) {
            this.validate(this.fields()[24], value);
            this.activityStressDuration = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasActivityStressDuration() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearActivityStressDuration() {
            this.activityStressDuration = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public Integer getLowStressDuration() {
            return this.lowStressDuration;
        }

        public Builder setLowStressDuration(Integer value) {
            this.validate(this.fields()[25], value);
            this.lowStressDuration = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasLowStressDuration() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearLowStressDuration() {
            this.lowStressDuration = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public Integer getMediumStressDuration() {
            return this.mediumStressDuration;
        }

        public Builder setMediumStressDuration(Integer value) {
            this.validate(this.fields()[26], value);
            this.mediumStressDuration = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasMediumStressDuration() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearMediumStressDuration() {
            this.mediumStressDuration = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public Integer getHighStressDuration() {
            return this.highStressDuration;
        }

        public Builder setHighStressDuration(Integer value) {
            this.validate(this.fields()[27], value);
            this.highStressDuration = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasHighStressDuration() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearHighStressDuration() {
            this.highStressDuration = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public String getStressQualifier() {
            return this.stressQualifier;
        }

        public Builder setStressQualifier(String value) {
            this.validate(this.fields()[28], value);
            this.stressQualifier = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasStressQualifier() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearStressQualifier() {
            this.stressQualifier = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public Integer getStepsGoal() {
            return this.stepsGoal;
        }

        public Builder setStepsGoal(Integer value) {
            this.validate(this.fields()[29], value);
            this.stepsGoal = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasStepsGoal() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearStepsGoal() {
            this.stepsGoal = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public Integer getNetKilocaloriesGoal() {
            return this.netKilocaloriesGoal;
        }

        public Builder setNetKilocaloriesGoal(Integer value) {
            this.validate(this.fields()[30], value);
            this.netKilocaloriesGoal = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasNetKilocaloriesGoal() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearNetKilocaloriesGoal() {
            this.netKilocaloriesGoal = null;
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public Integer getIntensityDurationGoal() {
            return this.intensityDurationGoal;
        }

        public Builder setIntensityDurationGoal(Integer value) {
            this.validate(this.fields()[31], value);
            this.intensityDurationGoal = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasIntensityDurationGoal() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearIntensityDurationGoal() {
            this.intensityDurationGoal = null;
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public Integer getFloorsClimbedGoal() {
            return this.floorsClimbedGoal;
        }

        public Builder setFloorsClimbedGoal(Integer value) {
            this.validate(this.fields()[32], value);
            this.floorsClimbedGoal = value;
            this.fieldSetFlags()[32] = true;
            return this;
        }

        public boolean hasFloorsClimbedGoal() {
            return this.fieldSetFlags()[32];
        }

        public Builder clearFloorsClimbedGoal() {
            this.floorsClimbedGoal = null;
            this.fieldSetFlags()[32] = false;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String value) {
            this.validate(this.fields()[33], value);
            this.source = value;
            this.fieldSetFlags()[33] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[33];
        }

        public Builder clearSource() {
            this.source = null;
            this.fieldSetFlags()[33] = false;
            return this;
        }

        public GarminDailySummary build() {
            try {
                GarminDailySummary record = new GarminDailySummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.startTimeOffset = this.fieldSetFlags()[4] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[4]);
                record.activityType = this.fieldSetFlags()[5] ? this.activityType : (String)this.defaultValue(this.fields()[5]);
                record.duration = this.fieldSetFlags()[6] ? this.duration : (Integer)this.defaultValue(this.fields()[6]);
                record.steps = this.fieldSetFlags()[7] ? this.steps : (Integer)this.defaultValue(this.fields()[7]);
                record.distance = this.fieldSetFlags()[8] ? this.distance : (Float)this.defaultValue(this.fields()[8]);
                record.activeTime = this.fieldSetFlags()[9] ? this.activeTime : (Integer)this.defaultValue(this.fields()[9]);
                record.activeKilocalories = this.fieldSetFlags()[10] ? this.activeKilocalories : (Integer)this.defaultValue(this.fields()[10]);
                record.bmrKilocalories = this.fieldSetFlags()[11] ? this.bmrKilocalories : (Integer)this.defaultValue(this.fields()[11]);
                record.consumedCalories = this.fieldSetFlags()[12] ? this.consumedCalories : (Integer)this.defaultValue(this.fields()[12]);
                record.moderateIntensityDuration = this.fieldSetFlags()[13] ? this.moderateIntensityDuration : (Integer)this.defaultValue(this.fields()[13]);
                record.vigorousIntensityDuration = this.fieldSetFlags()[14] ? this.vigorousIntensityDuration : (Integer)this.defaultValue(this.fields()[14]);
                record.floorsClimbed = this.fieldSetFlags()[15] ? this.floorsClimbed : (Integer)this.defaultValue(this.fields()[15]);
                record.minHeartRate = this.fieldSetFlags()[16] ? this.minHeartRate : (Integer)this.defaultValue(this.fields()[16]);
                record.averageHeartRate = this.fieldSetFlags()[17] ? this.averageHeartRate : (Integer)this.defaultValue(this.fields()[17]);
                record.maxHeartRate = this.fieldSetFlags()[18] ? this.maxHeartRate : (Integer)this.defaultValue(this.fields()[18]);
                record.restingHeartRate = this.fieldSetFlags()[19] ? this.restingHeartRate : (Integer)this.defaultValue(this.fields()[19]);
                record.averageStressLevel = this.fieldSetFlags()[20] ? this.averageStressLevel : (Integer)this.defaultValue(this.fields()[20]);
                record.maxStressLevel = this.fieldSetFlags()[21] ? this.maxStressLevel : (Integer)this.defaultValue(this.fields()[21]);
                record.stressDuration = this.fieldSetFlags()[22] ? this.stressDuration : (Integer)this.defaultValue(this.fields()[22]);
                record.restStressDuration = this.fieldSetFlags()[23] ? this.restStressDuration : (Integer)this.defaultValue(this.fields()[23]);
                record.activityStressDuration = this.fieldSetFlags()[24] ? this.activityStressDuration : (Integer)this.defaultValue(this.fields()[24]);
                record.lowStressDuration = this.fieldSetFlags()[25] ? this.lowStressDuration : (Integer)this.defaultValue(this.fields()[25]);
                record.mediumStressDuration = this.fieldSetFlags()[26] ? this.mediumStressDuration : (Integer)this.defaultValue(this.fields()[26]);
                record.highStressDuration = this.fieldSetFlags()[27] ? this.highStressDuration : (Integer)this.defaultValue(this.fields()[27]);
                record.stressQualifier = this.fieldSetFlags()[28] ? this.stressQualifier : (String)this.defaultValue(this.fields()[28]);
                record.stepsGoal = this.fieldSetFlags()[29] ? this.stepsGoal : (Integer)this.defaultValue(this.fields()[29]);
                record.netKilocaloriesGoal = this.fieldSetFlags()[30] ? this.netKilocaloriesGoal : (Integer)this.defaultValue(this.fields()[30]);
                record.intensityDurationGoal = this.fieldSetFlags()[31] ? this.intensityDurationGoal : (Integer)this.defaultValue(this.fields()[31]);
                record.floorsClimbedGoal = this.fieldSetFlags()[32] ? this.floorsClimbedGoal : (Integer)this.defaultValue(this.fields()[32]);
                record.source = this.fieldSetFlags()[33] ? this.source : (String)this.defaultValue(this.fields()[33]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

