/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminHeartRateVariabilitySummary
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4715385181227808210L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminHeartRateVariabilitySummary\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"Heart rate variability (HRV) refers to beat-to-beat variations in heart rate and is data collected during the overnight sleep window for select devices. To gain a deeper understanding of your overall health, recovery and training performance through heart rate variability while you sleep, based on technology developed by our Firstbeat Analytics team, please visit https://discover.garmin.com/en-US/performance-data/running/#heart-rate-variability.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"lastNightAvg\",\"type\":[\"null\",\"float\"],\"doc\":\"The average heart rate variability value from the last night of data.\",\"default\":null},{\"name\":\"lastNight5MinHigh\",\"type\":[\"null\",\"float\"],\"doc\":\"The maximum HRV value over any 5 minute interval of the last night of data.\",\"default\":null},{\"name\":\"duration\",\"type\":[\"null\",\"int\"],\"doc\":\"The duration of the measurement period in seconds.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminHeartRateVariabilitySummary> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminHeartRateVariabilitySummary> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private String date;
    private Integer startTimeOffset;
    private Float lastNightAvg;
    private Float lastNight5MinHigh;
    private Integer duration;
    private static final DatumWriter<GarminHeartRateVariabilitySummary> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminHeartRateVariabilitySummary> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminHeartRateVariabilitySummary> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminHeartRateVariabilitySummary> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminHeartRateVariabilitySummary> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminHeartRateVariabilitySummary fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminHeartRateVariabilitySummary)((Object)DECODER.decode(b));
    }

    public GarminHeartRateVariabilitySummary() {
    }

    public GarminHeartRateVariabilitySummary(Double time, Double timeReceived, String summaryId, String date, Integer startTimeOffset, Float lastNightAvg, Float lastNight5MinHigh, Integer duration) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.startTimeOffset = startTimeOffset;
        this.lastNightAvg = lastNightAvg;
        this.lastNight5MinHigh = lastNight5MinHigh;
        this.duration = duration;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.startTimeOffset;
            }
            case 5: {
                return this.lastNightAvg;
            }
            case 6: {
                return this.lastNight5MinHigh;
            }
            case 7: {
                return this.duration;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 5: {
                this.lastNightAvg = (Float)value$;
                break;
            }
            case 6: {
                this.lastNight5MinHigh = (Float)value$;
                break;
            }
            case 7: {
                this.duration = (Integer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public Float getLastNightAvg() {
        return this.lastNightAvg;
    }

    public void setLastNightAvg(Float value) {
        this.lastNightAvg = value;
    }

    public Float getLastNight5MinHigh() {
        return this.lastNight5MinHigh;
    }

    public void setLastNight5MinHigh(Float value) {
        this.lastNight5MinHigh = value;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer value) {
        this.duration = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminHeartRateVariabilitySummary other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.lastNightAvg == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.lastNightAvg.floatValue());
        }
        if (this.lastNight5MinHigh == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeFloat(this.lastNight5MinHigh.floatValue());
        }
        if (this.duration == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.duration.intValue());
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lastNightAvg = null;
            } else {
                this.lastNightAvg = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lastNight5MinHigh = null;
            } else {
                this.lastNight5MinHigh = Float.valueOf(in.readFloat());
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.duration = null;
            } else {
                this.duration = in.readInt();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block10;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block10;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block10;
                        }
                        this.date = in.readString();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block10;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lastNightAvg = null;
                            continue block10;
                        }
                        this.lastNightAvg = Float.valueOf(in.readFloat());
                        continue block10;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lastNight5MinHigh = null;
                            continue block10;
                        }
                        this.lastNight5MinHigh = Float.valueOf(in.readFloat());
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.duration = null;
                            continue block10;
                        }
                        this.duration = in.readInt();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminHeartRateVariabilitySummary>
    implements RecordBuilder<GarminHeartRateVariabilitySummary> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Integer startTimeOffset;
        private Float lastNightAvg;
        private Float lastNight5MinHigh;
        private Integer duration;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.lastNightAvg)) {
                this.lastNightAvg = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.lastNightAvg);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.lastNight5MinHigh)) {
                this.lastNight5MinHigh = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.lastNight5MinHigh);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.duration);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(GarminHeartRateVariabilitySummary other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.lastNightAvg)) {
                this.lastNightAvg = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.lastNightAvg);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.lastNight5MinHigh)) {
                this.lastNight5MinHigh = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.lastNight5MinHigh);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.duration)) {
                this.duration = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.duration);
                this.fieldSetFlags()[7] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getLastNightAvg() {
            return this.lastNightAvg;
        }

        public Builder setLastNightAvg(Float value) {
            this.validate(this.fields()[5], value);
            this.lastNightAvg = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasLastNightAvg() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearLastNightAvg() {
            this.lastNightAvg = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getLastNight5MinHigh() {
            return this.lastNight5MinHigh;
        }

        public Builder setLastNight5MinHigh(Float value) {
            this.validate(this.fields()[6], value);
            this.lastNight5MinHigh = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasLastNight5MinHigh() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearLastNight5MinHigh() {
            this.lastNight5MinHigh = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public Builder setDuration(Integer value) {
            this.validate(this.fields()[7], value);
            this.duration = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasDuration() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearDuration() {
            this.duration = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public GarminHeartRateVariabilitySummary build() {
            try {
                GarminHeartRateVariabilitySummary record = new GarminHeartRateVariabilitySummary();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.startTimeOffset = this.fieldSetFlags()[4] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[4]);
                record.lastNightAvg = this.fieldSetFlags()[5] ? this.lastNightAvg : (Float)this.defaultValue(this.fields()[5]);
                record.lastNight5MinHigh = this.fieldSetFlags()[6] ? this.lastNight5MinHigh : (Float)this.defaultValue(this.fields()[6]);
                record.duration = this.fieldSetFlags()[7] ? this.duration : (Integer)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

