/*
 * Decompiled with CFR 0.152.
 */
package org.radarcns.push.garmin;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class GarminSleepScoreSample
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5072324671774606791L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"GarminSleepScoreSample\",\"namespace\":\"org.radarcns.push.garmin\",\"doc\":\"A map of sleep score string descriptions for each type of sleep as well as restless periods and stress levels during sleep. Each entry in the sleepScores will have a qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR that is used as a qualitative description of the user\u2019s period of sleep.\",\"fields\":[{\"name\":\"time\",\"type\":\"double\",\"doc\":\"Start time of the sleep in seconds since January 1, 1970, 00:00:00 UTC (Unix timestamp).\"},{\"name\":\"timeReceived\",\"type\":\"double\",\"doc\":\"Time that this record was collected by a service in seconds since the Unix Epoch (s).\"},{\"name\":\"summaryId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Unique identifier for the summary.\"},{\"name\":\"date\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The calendar date this summary would be displayed on in Garmin Connect in the local time zone of the device. The date format is \u2018yyyy-mm-dd\u2019.\",\"default\":null},{\"name\":\"startTimeOffset\",\"type\":[\"null\",\"int\"],\"doc\":\"Offset in seconds to add to time to derive the 'local' time of the device that captured the data.\",\"default\":null},{\"name\":\"totalDurationScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s total duration of sleep.\",\"default\":null},{\"name\":\"stressScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s stress during the period of sleep.\",\"default\":null},{\"name\":\"awakeCountScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s awake count during the period of sleep.\",\"default\":null},{\"name\":\"remPercentageScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s REM sleep percentage during the period of sleep.\",\"default\":null},{\"name\":\"restlessnessScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s restlessness during the period of sleep.\",\"default\":null},{\"name\":\"lightPercentageScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s light sleep percentage during the period of sleep.\",\"default\":null},{\"name\":\"deepPercentageScoreQualifier\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A qualifierKey value of EXCELLENT, GOOD, FAIR, or POOR used as a qualitative description of the user\u2019s deep slep percentage during the period of sleep.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<GarminSleepScoreSample> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<GarminSleepScoreSample> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private double time;
    private double timeReceived;
    private String summaryId;
    private String date;
    private Integer startTimeOffset;
    private String totalDurationScoreQualifier;
    private String stressScoreQualifier;
    private String awakeCountScoreQualifier;
    private String remPercentageScoreQualifier;
    private String restlessnessScoreQualifier;
    private String lightPercentageScoreQualifier;
    private String deepPercentageScoreQualifier;
    private static final DatumWriter<GarminSleepScoreSample> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<GarminSleepScoreSample> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<GarminSleepScoreSample> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<GarminSleepScoreSample> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<GarminSleepScoreSample> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static GarminSleepScoreSample fromByteBuffer(ByteBuffer b) throws IOException {
        return (GarminSleepScoreSample)((Object)DECODER.decode(b));
    }

    public GarminSleepScoreSample() {
    }

    public GarminSleepScoreSample(Double time, Double timeReceived, String summaryId, String date, Integer startTimeOffset, String totalDurationScoreQualifier, String stressScoreQualifier, String awakeCountScoreQualifier, String remPercentageScoreQualifier, String restlessnessScoreQualifier, String lightPercentageScoreQualifier, String deepPercentageScoreQualifier) {
        this.time = time;
        this.timeReceived = timeReceived;
        this.summaryId = summaryId;
        this.date = date;
        this.startTimeOffset = startTimeOffset;
        this.totalDurationScoreQualifier = totalDurationScoreQualifier;
        this.stressScoreQualifier = stressScoreQualifier;
        this.awakeCountScoreQualifier = awakeCountScoreQualifier;
        this.remPercentageScoreQualifier = remPercentageScoreQualifier;
        this.restlessnessScoreQualifier = restlessnessScoreQualifier;
        this.lightPercentageScoreQualifier = lightPercentageScoreQualifier;
        this.deepPercentageScoreQualifier = deepPercentageScoreQualifier;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.timeReceived;
            }
            case 2: {
                return this.summaryId;
            }
            case 3: {
                return this.date;
            }
            case 4: {
                return this.startTimeOffset;
            }
            case 5: {
                return this.totalDurationScoreQualifier;
            }
            case 6: {
                return this.stressScoreQualifier;
            }
            case 7: {
                return this.awakeCountScoreQualifier;
            }
            case 8: {
                return this.remPercentageScoreQualifier;
            }
            case 9: {
                return this.restlessnessScoreQualifier;
            }
            case 10: {
                return this.lightPercentageScoreQualifier;
            }
            case 11: {
                return this.deepPercentageScoreQualifier;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.time = (Double)value$;
                break;
            }
            case 1: {
                this.timeReceived = (Double)value$;
                break;
            }
            case 2: {
                this.summaryId = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.date = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.startTimeOffset = (Integer)value$;
                break;
            }
            case 5: {
                this.totalDurationScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.stressScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 7: {
                this.awakeCountScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 8: {
                this.remPercentageScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 9: {
                this.restlessnessScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 10: {
                this.lightPercentageScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            case 11: {
                this.deepPercentageScoreQualifier = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double value) {
        this.time = value;
    }

    public double getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(double value) {
        this.timeReceived = value;
    }

    public String getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(String value) {
        this.summaryId = value;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String value) {
        this.date = value;
    }

    public Integer getStartTimeOffset() {
        return this.startTimeOffset;
    }

    public void setStartTimeOffset(Integer value) {
        this.startTimeOffset = value;
    }

    public String getTotalDurationScoreQualifier() {
        return this.totalDurationScoreQualifier;
    }

    public void setTotalDurationScoreQualifier(String value) {
        this.totalDurationScoreQualifier = value;
    }

    public String getStressScoreQualifier() {
        return this.stressScoreQualifier;
    }

    public void setStressScoreQualifier(String value) {
        this.stressScoreQualifier = value;
    }

    public String getAwakeCountScoreQualifier() {
        return this.awakeCountScoreQualifier;
    }

    public void setAwakeCountScoreQualifier(String value) {
        this.awakeCountScoreQualifier = value;
    }

    public String getRemPercentageScoreQualifier() {
        return this.remPercentageScoreQualifier;
    }

    public void setRemPercentageScoreQualifier(String value) {
        this.remPercentageScoreQualifier = value;
    }

    public String getRestlessnessScoreQualifier() {
        return this.restlessnessScoreQualifier;
    }

    public void setRestlessnessScoreQualifier(String value) {
        this.restlessnessScoreQualifier = value;
    }

    public String getLightPercentageScoreQualifier() {
        return this.lightPercentageScoreQualifier;
    }

    public void setLightPercentageScoreQualifier(String value) {
        this.lightPercentageScoreQualifier = value;
    }

    public String getDeepPercentageScoreQualifier() {
        return this.deepPercentageScoreQualifier;
    }

    public void setDeepPercentageScoreQualifier(String value) {
        this.deepPercentageScoreQualifier = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(GarminSleepScoreSample other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeDouble(this.time);
        out.writeDouble(this.timeReceived);
        out.writeString(this.summaryId);
        if (this.date == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.date);
        }
        if (this.startTimeOffset == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.startTimeOffset.intValue());
        }
        if (this.totalDurationScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.totalDurationScoreQualifier);
        }
        if (this.stressScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.stressScoreQualifier);
        }
        if (this.awakeCountScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.awakeCountScoreQualifier);
        }
        if (this.remPercentageScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.remPercentageScoreQualifier);
        }
        if (this.restlessnessScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.restlessnessScoreQualifier);
        }
        if (this.lightPercentageScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.lightPercentageScoreQualifier);
        }
        if (this.deepPercentageScoreQualifier == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.deepPercentageScoreQualifier);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.time = in.readDouble();
            this.timeReceived = in.readDouble();
            this.summaryId = in.readString();
            if (in.readIndex() != 1) {
                in.readNull();
                this.date = null;
            } else {
                this.date = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.startTimeOffset = null;
            } else {
                this.startTimeOffset = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.totalDurationScoreQualifier = null;
            } else {
                this.totalDurationScoreQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.stressScoreQualifier = null;
            } else {
                this.stressScoreQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.awakeCountScoreQualifier = null;
            } else {
                this.awakeCountScoreQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.remPercentageScoreQualifier = null;
            } else {
                this.remPercentageScoreQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.restlessnessScoreQualifier = null;
            } else {
                this.restlessnessScoreQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.lightPercentageScoreQualifier = null;
            } else {
                this.lightPercentageScoreQualifier = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.deepPercentageScoreQualifier = null;
            } else {
                this.deepPercentageScoreQualifier = in.readString();
            }
        } else {
            block14: for (int i = 0; i < 12; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.time = in.readDouble();
                        continue block14;
                    }
                    case 1: {
                        this.timeReceived = in.readDouble();
                        continue block14;
                    }
                    case 2: {
                        this.summaryId = in.readString();
                        continue block14;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.date = null;
                            continue block14;
                        }
                        this.date = in.readString();
                        continue block14;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.startTimeOffset = null;
                            continue block14;
                        }
                        this.startTimeOffset = in.readInt();
                        continue block14;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.totalDurationScoreQualifier = null;
                            continue block14;
                        }
                        this.totalDurationScoreQualifier = in.readString();
                        continue block14;
                    }
                    case 6: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.stressScoreQualifier = null;
                            continue block14;
                        }
                        this.stressScoreQualifier = in.readString();
                        continue block14;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.awakeCountScoreQualifier = null;
                            continue block14;
                        }
                        this.awakeCountScoreQualifier = in.readString();
                        continue block14;
                    }
                    case 8: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.remPercentageScoreQualifier = null;
                            continue block14;
                        }
                        this.remPercentageScoreQualifier = in.readString();
                        continue block14;
                    }
                    case 9: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.restlessnessScoreQualifier = null;
                            continue block14;
                        }
                        this.restlessnessScoreQualifier = in.readString();
                        continue block14;
                    }
                    case 10: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.lightPercentageScoreQualifier = null;
                            continue block14;
                        }
                        this.lightPercentageScoreQualifier = in.readString();
                        continue block14;
                    }
                    case 11: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.deepPercentageScoreQualifier = null;
                            continue block14;
                        }
                        this.deepPercentageScoreQualifier = in.readString();
                        continue block14;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<GarminSleepScoreSample>
    implements RecordBuilder<GarminSleepScoreSample> {
        private double time;
        private double timeReceived;
        private String summaryId;
        private String date;
        private Integer startTimeOffset;
        private String totalDurationScoreQualifier;
        private String stressScoreQualifier;
        private String awakeCountScoreQualifier;
        private String remPercentageScoreQualifier;
        private String restlessnessScoreQualifier;
        private String lightPercentageScoreQualifier;
        private String deepPercentageScoreQualifier;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.totalDurationScoreQualifier)) {
                this.totalDurationScoreQualifier = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.totalDurationScoreQualifier);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.stressScoreQualifier)) {
                this.stressScoreQualifier = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.stressScoreQualifier);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.awakeCountScoreQualifier)) {
                this.awakeCountScoreQualifier = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.awakeCountScoreQualifier);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.remPercentageScoreQualifier)) {
                this.remPercentageScoreQualifier = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.remPercentageScoreQualifier);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.restlessnessScoreQualifier)) {
                this.restlessnessScoreQualifier = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.restlessnessScoreQualifier);
                this.fieldSetFlags()[9] = other.fieldSetFlags()[9];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.lightPercentageScoreQualifier)) {
                this.lightPercentageScoreQualifier = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.lightPercentageScoreQualifier);
                this.fieldSetFlags()[10] = other.fieldSetFlags()[10];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.deepPercentageScoreQualifier)) {
                this.deepPercentageScoreQualifier = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.deepPercentageScoreQualifier);
                this.fieldSetFlags()[11] = other.fieldSetFlags()[11];
            }
        }

        private Builder(GarminSleepScoreSample other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.time)) {
                this.time = (Double)this.data().deepCopy(this.fields()[0].schema(), (Object)other.time);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.timeReceived)) {
                this.timeReceived = (Double)this.data().deepCopy(this.fields()[1].schema(), (Object)other.timeReceived);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.summaryId)) {
                this.summaryId = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.summaryId);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.date)) {
                this.date = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.date);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.startTimeOffset)) {
                this.startTimeOffset = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.startTimeOffset);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.totalDurationScoreQualifier)) {
                this.totalDurationScoreQualifier = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.totalDurationScoreQualifier);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.stressScoreQualifier)) {
                this.stressScoreQualifier = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.stressScoreQualifier);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.awakeCountScoreQualifier)) {
                this.awakeCountScoreQualifier = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.awakeCountScoreQualifier);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.remPercentageScoreQualifier)) {
                this.remPercentageScoreQualifier = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.remPercentageScoreQualifier);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.restlessnessScoreQualifier)) {
                this.restlessnessScoreQualifier = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.restlessnessScoreQualifier);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.lightPercentageScoreQualifier)) {
                this.lightPercentageScoreQualifier = (String)this.data().deepCopy(this.fields()[10].schema(), (Object)other.lightPercentageScoreQualifier);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.deepPercentageScoreQualifier)) {
                this.deepPercentageScoreQualifier = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.deepPercentageScoreQualifier);
                this.fieldSetFlags()[11] = true;
            }
        }

        public double getTime() {
            return this.time;
        }

        public Builder setTime(double value) {
            this.validate(this.fields()[0], value);
            this.time = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTime() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public double getTimeReceived() {
            return this.timeReceived;
        }

        public Builder setTimeReceived(double value) {
            this.validate(this.fields()[1], value);
            this.timeReceived = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasTimeReceived() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearTimeReceived() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getSummaryId() {
            return this.summaryId;
        }

        public Builder setSummaryId(String value) {
            this.validate(this.fields()[2], value);
            this.summaryId = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSummaryId() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSummaryId() {
            this.summaryId = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDate() {
            return this.date;
        }

        public Builder setDate(String value) {
            this.validate(this.fields()[3], value);
            this.date = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDate() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDate() {
            this.date = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public Builder setStartTimeOffset(Integer value) {
            this.validate(this.fields()[4], value);
            this.startTimeOffset = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStartTimeOffset() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStartTimeOffset() {
            this.startTimeOffset = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getTotalDurationScoreQualifier() {
            return this.totalDurationScoreQualifier;
        }

        public Builder setTotalDurationScoreQualifier(String value) {
            this.validate(this.fields()[5], value);
            this.totalDurationScoreQualifier = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasTotalDurationScoreQualifier() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearTotalDurationScoreQualifier() {
            this.totalDurationScoreQualifier = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getStressScoreQualifier() {
            return this.stressScoreQualifier;
        }

        public Builder setStressScoreQualifier(String value) {
            this.validate(this.fields()[6], value);
            this.stressScoreQualifier = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasStressScoreQualifier() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearStressScoreQualifier() {
            this.stressScoreQualifier = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getAwakeCountScoreQualifier() {
            return this.awakeCountScoreQualifier;
        }

        public Builder setAwakeCountScoreQualifier(String value) {
            this.validate(this.fields()[7], value);
            this.awakeCountScoreQualifier = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasAwakeCountScoreQualifier() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearAwakeCountScoreQualifier() {
            this.awakeCountScoreQualifier = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getRemPercentageScoreQualifier() {
            return this.remPercentageScoreQualifier;
        }

        public Builder setRemPercentageScoreQualifier(String value) {
            this.validate(this.fields()[8], value);
            this.remPercentageScoreQualifier = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasRemPercentageScoreQualifier() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearRemPercentageScoreQualifier() {
            this.remPercentageScoreQualifier = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getRestlessnessScoreQualifier() {
            return this.restlessnessScoreQualifier;
        }

        public Builder setRestlessnessScoreQualifier(String value) {
            this.validate(this.fields()[9], value);
            this.restlessnessScoreQualifier = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasRestlessnessScoreQualifier() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearRestlessnessScoreQualifier() {
            this.restlessnessScoreQualifier = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public String getLightPercentageScoreQualifier() {
            return this.lightPercentageScoreQualifier;
        }

        public Builder setLightPercentageScoreQualifier(String value) {
            this.validate(this.fields()[10], value);
            this.lightPercentageScoreQualifier = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasLightPercentageScoreQualifier() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearLightPercentageScoreQualifier() {
            this.lightPercentageScoreQualifier = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getDeepPercentageScoreQualifier() {
            return this.deepPercentageScoreQualifier;
        }

        public Builder setDeepPercentageScoreQualifier(String value) {
            this.validate(this.fields()[11], value);
            this.deepPercentageScoreQualifier = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasDeepPercentageScoreQualifier() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearDeepPercentageScoreQualifier() {
            this.deepPercentageScoreQualifier = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public GarminSleepScoreSample build() {
            try {
                GarminSleepScoreSample record = new GarminSleepScoreSample();
                record.time = this.fieldSetFlags()[0] ? this.time : (Double)this.defaultValue(this.fields()[0]);
                record.timeReceived = this.fieldSetFlags()[1] ? this.timeReceived : (Double)this.defaultValue(this.fields()[1]);
                record.summaryId = this.fieldSetFlags()[2] ? this.summaryId : (String)this.defaultValue(this.fields()[2]);
                record.date = this.fieldSetFlags()[3] ? this.date : (String)this.defaultValue(this.fields()[3]);
                record.startTimeOffset = this.fieldSetFlags()[4] ? this.startTimeOffset : (Integer)this.defaultValue(this.fields()[4]);
                record.totalDurationScoreQualifier = this.fieldSetFlags()[5] ? this.totalDurationScoreQualifier : (String)this.defaultValue(this.fields()[5]);
                record.stressScoreQualifier = this.fieldSetFlags()[6] ? this.stressScoreQualifier : (String)this.defaultValue(this.fields()[6]);
                record.awakeCountScoreQualifier = this.fieldSetFlags()[7] ? this.awakeCountScoreQualifier : (String)this.defaultValue(this.fields()[7]);
                record.remPercentageScoreQualifier = this.fieldSetFlags()[8] ? this.remPercentageScoreQualifier : (String)this.defaultValue(this.fields()[8]);
                record.restlessnessScoreQualifier = this.fieldSetFlags()[9] ? this.restlessnessScoreQualifier : (String)this.defaultValue(this.fields()[9]);
                record.lightPercentageScoreQualifier = this.fieldSetFlags()[10] ? this.lightPercentageScoreQualifier : (String)this.defaultValue(this.fields()[10]);
                record.deepPercentageScoreQualifier = this.fieldSetFlags()[11] ? this.deepPercentageScoreQualifier : (String)this.defaultValue(this.fields()[11]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

