/*
 * Decompiled with CFR 0.152.
 */
package radar.spring.auth.common;

import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.CodeSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import radar.spring.auth.common.AuthValidator;
import radar.spring.auth.common.Authorization;
import radar.spring.auth.common.Authorized;
import radar.spring.auth.exception.AuthorizationFailedException;
import radar.spring.auth.exception.ResourceForbiddenException;

@Aspect
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000  *\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 BS\b\u0007\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\fJ4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006!"}, d2={"Lradar/spring/auth/common/AuthAspect;", "T", "", "authValidator", "Lradar/spring/auth/common/AuthValidator;", "authorization", "Lradar/spring/auth/common/Authorization;", "projectIdParamNames", "", "", "subjectIdParamNames", "sourceIdParamNames", "(Lradar/spring/auth/common/AuthValidator;Lradar/spring/auth/common/Authorization;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)V", "getProjectIdParamNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getSourceIdParamNames", "getSubjectIdParamNames", "authorize", "", "authorized", "Lradar/spring/auth/common/Authorized;", "request", "Ljavax/servlet/http/HttpServletRequest;", "projectId", "subjectId", "sourceId", "before", "joinPoint", "Lorg/aspectj/lang/JoinPoint;", "ensureToken", "(Ljavax/servlet/http/HttpServletRequest;)Ljava/lang/Object;", "Companion", "radar-spring-auth"})
public class AuthAspect<T> {
    private final AuthValidator<T> authValidator;
    private final Authorization<T> authorization;
    @NotNull
    private final String[] projectIdParamNames;
    @NotNull
    private final String[] subjectIdParamNames;
    @NotNull
    private final String[] sourceIdParamNames;
    @NotNull
    public static final String TOKEN_KEY = "radar_token";
    @NotNull
    public static final String PROJECT_ID_PARAMETER_NAME = "projectId";
    @NotNull
    public static final String SUBJECT_ID_PARAMETER_NAME = "subjectId";
    @NotNull
    public static final String SOURCE_ID_PARAMETER_NAME = "sourceId";
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Before(value="@annotation(authorized) && execution(* *(..))")
    public final void before(@NotNull JoinPoint joinPoint, @NotNull Authorized authorized) {
        RequestAttributes reqAttr;
        Intrinsics.checkParameterIsNotNull((Object)joinPoint, (String)"joinPoint");
        Intrinsics.checkParameterIsNotNull((Object)authorized, (String)"authorized");
        RequestAttributes requestAttributes = reqAttr = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.springframework.web.context.request.ServletRequestAttributes");
        }
        HttpServletRequest req = ((ServletRequestAttributes)requestAttributes).getRequest();
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        if (signature == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.aspectj.lang.reflect.CodeSignature");
        }
        CodeSignature codeSignature = (CodeSignature)signature;
        String projectId = null;
        String subjectId = null;
        String sourceId = null;
        Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
        Object[] objectArray = args;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            void index;
            Object arg = objectArray[n2];
            if (Intrinsics.areEqual((Object)codeSignature.getParameterTypes()[index], String.class)) {
                String string = codeSignature.getParameterNames()[index];
                if (ArraysKt.contains((Object[])this.projectIdParamNames, (Object)string)) {
                    Object object = arg;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    projectId = (String)object;
                } else if (ArraysKt.contains((Object[])this.subjectIdParamNames, (Object)string)) {
                    Object object = arg;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    subjectId = (String)object;
                } else if (ArraysKt.contains((Object[])this.sourceIdParamNames, (Object)string)) {
                    Object object = arg;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    sourceId = (String)object;
                }
            }
            ++index;
        }
        HttpServletRequest httpServletRequest = req;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"req");
        this.authorize(authorized, httpServletRequest, projectId, subjectId, sourceId);
    }

    public final void authorize(@NotNull Authorized authorized, @NotNull HttpServletRequest request, @Nullable String projectId, @Nullable String subjectId, @Nullable String sourceId) {
        Intrinsics.checkParameterIsNotNull((Object)authorized, (String)"authorized");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        logger.debug("Authorizing request...");
        T token = this.ensureToken(request);
        String[] stringArray = authorized.audiences();
        String[] stringArray2 = authorized.grantTypes();
        String string = sourceId;
        String string2 = projectId;
        String string3 = subjectId;
        if (!this.authorization.authorize(token, authorized.permission(), authorized.entity(), authorized.permissionOn(), authorized.role(), authorized.scopes(), authorized.authorities(), stringArray, stringArray2, string2, string3, string)) {
            throw (Throwable)new ResourceForbiddenException("The requested resource is forbidden.", null, 2, null);
        }
        logger.debug("Setting the token in the request: {}", token);
        request.setAttribute(TOKEN_KEY, token);
    }

    private final T ensureToken(HttpServletRequest request) {
        T t;
        String tokenString = this.authValidator.getToken(request);
        if (tokenString == null) {
            logger.warn("[401] {}: No token bearer header provided in the request", (Object)request.getRequestURI());
            throw (Throwable)new AuthorizationFailedException("The token is missing from the request. No bearer token provided in the request", null, 2, null);
        }
        try {
            t = this.authValidator.verify(tokenString, request);
        }
        catch (Exception exc) {
            logger.warn("[401] {}: {}", (Object)request.getRequestURI(), (Object)exc.toString());
            throw (Throwable)new AuthorizationFailedException("Cannot verify token. It may have been rendered invalid.", exc);
        }
        T token = t;
        if (token == null) {
            logger.warn("[401] {}: Bearer token invalid", (Object)request.getRequestURI());
            throw (Throwable)new AuthorizationFailedException("Bearer token is not a valid JWT.", null, 2, null);
        }
        return token;
    }

    @NotNull
    public final String[] getProjectIdParamNames() {
        return this.projectIdParamNames;
    }

    @NotNull
    public final String[] getSubjectIdParamNames() {
        return this.subjectIdParamNames;
    }

    @NotNull
    public final String[] getSourceIdParamNames() {
        return this.sourceIdParamNames;
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization, @NotNull String[] projectIdParamNames, @NotNull String[] subjectIdParamNames, @NotNull String[] sourceIdParamNames) {
        Intrinsics.checkParameterIsNotNull(authValidator, (String)"authValidator");
        Intrinsics.checkParameterIsNotNull(authorization, (String)"authorization");
        Intrinsics.checkParameterIsNotNull((Object)projectIdParamNames, (String)"projectIdParamNames");
        Intrinsics.checkParameterIsNotNull((Object)subjectIdParamNames, (String)"subjectIdParamNames");
        Intrinsics.checkParameterIsNotNull((Object)sourceIdParamNames, (String)"sourceIdParamNames");
        this.authValidator = authValidator;
        this.authorization = authorization;
        this.projectIdParamNames = projectIdParamNames;
        this.subjectIdParamNames = subjectIdParamNames;
        this.sourceIdParamNames = sourceIdParamNames;
    }

    public /* synthetic */ AuthAspect(AuthValidator authValidator, Authorization authorization, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stringArray = new String[]{PROJECT_ID_PARAMETER_NAME};
        }
        if ((n & 8) != 0) {
            stringArray2 = new String[]{SUBJECT_ID_PARAMETER_NAME};
        }
        if ((n & 0x10) != 0) {
            stringArray3 = new String[]{SOURCE_ID_PARAMETER_NAME};
        }
        this(authValidator, authorization, stringArray, stringArray2, stringArray3);
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization, @NotNull String[] projectIdParamNames, @NotNull String[] subjectIdParamNames) {
        this(authValidator, authorization, projectIdParamNames, subjectIdParamNames, null, 16, null);
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization, @NotNull String[] projectIdParamNames) {
        this(authValidator, authorization, projectIdParamNames, null, null, 24, null);
    }

    @JvmOverloads
    public AuthAspect(@NotNull AuthValidator<T> authValidator, @NotNull Authorization<T> authorization) {
        this(authValidator, authorization, null, null, null, 28, null);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(AuthAspect.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lradar/spring/auth/common/AuthAspect$Companion;", "", "()V", "PROJECT_ID_PARAMETER_NAME", "", "SOURCE_ID_PARAMETER_NAME", "SUBJECT_ID_PARAMETER_NAME", "TOKEN_KEY", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-spring-auth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

