/*
 * Decompiled with CFR 0.152.
 */
package radar.spring.auth.managementportal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.radarbase.auth.authorization.Permission;
import org.radarbase.auth.token.RadarToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import radar.spring.auth.common.Authorization;
import radar.spring.auth.common.PermissionOn;
import radar.spring.auth.managementportal.ManagementPortalAuthorization$WhenMappings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J6\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J,\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nH\u0002J#\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012JH\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0016J$\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0016J#\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006!"}, d2={"Lradar/spring/auth/managementportal/ManagementPortalAuthorization;", "Lradar/spring/auth/common/Authorization;", "Lorg/radarbase/auth/token/RadarToken;", "()V", "checkPermissionOnProject", "", "token", "mpPermission", "Lorg/radarbase/auth/authorization/Permission;", "project", "", "checkPermissionOnSource", "user", "source", "checkPermissionOnSubject", "hasAudiences", "audiences", "", "(Lorg/radarbase/auth/token/RadarToken;[Ljava/lang/String;)Z", "hasAuthorities", "authorities", "hasGrantTypes", "grantTypes", "hasPermission", "permission", "entity", "permissionOn", "Lradar/spring/auth/common/PermissionOn;", "hasRole", "role", "hasScopes", "scopes", "Companion", "radar-spring-auth"})
public final class ManagementPortalAuthorization
implements Authorization<RadarToken> {
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasPermission(@NotNull RadarToken token, @NotNull String permission, @NotNull String entity, @Nullable PermissionOn permissionOn, @Nullable String project, @Nullable String user, @Nullable String source) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Permission mpPermission = new Permission(Permission.Entity.valueOf((String)entity), Permission.Operation.valueOf((String)permission));
        PermissionOn permissionOn2 = permissionOn;
        if (permissionOn2 != null) {
            switch (ManagementPortalAuthorization$WhenMappings.$EnumSwitchMapping$0[permissionOn2.ordinal()]) {
                case 1: {
                    bl = this.checkPermissionOnProject(token, mpPermission, project);
                    return bl;
                }
                case 2: {
                    bl = this.checkPermissionOnSubject(token, mpPermission, project, user);
                    return bl;
                }
                case 3: {
                    bl = this.checkPermissionOnSource(token, mpPermission, project, user, source);
                    return bl;
                }
            }
        }
        bl = token.hasPermission(mpPermission);
        return bl;
    }

    @Override
    public boolean hasRole(@NotNull RadarToken token, @Nullable String project, @Nullable String role) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        CharSequence charSequence = role;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return true;
        }
        charSequence = project;
        bl = false;
        bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            logger.warn("Project must be specified when checking a role.");
            return false;
        }
        return token.getRoles().getOrDefault(project, CollectionsKt.emptyList()).contains(role);
    }

    @Override
    public boolean hasScopes(@NotNull RadarToken token, @NotNull String[] scopes) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)scopes, (String)"scopes");
        return token.getScopes().containsAll(ArraysKt.toList((Object[])scopes));
    }

    @Override
    public boolean hasAuthorities(@NotNull RadarToken token, @NotNull String[] authorities) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)authorities, (String)"authorities");
        return token.getAuthorities().containsAll(ArraysKt.toList((Object[])authorities));
    }

    @Override
    public boolean hasAudiences(@NotNull RadarToken token, @NotNull String[] audiences) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)audiences, (String)"audiences");
        return token.getAudience().containsAll(ArraysKt.toList((Object[])audiences));
    }

    @Override
    public boolean hasGrantTypes(@NotNull RadarToken token, @NotNull String[] grantTypes) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)grantTypes, (String)"grantTypes");
        String[] stringArray = grantTypes;
        boolean bl = false;
        if (stringArray.length == 0) {
            return true;
        }
        return ArraysKt.contains((Object[])grantTypes, (Object)token.getGrantType());
    }

    private final boolean checkPermissionOnProject(RadarToken token, Permission mpPermission, String project) {
        CharSequence charSequence = project;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            logger.warn("The project must be specified when checking permissions on PROJECT.");
            return false;
        }
        return token.hasPermissionOnProject(mpPermission, project);
    }

    private final boolean checkPermissionOnSubject(RadarToken token, Permission mpPermission, String project, String user) {
        block3: {
            block2: {
                CharSequence charSequence = project;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block2;
                charSequence = user;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block3;
            }
            logger.warn("The project and subject must be specified when checking permissions on SUBJECT.");
            return false;
        }
        return token.hasPermissionOnSubject(mpPermission, project, user);
    }

    private final boolean checkPermissionOnSource(RadarToken token, Permission mpPermission, String project, String user, String source) {
        block3: {
            block2: {
                CharSequence charSequence = project;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block2;
                charSequence = user;
                bl = false;
                bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block2;
                charSequence = source;
                bl = false;
                bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) break block3;
            }
            logger.warn("The project, subject and source must be specified when checking permissions on SOURCE.");
            return false;
        }
        return token.hasPermissionOnSource(mpPermission, project, user, source);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(ManagementPortalAuthorization.class);
    }

    @Override
    public boolean authorize(@NotNull RadarToken token, @NotNull String permission, @NotNull String entity, @Nullable PermissionOn permissionOn, @Nullable String role, @NotNull String[] scopes, @NotNull String[] authorities, @NotNull String[] audiences, @NotNull String[] grantTypes, @Nullable String project, @Nullable String user, @Nullable String source) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)authorities, (String)"authorities");
        Intrinsics.checkParameterIsNotNull((Object)audiences, (String)"audiences");
        Intrinsics.checkParameterIsNotNull((Object)grantTypes, (String)"grantTypes");
        return Authorization.DefaultImpls.authorize(this, token, permission, entity, permissionOn, role, scopes, authorities, audiences, grantTypes, project, user, source);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lradar/spring/auth/managementportal/ManagementPortalAuthorization$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "radar-spring-auth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

