/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model;

import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class ClassHierarchyVisitor {
    public void visit(ITypeModel type, IMethodModel method) {
        HashSet<String> iSet = new HashSet<String>();
        ArrayList<ITypeModel> iList = new ArrayList<ITypeModel>();
        for (ITypeModel t = type; t != null; t = t.getSuperClass()) {
            ITypeModel[] typeInterfaces;
            if (method != null ? this.processType(t, method) : this.processType(t)) {
                return;
            }
            if (!this.visitInterfaces() || (typeInterfaces = t.getImplementedInterfaces()) == null) continue;
            for (ITypeModel iType : typeInterfaces) {
                String name = iType.getFullyQualifiedName();
                if (iSet.contains(name)) continue;
                iSet.add(name);
                iList.add(iType);
            }
        }
        for (int i = 0; i < iList.size(); ++i) {
            ITypeModel[] typeInterfaces;
            ITypeModel t = (ITypeModel)iList.get(i);
            if (method != null ? this.processType(t, method) : this.processType(t)) {
                return;
            }
            for (ITypeModel iType : typeInterfaces = t.getImplementedInterfaces()) {
                String name = iType.getFullyQualifiedName();
                if (iSet.contains(name)) continue;
                iSet.add(name);
                iList.add(iType);
            }
        }
    }

    protected boolean processType(ITypeModel type, IMethodModel method) {
        IMethodModel[] methods = type.getMethods();
        String methodName = method.getName();
        IParameterModel[] methodParams = method.getParameters();
        int paramsCount = methodParams.length;
        for (IMethodModel m : methods) {
            IParameterModel[] params;
            if (m.getName() != methodName || (params = m.getParameters()).length != paramsCount) continue;
            boolean match = true;
            for (int i = 0; i < paramsCount; ++i) {
                if (params[i].getParameterType().equals(methodParams[i].getParameterType())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return this.checkMethod(m);
        }
        return false;
    }

    protected boolean processType(ITypeModel type) {
        IMethodModel[] methods;
        for (IMethodModel m : methods = type.getMethods()) {
            if (!this.checkMethod(m)) continue;
            return true;
        }
        return false;
    }

    protected boolean visitInterfaces() {
        return true;
    }

    abstract boolean checkMethod(IMethodModel var1);
}

