/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model;

import com.mulesoft.jaxrs.raml.annotation.model.ClassHierarchyVisitor;
import com.mulesoft.jaxrs.raml.annotation.model.FileUtil;
import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IDocInfo;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.IRamlConfig;
import com.mulesoft.jaxrs.raml.annotation.model.IResourceVisitorExtension;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.RAMLModelHelper;
import com.mulesoft.jaxrs.raml.annotation.model.StructureType;
import com.mulesoft.jaxrs.raml.annotation.model.WrapperMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import com.mulesoft.jaxrs.raml.jaxb.ExampleGenerator;
import com.mulesoft.jaxrs.raml.jaxb.JAXBRegistry;
import com.mulesoft.jaxrs.raml.jaxb.JAXBType;
import com.mulesoft.jaxrs.raml.jaxb.SchemaModelBuilder;
import com.mulesoft.jaxrs.raml.jaxb.XMLModelSerializer;
import com.mulesoft.jaxrs.raml.jaxb.XMLWriter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonModelSerializer;
import com.mulesoft.jaxrs.raml.jsonschema.JsonSchemaModelSerializer;
import com.mulesoft.jaxrs.raml.jsonschema.JsonUtil;
import com.mulesoft.jaxrs.raml.jsonschema.SchemaGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.raml.emitter.IRamlHierarchyTarget;
import org.raml.emitter.RamlEmitterV2;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.DocumentationItem;
import org.raml.model.MimeType;
import org.raml.model.ParamType;
import org.raml.model.Protocol;
import org.raml.model.Raml2;
import org.raml.model.Resource;
import org.raml.model.Response;
import org.raml.model.parameter.AbstractParam;
import org.raml.model.parameter.FormParameter;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.raml.model.parameter.UriParameter;
import org.raml.schema.model.ISchemaType;

public abstract class ResourceVisitor {
    private static final String DEFAULT_RESPONSE = "200";
    private static final String API_OPERATION = "ApiOperation";
    private static final String API_RESPONSE = "ApiResponse";
    private static final String API_RESPONSES = "ApiResponses";
    private static final String CODE = "code";
    private static final String JSONSCHEMA = "-jsonschema";
    protected static final String XML_FILE_EXT = ".xml";
    private static final String JSON_FILE_EXT = ".json";
    private static final String XSD_FILE_EXT = ".xsd";
    protected static final String SCHEMAS_FOLDER = "schemas";
    protected static final String EXAMPLES_FOLDER = "examples";
    private static final String JSON = "json";
    private static final String XML = "xml";
    protected JAXBRegistry regsistry = new JAXBRegistry();
    private static final String FORM = "form";
    private static final String DEFAULT_VALUE = "DefaultValue";
    private static final String PATH_PARAM = "PathParam";
    private static final String HEADER_PARAM = "HeaderParam";
    private static final String CONSUMES = "Consumes";
    private static final String PRODUCES = "Produces";
    private static final String QUERY_PARAM = "QueryParam";
    private static final String PATH = "Path";
    private static final String FORM_PARAM = "FormParam";
    private static final String XML_ROOT_ELEMENT = "XmlRootElement";
    private static final String XML_TYPE = "XmlType";
    private static final String XML_ACCESSOR_TYPE = "XmlAccessorType";
    private static final String XML_ACCESSOR_ORDER = "XmlAccessorOrder";
    private static final String RESPONSE = "response";
    private static final String MESSAGE = "message";
    private static final String EXAMPLE = "example";
    private static final String SCHEMA = "schema";
    protected RAMLModelHelper spec = new RAMLModelHelper();
    protected String[] classConsumes;
    protected String[] classProduces;
    protected HashSet<ITypeModel> consumedTypes = new HashSet();
    private String basePath;
    protected final File outputFile;
    protected final ClassLoader classLoader;
    private IRamlConfig config;

    public ResourceVisitor(File outputFile, ClassLoader classLoader) {
        this.outputFile = outputFile;
        this.classLoader = classLoader;
    }

    public void visit(ITypeModel t) {
        this.consumedTypes.add(t);
        IAnnotationModel apiAnn = t.getAnnotation("Api");
        if (apiAnn != null) {
            String consumesString;
            String producesString;
            String description;
            String baseUri = apiAnn.getValue("basePath");
            if (baseUri != null && !baseUri.trim().isEmpty()) {
                this.spec.getCoreRaml().setBaseUri(baseUri);
            }
            if ((description = apiAnn.getValue("description")) != null && !description.trim().isEmpty()) {
                DocumentationItem di = new DocumentationItem();
                di.setContent(description);
                di.setTitle("description");
                this.spec.getCoreRaml().setDocumentation(new ArrayList<DocumentationItem>(Arrays.asList(di)));
            }
            if ((producesString = apiAnn.getValue(PRODUCES.toLowerCase())) != null && !producesString.isEmpty()) {
                this.classProduces = producesString.split(",");
                for (int i = 0; i < this.classProduces.length; ++i) {
                    this.classProduces[i] = this.classProduces[i].trim();
                }
            }
            if ((consumesString = apiAnn.getValue(CONSUMES.toLowerCase())) != null && !consumesString.isEmpty()) {
                this.classConsumes = consumesString.split(",");
                for (int i = 0; i < this.classConsumes.length; ++i) {
                    this.classConsumes[i] = this.classConsumes[i].trim();
                }
            }
        }
        if (this.classConsumes == null || this.classConsumes.length == 0) {
            this.classConsumes = t.getAnnotationValues(CONSUMES);
        }
        if (this.classProduces == null || this.classProduces.length == 0) {
            this.classProduces = t.getAnnotationValues(PRODUCES);
        }
        String annotationValue = t.getAnnotationValue(PATH);
        if (this.basePath != null) {
            if (annotationValue == null) {
                annotationValue = "";
            }
            annotationValue = this.basePath + annotationValue;
        }
        if (annotationValue != null) {
            IMethodModel[] methods;
            if (!annotationValue.endsWith("/")) {
                annotationValue = annotationValue + "/";
            }
            for (IMethodModel m : methods = this.extractmethods(t)) {
                this.visit(new WrapperMethodModel(t, m), annotationValue, t);
            }
        }
    }

    private IMethodModel[] extractmethods(ITypeModel t) {
        final LinkedHashMap map = new LinkedHashMap();
        new ClassHierarchyVisitor(){

            @Override
            boolean checkMethod(IMethodModel method) {
                String key = this.getKey(method);
                if (!map.containsKey(key)) {
                    map.put(key, method);
                }
                return false;
            }

            private String getKey(IMethodModel method) {
                StringBuilder bld = new StringBuilder(method.getName());
                for (IParameterModel param : method.getParameters()) {
                    bld.append(";").append(param.getParameterType());
                }
                String key = bld.toString();
                return key;
            }

            @Override
            protected boolean visitInterfaces() {
                return false;
            }
        }.visit(t, null);
        IMethodModel[] result = map.values().toArray(new IMethodModel[map.size()]);
        return result;
    }

    protected boolean generateXMLSchema(ITypeModel t, StructureType st) {
        return false;
    }

    protected String generateXMLExampleJAXB(ITypeModel t) {
        JAXBRegistry rs = new JAXBRegistry();
        JAXBType jaxbModel = rs.getJAXBModel(t);
        if (jaxbModel != null) {
            XMLWriter writer = new XMLWriter();
            ExampleGenerator gen = new ExampleGenerator(writer);
            gen.generateXML(jaxbModel);
            return writer.toString();
        }
        return null;
    }

    public String getRaml() {
        this.spec.optimize();
        RamlEmitterV2 emmitter = new RamlEmitterV2();
        emmitter.setSingle(false);
        final StringHolder holder = new StringHolder();
        emmitter.dump(new IRamlHierarchyTarget(){

            @Override
            public void write(String path, String content) {
            }

            @Override
            public void writeRoot(String content) {
                holder.content = content;
            }
        }, this.spec.getCoreRaml());
        return holder.content;
    }

    private void visit(IMethodModel m, String path, ITypeModel ownerType) {
        boolean hasPath = m.hasAnnotation(PATH);
        if (hasPath) {
            String localPath = m.getAnnotationValue(PATH);
            if (path.endsWith("/") && localPath.startsWith("/")) {
                localPath = localPath.substring(1);
            }
            path = path + localPath;
        }
        boolean isWs = hasPath;
        for (ActionType q : ActionType.values()) {
            boolean hasAnnotation = m.hasAnnotation(q.name());
            isWs |= hasAnnotation;
        }
        if (isWs) {
            ITypeModel bodyType;
            Resource res = new Resource();
            res.setDescription(ownerType.getDocumentation());
            IDocInfo documentation = this.getDocumentation(m);
            String returnName = null;
            String parameterName = null;
            ITypeModel returnedType = m.getReturnedType();
            if (returnedType != null) {
                boolean generateSchema = returnedType.hasAnnotation(XML_ROOT_ELEMENT);
                if (!generateSchema && this.config != null && this.config.getExtensions() != null) {
                    for (IResourceVisitorExtension ext : this.config.getExtensions()) {
                        generateSchema |= ext.generateSchema(returnedType);
                    }
                }
                if (generateSchema) {
                    this.generateXMLSchema(returnedType, null);
                    returnName = this.firstLetterToLowerCase(returnedType.getName());
                }
                if (hasPath && this.consumedTypes.add(returnedType)) {
                    ResourceVisitor resourceVisitor = this.createResourceVisitor();
                    resourceVisitor.consumedTypes.addAll(this.consumedTypes);
                    resourceVisitor.basePath = path;
                    resourceVisitor.spec = this.spec;
                    resourceVisitor.visit(returnedType);
                }
            }
            if ((bodyType = m.getBodyType()) != null && bodyType.hasAnnotation(XML_ROOT_ELEMENT)) {
                this.generateXMLSchema(bodyType, null);
                parameterName = bodyType.getName();
            }
            if (path.endsWith("/")) {
                res.setRelativeUri(path.substring(0, path.length() - 1));
            } else {
                res.setRelativeUri(path);
            }
            for (ActionType q : ActionType.values()) {
                boolean hasAnnotation = m.hasAnnotation(q.name());
                if (!hasAnnotation) continue;
                this.addMethod(q, res, m, documentation, returnName, parameterName);
            }
            this.spec.addResource(res);
        }
    }

    private IDocInfo getDocumentation(IMethodModel m) {
        final IDocInfo basicDocInfo = m.getBasicDocInfo();
        String docString = basicDocInfo.getDocumentation();
        if (docString != null && !docString.trim().isEmpty()) {
            return basicDocInfo;
        }
        IAnnotationModel apiOperation = m.getAnnotation(API_OPERATION);
        if (apiOperation != null) {
            String notes;
            StringBuilder bld = new StringBuilder();
            String summary = apiOperation.getValue("value");
            if (summary != null) {
                bld.append(summary.trim());
            }
            if ((notes = apiOperation.getValue("notes")) != null) {
                if (bld.length() != 0) {
                    bld.append("\r\n");
                }
                bld.append(notes);
            }
            docString = bld.toString();
        }
        if (docString != null && !docString.isEmpty()) {
            final String finalDocumentation = docString;
            return new IDocInfo(){

                @Override
                public String getReturnInfo() {
                    return basicDocInfo.getReturnInfo();
                }

                @Override
                public String getDocumentation(String pName) {
                    return basicDocInfo.getDocumentation(pName);
                }

                @Override
                public String getDocumentation() {
                    return finalDocumentation;
                }
            };
        }
        return basicDocInfo;
    }

    protected abstract ResourceVisitor createResourceVisitor();

    private void addMethod(ActionType actionType, Resource res, IMethodModel m, IDocInfo documentation, String returnName, String parameterName) {
        String paramName;
        AbstractParam value2;
        IAnnotationModel paramAnnotation;
        IParameterModel[] parameters;
        Action action = new Action();
        String description = documentation.getDocumentation();
        if (!"".equals(description)) {
            action.setDescription(description);
        }
        ActionType adjustedActionType = this.adjustActionType(m, actionType);
        action.setType(adjustedActionType);
        res.getActions().put(adjustedActionType, action);
        this.processResponses(m, action, documentation, returnName);
        for (IParameterModel pm : parameters = m.getParameters()) {
            if (!pm.hasAnnotation(QUERY_PARAM)) continue;
            paramAnnotation = pm.getAnnotation(QUERY_PARAM);
            value2 = new QueryParameter();
            paramName = this.configureParam(pm, value2, documentation, paramAnnotation);
            action.getQueryParameters().put(paramName, (QueryParameter)value2);
        }
        for (IParameterModel pm : parameters) {
            if (!pm.hasAnnotation(HEADER_PARAM)) continue;
            paramAnnotation = pm.getAnnotation(HEADER_PARAM);
            value2 = new Header();
            paramName = this.configureParam(pm, value2, documentation, paramAnnotation);
            action.getHeaders().put(paramName, (Header)value2);
        }
        for (IParameterModel pm : parameters) {
            if (!pm.hasAnnotation(PATH_PARAM)) continue;
            paramAnnotation = pm.getAnnotation(PATH_PARAM);
            value2 = new UriParameter();
            paramName = this.configureParam(pm, value2, documentation, paramAnnotation);
            res.getUriParameters().put(paramName, (UriParameter)value2);
        }
        boolean hasBody = m.getBodyType() != null;
        String[] consumesValue = this.extractMediaTypes(m, CONSUMES, this.classConsumes, hasBody, adjustedActionType);
        if (consumesValue != null) {
            for (String s : consumesValue) {
                s = this.sanitizeMediaType(s);
                MimeType bodyType = new MimeType();
                this.tryAppendSchemesAndExamples(bodyType, s, parameterName, StructureType.COMMON);
                bodyType.setType(s);
                if (s.contains(FORM)) {
                    for (IParameterModel pm : parameters) {
                        if (!pm.hasAnnotation(FORM_PARAM)) continue;
                        IAnnotationModel paramAnnotation2 = pm.getAnnotation(FORM_PARAM);
                        FormParameter vl = new FormParameter();
                        String paramName2 = this.configureParam(pm, vl, documentation, paramAnnotation2);
                        ArrayList<FormParameter> arrayList = new ArrayList<FormParameter>();
                        arrayList.add(vl);
                        if (bodyType.getFormParameters() == null) {
                            bodyType.setFormParameters(new HashMap<String, List<FormParameter>>());
                        }
                        bodyType.getFormParameters().put(paramName2, arrayList);
                    }
                }
                action.getBody().put(s, bodyType);
            }
        }
    }

    private void tryAppendSchemesAndExamples(MimeType bodyType, String mediaType, String typeName, StructureType st) {
        ArrayList<String> mediaTypes = new ArrayList<String>();
        if (mediaType.contains(XML)) {
            mediaTypes.add(XML);
        }
        if (mediaType.contains(JSON)) {
            mediaTypes.add(JSON);
        }
        for (String mt : mediaTypes) {
            File examplefile;
            File schemafile = this.constructFileLocation(typeName, SCHEMA, mt, st);
            if (schemafile.exists()) {
                bodyType.setSchema(this.getSchemaName(typeName, mediaType, st));
            }
            if (!(examplefile = this.constructFileLocation(typeName, EXAMPLE, mt, st)).exists()) continue;
            String relativePath = this.constructRelativeFilePath(typeName, EXAMPLE, mt, st);
            bodyType.setExample(relativePath);
            bodyType.setExampleOrigin(relativePath);
        }
    }

    private void processResponses(IMethodModel m, Action action, IDocInfo documentation, String returnName) {
        IAnnotationModel apiOperation;
        boolean returnsValue;
        IAnnotationModel[] subAnnotations;
        IAnnotationModel apiResponses;
        HashMap<String, ResponseModel> responses = new HashMap<String, ResponseModel>();
        String mainResponseCode = DEFAULT_RESPONSE;
        if (this.config != null) {
            ActionType actionType = action.getType();
            mainResponseCode = this.config.getResponseCode(actionType);
        }
        ResponseModel mainResponse = new ResponseModel(mainResponseCode, null, returnName, StructureType.COMMON);
        responses.put(mainResponseCode, mainResponse);
        IAnnotationModel apiResponse = m.getAnnotation(API_RESPONSE);
        if (apiResponse != null) {
            String code = apiResponse.getValue(CODE);
            String message = apiResponse.getValue(MESSAGE);
            ResponseModel responseModel = new ResponseModel(code, message, returnName, StructureType.COMMON);
            responses.put(code, responseModel);
        }
        if ((apiResponses = m.getAnnotation(API_RESPONSES)) != null && (subAnnotations = apiResponses.getSubAnnotations("value")) != null) {
            for (IAnnotationModel subAnn : subAnnotations) {
                ResponseModel response;
                boolean isValid;
                String code = subAnn.getValue(CODE);
                String message = subAnn.getValue(MESSAGE);
                String adjustedReturnName = returnName;
                String responseQualifiedName = subAnn.getValue(RESPONSE);
                boolean bl = isValid = Integer.parseInt(code) < 400;
                if (responseQualifiedName != null && isValid) {
                    try {
                        Class<?> responseClass = this.classLoader.loadClass(responseQualifiedName);
                        ReflectionType rt = new ReflectionType(responseClass);
                        this.generateXMLSchema(rt, StructureType.COMMON);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    adjustedReturnName = this.firstLetterToLowerCase(this.getSimpleName(responseQualifiedName));
                }
                if ((response = (ResponseModel)responses.get(code)) == null) {
                    response = new ResponseModel(code, message, isValid ? adjustedReturnName : null, StructureType.COMMON);
                    responses.put(code, response);
                    continue;
                }
                response.setMessage(message);
                response.setReturnTypeName(adjustedReturnName);
            }
        }
        String[] producesValues = new String[]{};
        ITypeModel iTypeModel = m.getReturnedType();
        if (iTypeModel != null && (producesValues = this.extractMediaTypes(m, PRODUCES, this.classProduces, returnsValue = !iTypeModel.getName().toLowerCase().equals("void"), null)) != null) {
            for (ResponseModel responseModel : responses.values()) {
                responseModel.setProduces(producesValues);
            }
        }
        if ((apiOperation = m.getAnnotation(API_OPERATION)) != null) {
            StructureType st = this.getStructureType(m);
            String responseQualifiedName = apiOperation.getValue(RESPONSE);
            if (responseQualifiedName != null) {
                try {
                    Class<?> responseClass = this.classLoader.loadClass(responseQualifiedName);
                    ReflectionType rt = new ReflectionType(responseClass);
                    this.generateXMLSchema(rt, st);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                String adjustedReturnType = this.firstLetterToLowerCase(this.getSimpleName(responseQualifiedName));
                mainResponse.setReturnTypeName(adjustedReturnType);
                mainResponse.setStructureType(st);
            }
        }
        for (ResponseModel rm : responses.values()) {
            String[] produces;
            Response response = new Response();
            String description = rm.getMessage();
            if (description == null || description.trim().isEmpty()) {
                description = documentation.getReturnInfo();
            }
            if (description != null && !description.trim().isEmpty()) {
                response.setDescription(description);
            }
            if ((produces = rm.getProduces()) != null) {
                String returnTypeName = rm.getReturnTypeName();
                for (String mediaType : producesValues) {
                    mediaType = this.sanitizeMediaType(mediaType);
                    MimeType mimeType = new MimeType();
                    this.tryAppendSchemesAndExamples(mimeType, mediaType, returnTypeName, rm.getStructureType());
                    mimeType.setType(mediaType);
                    response.getBody().put(mediaType, mimeType);
                }
            }
            String code = rm.getCode();
            action.getResponses().put(code, response);
        }
    }

    private StructureType getStructureType(IMethodModel m) {
        String responseContainer;
        StructureType st = StructureType.COMMON;
        IAnnotationModel apiOperation = m.getAnnotation(API_OPERATION);
        if (apiOperation != null && (responseContainer = apiOperation.getValue("responseContainer")) != null) {
            if ((responseContainer = responseContainer.toLowerCase()).equals("set") || responseContainer.equals("list")) {
                st = StructureType.COLLECTION;
            } else if (responseContainer.equals("map")) {
                st = StructureType.MAP;
            }
        }
        return st;
    }

    private String[] extractMediaTypes(IMethodModel m, String annotationName, String[] defaultValues, boolean useDefault, ActionType at) {
        String value;
        useDefault = at != ActionType.GET;
        IAnnotationModel apiOperation1 = m.getAnnotation(API_OPERATION);
        String[] values = null;
        if (apiOperation1 != null && (value = apiOperation1.getValue(annotationName.toLowerCase())) != null) {
            values = value.split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        if (values == null) {
            values = m.getAnnotationValues(annotationName);
        }
        if (values != null) {
            return values;
        }
        if (!useDefault) {
            return null;
        }
        if (values == null) {
            values = defaultValues;
        }
        return values;
    }

    private String getSimpleName(String qName) {
        int ind = qName.lastIndexOf(46);
        String simpleName = qName.substring(ind + 1);
        return simpleName;
    }

    private ActionType adjustActionType(IMethodModel m, ActionType actionType) {
        IAnnotationModel a = m.getAnnotation(API_OPERATION);
        if (a == null) {
            return actionType;
        }
        String atString = a.getValue("httpMethod");
        if (atString == null || atString.trim().isEmpty()) {
            return actionType;
        }
        ActionType adjustedActionType = null;
        try {
            adjustedActionType = Enum.valueOf(ActionType.class, atString);
        }
        catch (Exception e) {
            return actionType;
        }
        return adjustedActionType;
    }

    private String configureParam(IParameterModel model, AbstractParam param, IDocInfo documentation, IAnnotationModel paramAnnotation) {
        String max;
        String min;
        String paramName = paramAnnotation.getValue("value");
        String type = model.getParameterType();
        this.proceedType(type, param, model);
        String text = documentation.getDocumentation(model.getName());
        if (!"".equals(text)) {
            param.setDescription(text);
        }
        if (model.hasAnnotation("NotNull")) {
            param.setRequired(true);
        }
        if (model.hasAnnotation("Pattern")) {
            IAnnotationModel annotation = model.getAnnotation("Pattern");
            String pattern = annotation.getValue("regexp");
            param.setPattern(pattern);
        }
        if (model.hasAnnotation("Min")) {
            min = model.getAnnotationValue("Min");
            param.setMinimum(BigDecimal.valueOf(Double.parseDouble(min)));
        }
        if (model.hasAnnotation("DecimalMin")) {
            min = model.getAnnotationValue("DecimalMin");
            param.setMinimum(BigDecimal.valueOf(Double.parseDouble(min)));
        }
        if (model.hasAnnotation("Max")) {
            max = model.getAnnotationValue("Max");
            param.setMaximum(BigDecimal.valueOf(Double.parseDouble(max)));
        }
        if (model.hasAnnotation("DecimalMax")) {
            max = model.getAnnotationValue("DecimalMax");
            param.setMaximum(BigDecimal.valueOf(Double.parseDouble(max)));
        }
        if (model.hasAnnotation("ApiParam")) {
            String overridenName;
            String description;
            String required;
            String defaultValue;
            String allowMultiple;
            IAnnotationModel ann = model.getAnnotation("ApiParam");
            String allowableValues = ann.getValue("allowableValues");
            if (allowableValues != null && !allowableValues.trim().isEmpty()) {
                int start = 0;
                int end = allowableValues.length();
                if (allowableValues.startsWith("[")) {
                    ++start;
                }
                if (allowableValues.endsWith("]")) {
                    --end;
                }
                allowableValues = allowableValues.substring(start, end);
                String[] split = allowableValues.split(",");
                ArrayList<String> list = new ArrayList<String>();
                for (String s : split) {
                    list.add(s.trim());
                }
                param.setEnumeration(list);
            }
            if ((allowMultiple = ann.getValue("allowMultiple")) != null) {
                boolean boolValue = Boolean.parseBoolean(allowMultiple);
                param.setRepeat(boolValue);
            }
            if ((defaultValue = ann.getValue("defaultValue")) != null && !defaultValue.trim().isEmpty()) {
                param.setDefaultValue(defaultValue.trim());
            }
            if ((required = ann.getValue("required")) != null && !required.trim().isEmpty()) {
                boolean boolValue = Boolean.parseBoolean(required);
                param.setRequired(boolValue);
            }
            if ((description = ann.getValue("value")) != null && !description.trim().isEmpty()) {
                param.setDescription(description);
            }
            if ((overridenName = ann.getValue("name")) != null && !overridenName.trim().isEmpty()) {
                paramName = overridenName;
            }
        }
        return paramName;
    }

    private String sanitizeMediaType(String s) {
        if ((s = s.toLowerCase()).contains(FORM)) {
            if (s.contains("urlencoded")) {
                s = "application/x-www-form-urlencoded";
            }
            if (s.contains("multipart")) {
                s = "multipart/form-data";
            }
        }
        if (s.contains("text")) {
            if (s.contains("html")) {
                s = "text/html";
            }
            if (s.contains("plain")) {
                s = "text/plain";
            }
        }
        if (s.contains("octet")) {
            return "application/octet-stream";
        }
        if (s.contains(XML)) {
            s = "application/xml";
        }
        if (s.contains(JSON)) {
            s = "application/json";
        }
        return s;
    }

    private void proceedType(String type, AbstractParam value2, IParameterModel param) {
        String annotationValue = param.getAnnotationValue(DEFAULT_VALUE);
        boolean hasDefault = false;
        if (annotationValue != null) {
            value2.setDefaultValue(annotationValue);
            hasDefault = true;
        }
        if (type.equals("I")) {
            value2.setType(ParamType.INTEGER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("D")) {
            value2.setType(ParamType.NUMBER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("Z")) {
            value2.setType(ParamType.BOOLEAN);
        }
        if (type.equals("int") || type.equals("long") || type.equals("short")) {
            value2.setType(ParamType.INTEGER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("float") || type.equals("double")) {
            value2.setType(ParamType.NUMBER);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("boolean")) {
            value2.setType(ParamType.BOOLEAN);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("QInteger;")) {
            value2.setType(ParamType.INTEGER);
        }
        if (type.equals("QDouble;")) {
            value2.setType(ParamType.NUMBER);
        }
        if (type.equals("QBoolean;")) {
            value2.setType(ParamType.BOOLEAN);
            value2.setRequired(!hasDefault);
        }
        if (type.equals("java.lang.Integer") || type.equals("java.lang.Long") || type.equals("java.lang.Short")) {
            value2.setType(ParamType.INTEGER);
        }
        if (type.equals("java.lang.Float") || type.equals("java.lang.Double")) {
            value2.setType(ParamType.NUMBER);
        }
        if (type.equals("java.lang.Boolean")) {
            value2.setType(ParamType.BOOLEAN);
        }
    }

    protected String generateXSDForClass(Class<?> element) {
        try {
            String name = this.firstLetterToLowerCase(element.getSimpleName());
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{element});
            CustomSchemaOutputResolver sor = new CustomSchemaOutputResolver(name);
            jaxbContext.generateSchema((SchemaOutputResolver)sor);
            File file = sor.getFile();
            if (file != null) {
                String content = FileUtil.fileToString(file);
                this.generateExamle(file, content);
                String schemaName = this.getSchemaName(element.getSimpleName(), XML, StructureType.COMMON);
                this.spec.getCoreRaml().addGlobalSchema(schemaName, content, false, true);
                return content;
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected File constructFileLocation(String name, String fileType, String mediaType, StructureType st) {
        if (this.outputFile == null) {
            return new File(this.constructFileName(name, fileType, mediaType, st));
        }
        return new File(this.outputFile.getParent(), this.constructRelativeFilePath(name, fileType, mediaType, st));
    }

    protected String constructRelativeFilePath(String name, String fileType, String mediaType, StructureType st) {
        String result = null;
        if (fileType.equals(EXAMPLE)) {
            result = "examples/" + this.constructFileName(name, fileType, mediaType, st);
        } else if (fileType.equals(SCHEMA)) {
            result = "schemas/" + this.constructFileName(name, fileType, mediaType, st);
        }
        return result;
    }

    protected String constructFileName(String name, String fileType, String mediaType, StructureType st) {
        String stStr = st == StructureType.COMMON || st == null ? "" : "-" + st.toString().toLowerCase();
        String name1 = this.firstLetterToLowerCase(name);
        String result = null;
        if (fileType.equals(EXAMPLE)) {
            if (mediaType.equals(XML)) {
                result = name1 + stStr + "-" + EXAMPLE + XML_FILE_EXT;
            } else if (mediaType.equals(JSON)) {
                result = name1 + stStr + "-" + EXAMPLE + JSON_FILE_EXT;
            }
        } else if (fileType.equals(SCHEMA)) {
            if (mediaType.equals(XML)) {
                result = name1 + stStr + "-xml-" + SCHEMA + XSD_FILE_EXT;
            } else if (mediaType.equals(JSON)) {
                result = name1 + stStr + "-" + SCHEMA + JSON_FILE_EXT;
            }
        }
        return result;
    }

    public void clear() {
        this.spec.coreRaml = new Raml2();
        this.spec.coreRaml.setBaseUri("http://example.com");
        this.spec.coreRaml.setTitle("Please type API title here");
        this.spec.coreRaml.setProtocols(Collections.singletonList(Protocol.HTTP));
    }

    public boolean isEmpty() {
        return this.spec.coreRaml.getResources().isEmpty();
    }

    protected void doGenerateAndSave(File schemaFile, File parentDir, File examplesDir, String dummyXml) {
        String jsonText = JsonUtil.convertToJSON(dummyXml, true);
        jsonText = JsonFormatter.format(jsonText);
        String fName = schemaFile.getName().replace(XML_FILE_EXT, JSONSCHEMA);
        fName = fName.replace(XSD_FILE_EXT, JSONSCHEMA);
        String generatedSchema = jsonText != null ? new SchemaGenerator().generateSchema(jsonText) : null;
        String string = generatedSchema = generatedSchema != null ? JsonFormatter.format(generatedSchema) : null;
        if (generatedSchema != null) {
            this.spec.getCoreRaml().addGlobalSchema(fName, generatedSchema, true, false);
        }
        String name = schemaFile.getName();
        name = name.substring(0, name.lastIndexOf(46));
        File toSave = new File(examplesDir, name + XML_FILE_EXT);
        this.writeString(dummyXml, toSave);
        toSave = new File(examplesDir, name + JSON_FILE_EXT);
        if (jsonText != null) {
            this.writeString(jsonText, toSave);
        }
        File shemas = new File(parentDir, SCHEMAS_FOLDER);
        toSave = new File(shemas, fName + JSON_FILE_EXT);
        if (generatedSchema != null) {
            this.writeString(generatedSchema, toSave);
        }
    }

    protected void writeString(String str, File toSave) {
        if (str == null || toSave == null) {
            return;
        }
        toSave.getParentFile().mkdirs();
        try {
            toSave.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(toSave);
            fileOutputStream.write(str.getBytes("UTF-8"));
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void generateExamle(File schemaFile, String content) {
    }

    public void setPreferences(IRamlConfig preferencesConfig) {
        this.config = preferencesConfig;
        if (preferencesConfig.getTitle() != null && preferencesConfig.getTitle().length() > 0) {
            this.spec.getCoreRaml().setTitle(preferencesConfig.getTitle());
        }
        if (preferencesConfig.getVersion() != null && preferencesConfig.getVersion().length() > 0) {
            this.spec.getCoreRaml().setVersion(preferencesConfig.getVersion());
        }
        if (preferencesConfig.getBaseUrl() != null && preferencesConfig.getBaseUrl().length() > 0) {
            this.spec.getCoreRaml().setBaseUri(preferencesConfig.getBaseUrl());
        }
        if (preferencesConfig.getProtocols() != null) {
            ArrayList<Protocol> protocols = new ArrayList<Protocol>(preferencesConfig.getProtocols());
            Collections.sort(protocols);
            this.spec.getCoreRaml().setProtocols(protocols);
        }
        this.spec.doSort = preferencesConfig.isSorted();
        this.spec.extractCommonParts = preferencesConfig.doFullTree();
    }

    protected void afterSchemaGen(ITypeModel t, StructureType st) {
        JAXBRegistry rs = new JAXBRegistry();
        JAXBType jaxbModel = rs.getJAXBModel(t);
        if (jaxbModel == null) {
            return;
        }
        ISchemaType schemaModel = null;
        try {
            schemaModel = new SchemaModelBuilder(rs, this.config).buildSchemaModel(jaxbModel, st);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (schemaModel == null) {
            return;
        }
        try {
            if (st == null || st == StructureType.COMMON) {
                String xmlExample = new XMLModelSerializer().serialize(schemaModel);
                this.writeString(xmlExample, this.constructFileLocation(t.getName(), EXAMPLE, XML, st));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String jsonExample = new JsonModelSerializer().serialize(schemaModel);
            this.writeString(jsonExample, this.constructFileLocation(t.getName(), EXAMPLE, JSON, st));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String jsonSchema = new JsonSchemaModelSerializer().serialize(schemaModel);
            this.spec.getCoreRaml().addGlobalSchema(this.getSchemaName(t.getName(), JSON, st), jsonSchema, true, true);
            this.writeString(jsonSchema, this.constructFileLocation(t.getName(), SCHEMA, JSON, st));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSchemaName(String typeName, String mediaType, StructureType st) {
        StringBuilder bld = new StringBuilder(this.firstLetterToLowerCase(typeName));
        if (st != null && st != StructureType.COMMON) {
            bld.append("-").append(st.toString().toLowerCase());
        }
        if (mediaType.toLowerCase().indexOf(XML.toLowerCase()) >= 0) {
            bld.append("-xml");
        }
        return bld.toString();
    }

    private String firstLetterToLowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    private static class ResponseModel {
        private StructureType structureType;
        private String code;
        private String message;
        private String returnTypeName;
        private String[] produces;

        public ResponseModel(String code, String message, String returnTypeName, StructureType structureType) {
            this.code = code;
            this.message = message;
            this.returnTypeName = returnTypeName;
            this.structureType = structureType;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getReturnTypeName() {
            return this.returnTypeName;
        }

        public void setReturnTypeName(String returnTypeName) {
            this.returnTypeName = returnTypeName;
        }

        public String[] getProduces() {
            return this.produces;
        }

        public void setProduces(String[] produces) {
            this.produces = produces;
        }

        public StructureType getStructureType() {
            return this.structureType;
        }

        public void setStructureType(StructureType structureType) {
            this.structureType = structureType;
        }
    }

    class StringHolder {
        String content;

        StringHolder() {
        }
    }

    public class CustomSchemaOutputResolver
    extends SchemaOutputResolver {
        private final String name;
        private File file;

        public CustomSchemaOutputResolver(String name) {
            this.name = name;
        }

        public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
            this.file = ResourceVisitor.this.constructFileLocation(this.name, ResourceVisitor.SCHEMA, ResourceVisitor.XML, StructureType.COMMON);
            this.file.getParentFile().mkdirs();
            StreamResult result = new StreamResult(this.file);
            result.setSystemId(this.file.toURI().toURL().toString());
            return result;
        }

        public File getFile() {
            return this.file;
        }
    }
}

