/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model;

import com.mulesoft.jaxrs.raml.annotation.model.ClassHierarchyVisitor;
import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IDocInfo;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeParameter;
import com.mulesoft.jaxrs.raml.annotation.model.WrapperParameterModel;
import java.util.List;
import org.raml.model.ActionType;

public class WrapperMethodModel
implements IMethodModel {
    private ITypeModel ownerType;
    private IMethodModel originalMethod;
    private IMethodModel actualMethod;

    public WrapperMethodModel(ITypeModel ownerType, IMethodModel originalMethod) {
        this.ownerType = ownerType;
        this.originalMethod = originalMethod;
    }

    @Override
    public String getName() {
        return this.originalMethod.getName();
    }

    @Override
    public String getDocumentation() {
        return this.originalMethod.getDocumentation();
    }

    @Override
    public IAnnotationModel[] getAnnotations() {
        return this.originalMethod.getAnnotations();
    }

    @Override
    public String getAnnotationValue(String annotation) {
        return this.getActualMethod().getAnnotationValue(annotation);
    }

    @Override
    public String[] getAnnotationValues(String annotation) {
        return this.getActualMethod().getAnnotationValues(annotation);
    }

    @Override
    public boolean hasAnnotation(String name) {
        return this.getActualMethod().hasAnnotation(name);
    }

    @Override
    public IAnnotationModel getAnnotation(String name) {
        return this.getActualMethod().getAnnotation(name);
    }

    @Override
    public boolean hasAnnotationWithCanonicalName(String name) {
        return this.getActualMethod().hasAnnotationWithCanonicalName(name);
    }

    @Override
    public IAnnotationModel getAnnotationByCanonicalName(String name) {
        return this.getActualMethod().getAnnotationByCanonicalName(name);
    }

    @Override
    public ITypeModel getType() {
        return this.originalMethod.getType();
    }

    @Override
    public List<ITypeModel> getJAXBTypes() {
        return this.originalMethod.getJAXBTypes();
    }

    @Override
    public Class<?> getJavaType() {
        return this.originalMethod.getJavaType();
    }

    @Override
    public boolean isCollection() {
        return this.originalMethod.isCollection();
    }

    @Override
    public boolean isMap() {
        return this.originalMethod.isMap();
    }

    @Override
    public List<ITypeParameter> getTypeParameters() {
        return this.originalMethod.getTypeParameters();
    }

    @Override
    public IParameterModel[] getParameters() {
        IParameterModel[] originalParams = this.originalMethod.getParameters();
        IParameterModel[] arr = new IParameterModel[originalParams.length];
        for (int i = 0; i < originalParams.length; ++i) {
            arr[i] = new WrapperParameterModel(this.ownerType, this.originalMethod, originalParams[i]);
        }
        return arr;
    }

    @Override
    public IDocInfo getBasicDocInfo() {
        return this.originalMethod.getBasicDocInfo();
    }

    @Override
    public ITypeModel getReturnedType() {
        return this.originalMethod.getReturnedType();
    }

    @Override
    public ITypeModel getBodyType() {
        return this.originalMethod.getBodyType();
    }

    @Override
    public boolean isStatic() {
        return this.originalMethod.isStatic();
    }

    @Override
    public boolean isPublic() {
        return this.originalMethod.isPublic();
    }

    @Override
    public boolean hasGenericReturnType() {
        return this.originalMethod.hasGenericReturnType();
    }

    private IMethodModel getActualMethod() {
        if (this.actualMethod != null) {
            return this.actualMethod;
        }
        new ClassHierarchyVisitor(){

            @Override
            boolean checkMethod(IMethodModel m) {
                boolean isWS = m.hasAnnotation("Path");
                if (!isWS) {
                    for (ActionType at : ActionType.values()) {
                        isWS = m.hasAnnotation(at.name());
                        WrapperMethodModel.this.actualMethod = m;
                        if (isWS) break;
                    }
                }
                return isWS;
            }
        }.visit(this.ownerType, this.originalMethod);
        if (this.actualMethod != null) {
            return this.actualMethod;
        }
        return this.originalMethod;
    }
}

