/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model.reflection;

import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.BasicReflectionMember;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ReflectionField
extends BasicReflectionMember<Field>
implements IFieldModel {
    public ReflectionField(Field element) {
        super(element);
    }

    @Override
    public String getName() {
        return ((Field)this.element).getName();
    }

    @Override
    public ITypeModel getType() {
        Class<?> returnType = ((Field)this.element).getType();
        return new ReflectionType(returnType);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(((Field)this.element).getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(((Field)this.element).getModifiers());
    }

    @Override
    public List<ITypeModel> getJAXBTypes() {
        return Utils.getJAXBTypes(this.element);
    }

    @Override
    public Class<?> getJavaType() {
        return ((Field)this.element).getType();
    }

    @Override
    public boolean isGeneric() {
        Type[] args;
        Type gType = ((Field)this.element).getGenericType();
        String typeName = ((Field)this.element).getType().getName();
        String gTypeName = gType.toString();
        if (gTypeName.startsWith("class ")) {
            gTypeName = gTypeName.substring("class ".length());
        }
        if (!gTypeName.startsWith(typeName)) {
            return true;
        }
        if (gType instanceof ParameterizedType && (args = ((ParameterizedType)gType).getActualTypeArguments()) != null && args.length != 0) {
            for (Type arg : args) {
                if (!(arg instanceof TypeVariable)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCollection() {
        return Collection.class.isAssignableFrom(((Field)this.element).getType());
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(((Field)this.element).getType());
    }
}

