/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model.reflection;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.AnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import java.lang.annotation.Annotation;

public class ReflectionParameter
implements IParameterModel {
    private static final String VALUE = "value";
    protected ReflectionType type;
    protected String name;
    protected AnnotationModel[] model;

    public ReflectionParameter(ReflectionType type, AnnotationModel[] model, String name) {
        this.type = type;
        this.model = model;
        this.name = name;
    }

    public ReflectionParameter(Class<?> cl, Annotation[] annotations, String name) {
        this.type = new ReflectionType(cl);
        this.name = name;
        this.model = new AnnotationModel[annotations.length];
        int i = 0;
        for (Annotation a : annotations) {
            this.model[i++] = new AnnotationModel(a);
        }
    }

    @Override
    public String getDocumentation() {
        return "";
    }

    @Override
    public String getAnnotationValue(String annotation) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!this.getAnnotationName(q).equals(annotation)) continue;
            return q.getValue(VALUE);
        }
        return null;
    }

    @Override
    public String[] getAnnotationValues(String annotation) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!this.getAnnotationName(q).equals(annotation)) continue;
            return q.getValues(annotation);
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String name) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!this.getAnnotationName(q).equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getAnnotationName(IAnnotationModel q) {
        String n = q.getName();
        int ind = n.lastIndexOf(46);
        return n.substring(++ind);
    }

    @Override
    public boolean hasAnnotationWithCanonicalName(String name) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel q : annotations = this.getAnnotations()) {
            if (!q.getCanonicalName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IAnnotationModel getAnnotationByCanonicalName(String name) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel m : annotations = this.getAnnotations()) {
            if (!m.getCanonicalName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public IAnnotationModel getAnnotation(String name) {
        IAnnotationModel[] annotations;
        for (IAnnotationModel m : annotations = this.getAnnotations()) {
            if (!this.getAnnotationName(m).equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParameterType() {
        String name = this.type.getName();
        return name;
    }

    @Override
    public boolean required() {
        return ((Class)this.type.element).isPrimitive();
    }

    @Override
    public IAnnotationModel[] getAnnotations() {
        return this.model;
    }
}

