/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model.reflection;

import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionField;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionGenericElement;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionType
extends ReflectionGenericElement<Class<?>>
implements ITypeModel {
    public ReflectionType(Class<?> element) {
        super(element);
    }

    @Override
    public IMethodModel[] getMethods() {
        Method[] declaredMethods = ((Class)this.element).getDeclaredMethods();
        IMethodModel[] methods = new IMethodModel[declaredMethods.length];
        int a = 0;
        for (Method m : declaredMethods) {
            methods[a++] = new ReflectionMethod(m);
        }
        return methods;
    }

    @Override
    public String getName() {
        return ((Class)this.element).getSimpleName();
    }

    @Override
    public String getFullyQualifiedName() {
        return ((Class)this.element).getCanonicalName();
    }

    @Override
    public IFieldModel[] getFields() {
        Field[] declaredFields = ((Class)this.element).getDeclaredFields();
        IFieldModel[] fields = new IFieldModel[declaredFields.length];
        int a = 0;
        for (Field m : declaredFields) {
            fields[a++] = new ReflectionField(m);
        }
        return fields;
    }

    @Override
    public ITypeModel getSuperClass() {
        Class superClass = ((Class)this.element).getSuperclass();
        return superClass != null ? new ReflectionType(superClass) : null;
    }

    @Override
    public ITypeModel[] getImplementedInterfaces() {
        Class<?>[] interfaces = ((Class)this.element).getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return new ITypeModel[0];
        }
        ITypeModel[] arr = new ITypeModel[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            arr[i] = new ReflectionType(interfaces[i]);
        }
        return arr;
    }

    @Override
    public ITypeModel resolveClass(String qualifiedName) {
        try {
            Class<?> clazz = ((Class)this.element).getClassLoader().loadClass(qualifiedName);
            if (clazz == null) {
                return null;
            }
            return new ReflectionType(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

