/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.annotation.model.reflection;

import com.mulesoft.jaxrs.raml.annotation.model.IRamlConfig;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.ResourceVisitor;
import com.mulesoft.jaxrs.raml.annotation.model.StructureType;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonUtil;
import java.io.File;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RuntimeResourceVisitor
extends ResourceVisitor {
    public RuntimeResourceVisitor(File outputFile, ClassLoader classLoader) {
        super(outputFile, classLoader);
    }

    public RuntimeResourceVisitor(File outputFile, ClassLoader classLoader, IRamlConfig preferencesConfig) {
        super(outputFile, classLoader);
        this.setPreferences(preferencesConfig);
    }

    protected String getProperJSONExampleFromXML(String generateXMLExampleJAXB, ITypeModel t) {
        String jsonText = JsonUtil.convertToJSON(generateXMLExampleJAXB, true);
        try {
            JSONObject c = new JSONObject(jsonText);
            jsonText = c.get((String)c.keys().next()).toString();
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
        jsonText = JsonFormatter.format(jsonText);
        return jsonText;
    }

    @Override
    protected boolean generateXMLSchema(ITypeModel t, StructureType st) {
        String name = t.getFullyQualifiedName();
        if (name.equals("void") || name.equals("java.lang.Void")) {
            return false;
        }
        Class<?> element = null;
        if (t instanceof ReflectionType) {
            element = (Class<?>)((ReflectionType)t).getElement();
        } else if (t.getFullyQualifiedName() != null && this.classLoader != null) {
            try {
                element = this.classLoader.loadClass(t.getFullyQualifiedName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (element == null) {
            return false;
        }
        if (st == null || st == StructureType.COMMON) {
            this.generateXSDForClass(element);
        }
        this.afterSchemaGen(t, st);
        return true;
    }

    @Override
    protected ResourceVisitor createResourceVisitor() {
        return new RuntimeResourceVisitor(this.outputFile, this.classLoader);
    }
}

