/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jaxb;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IBasicModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.jaxb.JAXBRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

public class JAXBModelElement {
    protected static final String NAMESPACE = "namespace";
    protected static final String NAME = "name";
    protected IBasicModel originalModel;
    protected ITypeModel ownerType;
    protected String namespace;
    protected String typeName;
    protected String elementName;
    final JAXBRegistry registry;
    protected ArrayList<IAnnotationModel> annotations;

    public JAXBModelElement(IBasicModel model, ITypeModel ownerType, JAXBRegistry registry) {
        this.registry = registry;
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.originalModel = model;
        this.ownerType = ownerType;
        this.elementName = this.value(XmlElement.class, NAME);
        this.namespace = this.value(XmlElement.class, NAMESPACE);
        this.typeName = this.value(XmlType.class, NAME);
        IAnnotationModel[] modelAnnotations = model.getAnnotations();
        this.annotations = modelAnnotations != null ? new ArrayList<IAnnotationModel>(Arrays.asList(modelAnnotations)) : new ArrayList();
    }

    public String value(Class<? extends Annotation> cl, String name) {
        IAnnotationModel annotation = this.originalModel.getAnnotation(cl.getSimpleName());
        if (annotation != null) {
            return annotation.getValue(name);
        }
        return null;
    }

    public List<IAnnotationModel> getAnnotations() {
        return this.annotations;
    }
}

