/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jaxb;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMember;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.StructureType;
import com.mulesoft.jaxrs.raml.jaxb.JAXBModelElement;
import com.mulesoft.jaxrs.raml.jaxb.JAXBRegistry;
import com.mulesoft.jaxrs.raml.jaxb.JAXBType;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyAttribute;

public abstract class JAXBProperty
extends JAXBModelElement {
    String propertyName;
    boolean required;
    private boolean isCollection;
    private boolean isMap;
    protected IMethodModel setter;

    public JAXBProperty(IMember model, IMethodModel setter, ITypeModel ownerType, JAXBRegistry r, String name) {
        super(model, ownerType, r);
        IAnnotationModel[] setterAnnotations;
        String value;
        this.propertyName = name;
        this.isCollection = model.isCollection();
        this.isMap = model.isMap();
        this.setter = setter;
        IAnnotationModel annotation = model.getAnnotation(this.getPropertyAnnotation());
        if (annotation != null && (value = annotation.getValue("required")) != null && value.equals("true")) {
            this.required = true;
        }
        if (setter != null && (setterAnnotations = setter.getAnnotations()) != null) {
            this.annotations.addAll(Arrays.asList(setterAnnotations));
        }
    }

    protected abstract String getPropertyAnnotation();

    JAXBType getType() {
        if (this.originalModel instanceof IFieldModel) {
            ITypeModel type = ((IFieldModel)this.originalModel).getType();
            return this.registry.getJAXBModel(type);
        }
        if (this.originalModel instanceof IMethodModel) {
            ITypeModel type = ((IMethodModel)this.originalModel).getReturnedType();
            return this.registry.getJAXBModel(type);
        }
        return null;
    }

    public String name() {
        return this.elementName != null ? this.elementName : this.propertyName;
    }

    public Class<?> asJavaType() {
        if (this.originalModel instanceof IMember) {
            IMember or = (IMember)this.originalModel;
            return or.getJavaType();
        }
        return null;
    }

    public StructureType getStructureType() {
        if (this.isCollection || this.asJavaType() != null && Collection.class.isAssignableFrom(this.asJavaType())) {
            return StructureType.COLLECTION;
        }
        if (this.isMap || this.asJavaType() != null && Map.class.isAssignableFrom(this.asJavaType()) || this.originalModel.hasAnnotation(XmlAnyAttribute.class.getSimpleName())) {
            return StructureType.MAP;
        }
        return StructureType.COMMON;
    }

    public boolean isGeneric() {
        if (this.originalModel instanceof IFieldModel) {
            return ((IFieldModel)this.originalModel).isGeneric();
        }
        if (this.originalModel instanceof IMethodModel) {
            return ((IMethodModel)this.originalModel).hasGenericReturnType();
        }
        return false;
    }

    @Override
    public String value(Class<? extends Annotation> cl, String name) {
        IAnnotationModel annotation;
        String superValue = super.value(cl, name);
        if (superValue != null) {
            return superValue;
        }
        if (this.setter != null && (annotation = this.originalModel.getAnnotation(cl.getSimpleName())) != null && (annotation = this.setter.getAnnotation(cl.getSimpleName())) != null) {
            return annotation.getValue(name);
        }
        return null;
    }
}

