/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jaxb;

import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMember;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.jaxb.JAXBAttributeProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBElementProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBModelElement;
import com.mulesoft.jaxrs.raml.jaxb.JAXBProperty;
import com.mulesoft.jaxrs.raml.jaxb.JAXBRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

public class JAXBType
extends JAXBModelElement {
    protected JAXBType superClass;
    protected String className;
    protected ArrayList<JAXBProperty> properties = new ArrayList();

    public JAXBType(ITypeModel model, JAXBRegistry r) {
        super(model, model, r);
        IMethodModel[] methods = model.getMethods();
        String value = this.value(XmlAccessorType.class, "value");
        XmlAccessType type = XmlAccessType.PUBLIC_MEMBER;
        this.className = model.getFullyQualifiedName();
        if (value != null) {
            type = this.extractType(value);
        }
        if (this.className.equals("java.lang.Object")) {
            return;
        }
        HashMap<String, ArrayList<IMethodModel>> map = new HashMap<String, ArrayList<IMethodModel>>();
        for (IMethodModel iMethodModel : methods) {
            String name = iMethodModel.getName();
            ArrayList<IMethodModel> list = (ArrayList<IMethodModel>)map.get(name);
            if (list == null) {
                list = new ArrayList<IMethodModel>();
                map.put(name, list);
            }
            list.add(iMethodModel);
        }
        for (IMethodModel iMethodModel : methods) {
            String methodName;
            String qName;
            boolean needToConsume = this.needToConsume(type, iMethodModel);
            if (!needToConsume) continue;
            IParameterModel[] getterParams = iMethodModel.getParameters();
            ITypeModel returnedType = iMethodModel.getReturnedType();
            if (returnedType == null || (qName = returnedType.getFullyQualifiedName()).equals("void") || qName.equals("java.lang.Void") || getterParams != null && getterParams.length != 0) continue;
            boolean get = iMethodModel.getName().startsWith("get");
            boolean is = iMethodModel.getName().startsWith("is");
            if (!get && !is) continue;
            String string = methodName = get ? iMethodModel.getName().substring(3) : iMethodModel.getName().substring(2);
            if (methodName.isEmpty()) continue;
            IMethodModel setter = null;
            List list = (List)map.get("set" + methodName);
            if (list != null) {
                for (IMethodModel mm : list) {
                    IParameterModel[] params;
                    ITypeModel rt = mm.getReturnedType();
                    if (rt != null && !rt.getFullyQualifiedName().equals("void") && !rt.getFullyQualifiedName().equals("java.lang.Void") || (params = mm.getParameters()) == null || params.length != 1) continue;
                    String paramType = params[0].getParameterType();
                    if (paramType.equals(qName)) {
                        setter = mm;
                        break;
                    }
                    ITypeModel paramModel = model.resolveClass(paramType);
                    if (paramModel == null || !paramModel.getFullyQualifiedName().equals(qName)) continue;
                    setter = mm;
                    break;
                }
            }
            if (setter == null && !iMethodModel.hasAnnotation(XmlElement.class.getSimpleName()) && !iMethodModel.hasAnnotation(XmlAttribute.class.getSimpleName()) && !iMethodModel.hasAnnotation(XmlAnyAttribute.class.getSimpleName())) continue;
            this.properties.add(this.createProperty(methodName, iMethodModel, setter, model));
        }
        for (IMember iMember : model.getFields()) {
            boolean needToConsume;
            if (iMember.isStatic() || !(needToConsume = this.needToConsume(type, iMember))) continue;
            this.properties.add(this.createProperty(iMember.getName(), iMember, null, model));
        }
    }

    private boolean needToConsume(XmlAccessType type, IMember m) {
        boolean needToConsume = false;
        if (!m.isStatic()) {
            if (type == XmlAccessType.PUBLIC_MEMBER && m.isPublic()) {
                needToConsume = true;
            }
            if (type == XmlAccessType.PROPERTY && m instanceof IMethodModel) {
                needToConsume = true;
            }
            if (type == XmlAccessType.FIELD && m instanceof IFieldModel) {
                needToConsume = true;
            }
            if (m.hasAnnotation(XmlTransient.class.getSimpleName())) {
                needToConsume = false;
                return false;
            }
            boolean isElement = m.hasAnnotation(XmlElement.class.getSimpleName());
            boolean isAttribute = m.hasAnnotation(XmlAttribute.class.getSimpleName());
            boolean isValue = m.hasAnnotation(XmlValue.class.getSimpleName());
            if (isElement || isAttribute || isValue) {
                needToConsume = true;
            }
        }
        return needToConsume;
    }

    private XmlAccessType extractType(String value) {
        try {
            int ind = value.lastIndexOf(46);
            if (ind != -1) {
                return XmlAccessType.valueOf((String)value.substring(ind + 1));
            }
            return XmlAccessType.valueOf((String)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return XmlAccessType.NONE;
        }
    }

    private JAXBProperty createProperty(String string, IMember m, IMethodModel setter, ITypeModel ownerType) {
        boolean isElement = m.hasAnnotation(XmlElement.class.getSimpleName());
        boolean isAttribute = m.hasAnnotation(XmlAttribute.class.getSimpleName()) || m.hasAnnotation(XmlAnyAttribute.class.getSimpleName());
        boolean isValue = m.hasAnnotation(XmlValue.class.getSimpleName());
        if (isElement) {
            return new JAXBElementProperty(m, setter, ownerType, this.registry, string);
        }
        if (isAttribute) {
            return new JAXBAttributeProperty(m, setter, ownerType, this.registry, string);
        }
        if (isValue) {
            return new JAXBAttributeProperty(m, setter, ownerType, this.registry, string);
        }
        return new JAXBElementProperty(m, setter, ownerType, this.registry, string);
    }

    public String getClassName() {
        return this.className;
    }

    public String getXMLName() {
        return this.elementName != null ? this.elementName : this.originalModel.getName().toLowerCase();
    }

    public HashMap<String, String> gatherNamespaces() {
        int n = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        this.fillNamespaceMap(map, n, null);
        return map;
    }

    private int fillNamespaceMap(HashMap<String, String> map, int n, Set<String> processed) {
        if (processed == null) {
            processed = new HashSet<String>();
        }
        for (JAXBProperty p : this.properties) {
            String qName;
            JAXBType type;
            if (p.namespace != null) {
                map.put(p.namespace, "n" + n++);
            }
            if ((type = p.getType()) == null || processed.contains(qName = type.getClassName())) continue;
            processed.add(qName);
            if (type != null) {
                n = type.fillNamespaceMap(map, n, processed);
            }
            processed.remove(qName);
        }
        return n;
    }

    public ArrayList<JAXBProperty> getAllProperties() {
        LinkedHashMap<String, JAXBProperty> map = new LinkedHashMap<String, JAXBProperty>();
        JAXBType type = this;
        while (type != null) {
            ITypeModel superClazz;
            if (type.properties != null) {
                for (JAXBProperty prop : type.properties) {
                    String propName = prop.name();
                    if (map.containsKey(propName)) continue;
                    map.put(propName, prop);
                }
            }
            if ((superClazz = ((ITypeModel)type.originalModel).getSuperClass()) == null) {
                type = null;
                continue;
            }
            type = this.registry.getJAXBModel(superClazz);
        }
        ArrayList<JAXBProperty> result = new ArrayList<JAXBProperty>(map.values());
        return result;
    }
}

