/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jaxb;

import com.mulesoft.jaxrs.raml.jaxb.IExampleWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLWriter
implements IExampleWriter {
    Document document;
    private Element currentElement;

    public XMLWriter() {
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        try {
            TransformerFactory newInstance = TransformerFactory.newInstance();
            newInstance.setAttribute("indent-number", 4);
            Transformer newTransformer = newInstance.newTransformer();
            newTransformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            newTransformer.transform(new DOMSource(this.document), new StreamResult(writer));
            writer.close();
            return writer.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void startEntity(String xmlName) {
        Element newElement = this.document.createElement(xmlName);
        this.onElement(newElement);
    }

    @Override
    public void endEntity(String xmlName) {
        Node parentNode = this.currentElement.getParentNode();
        if (parentNode instanceof Element) {
            this.currentElement = (Element)parentNode;
        }
    }

    @Override
    public void generateAttribute(String name, Class<?> type, boolean required) {
        this.currentElement.setAttribute(name, this.getValueString(type));
    }

    private String getValueString(Class<?> type) {
        if (type == byte[].class) {
            return "some base64 encoded binary";
        }
        if (type != null) {
            return "some " + type.getSimpleName().toLowerCase() + " value";
        }
        return "some value";
    }

    @Override
    public void generateElement(String name, Class<?> type, boolean required) {
        Element newElement = this.document.createElement(name);
        newElement.setTextContent(this.getValueString(type));
        this.currentElement.appendChild(newElement);
    }

    @Override
    public void addValueSample(Class<?> type, boolean required) {
        this.currentElement.setTextContent(this.getValueString(type));
    }

    @Override
    public void startEntityAndDeclareNamespaces(String xmlName, HashMap<String, String> prefixes) {
        Element newElement = this.document.createElement(xmlName);
        for (String url : prefixes.keySet()) {
            newElement.setAttribute("xmlns:" + prefixes.get(url), url);
        }
        this.onElement(newElement);
    }

    private void onElement(Element newElement) {
        if (this.currentElement == null) {
            this.document.appendChild(newElement);
        } else {
            this.currentElement.appendChild(newElement);
        }
        this.currentElement = newElement;
    }
}

