/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jsonschema;

import com.mulesoft.jaxrs.raml.annotation.model.StructureType;
import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.raml.schema.model.DefaultValueFactory;
import org.raml.schema.model.IMapSchemaProperty;
import org.raml.schema.model.ISchemaProperty;
import org.raml.schema.model.ISchemaType;
import org.raml.schema.model.SimpleType;
import org.raml.schema.model.impl.TypeModelImpl;
import org.raml.schema.model.serializer.ISerializationNode;
import org.raml.schema.model.serializer.StructuredModelSerializer;

public class JsonModelSerializer
extends StructuredModelSerializer {
    @Override
    protected ISerializationNode createNode(ISchemaType type, ISchemaProperty prop, ISerializationNode parent) {
        return new Node(type, prop);
    }

    private static class Node
    implements ISerializationNode {
        private JSONObject object;
        private JSONArray array;
        private StructureType structureType;

        public Node(ISchemaType type, ISchemaProperty prop) {
            block14: {
                StructureType structureType = this.structureType = prop != null ? prop.getStructureType() : type.getParentStructureType();
                if (this.structureType == StructureType.COLLECTION) {
                    this.array = new JSONArray();
                    if (type.isComplex()) {
                        this.array.put((Object)new JSONObject());
                        this.array.put((Object)new JSONObject());
                    } else {
                        Object defaultValue = prop != null ? DefaultValueFactory.getDefaultValue(prop) : DefaultValueFactory.getDefaultValue(type);
                        this.array.put(defaultValue);
                        this.array.put(defaultValue);
                    }
                } else if (this.structureType == StructureType.MAP) {
                    this.object = new JSONObject();
                    ISchemaType keyType = SimpleType.STRING;
                    ISchemaType valueType = new TypeModelImpl("Object", "java.lang.Object", null, StructureType.COMMON, null);
                    if (prop != null && prop instanceof IMapSchemaProperty) {
                        keyType = ((IMapSchemaProperty)prop).getKeyType();
                        valueType = ((IMapSchemaProperty)prop).getValueType();
                        if (!keyType.getClassName().equals(SimpleType.STRING.getClassName())) {
                            StringBuilder bld = new StringBuilder("Invalid map key type. Only String is available as key type.");
                            if (type != null) {
                                bld.append(" Type: " + type.getClassQualifiedName());
                            }
                            if (prop != null) {
                                bld.append(" Property: " + prop.getName());
                            }
                            throw new IllegalArgumentException(bld.toString());
                        }
                    }
                    String key = DefaultValueFactory.getDefaultValue(keyType).toString();
                    try {
                        if (valueType.isComplex()) {
                            this.object.put(key + "_1", (Object)new JSONObject());
                            this.object.put(key + "_2", (Object)new JSONObject());
                            break block14;
                        }
                        Object defaultValue = DefaultValueFactory.getDefaultValue(valueType);
                        this.object.put(key + "_1", defaultValue);
                        this.object.put(key + "_2", defaultValue);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else if (type.isComplex()) {
                    this.object = new JSONObject();
                }
            }
        }

        @Override
        public void processProperty(ISchemaType type, ISchemaProperty prop, ISerializationNode childNode, Set<String> processedTypes) {
            if (this.structureType == StructureType.COLLECTION) {
                int l = this.array.length();
                for (int i = 0; i < l; ++i) {
                    try {
                        JSONObject item = (JSONObject)this.array.get(i);
                        this.appendProperty(item, type, prop, childNode);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.structureType == StructureType.MAP) {
                try {
                    Iterator iter = this.object.keys();
                    while (iter.hasNext()) {
                        String key = iter.next().toString();
                        JSONObject value = this.object.getJSONObject(key);
                        this.appendProperty(value, type, prop, childNode);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                this.appendProperty(this.object, type, prop, childNode);
            }
        }

        private void appendProperty(JSONObject item, ISchemaType type, ISchemaProperty prop, ISerializationNode childNode) {
            Node n = (Node)childNode;
            ISchemaType propType = prop.getType();
            String propName = type.getQualifiedPropertyName(prop);
            try {
                if (prop.isAttribute()) {
                    propName = "@" + propName;
                    if (prop.getStructureType() == StructureType.MAP) {
                        IMapSchemaProperty mapProp = (IMapSchemaProperty)prop;
                        Object defaultValue = DefaultValueFactory.getDefaultValue(mapProp.getValueType());
                        item.put(propName + "_1", (Object)(defaultValue + "_1"));
                        item.put(propName + "_2", (Object)(defaultValue + "_2"));
                    } else {
                        Object defaultValue = DefaultValueFactory.getDefaultValue(propType);
                        item.put(propName, defaultValue);
                    }
                } else if (prop.getStructureType() == StructureType.COLLECTION) {
                    item.put(propName, (Object)n.array);
                } else if (propType == null || propType.isComplex()) {
                    item.put(propName, (Object)n.object);
                } else {
                    Object defaultValue = DefaultValueFactory.getDefaultValue(prop);
                    item.put(propName, defaultValue);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getStringValue() {
            if (this.object != null) {
                return JsonFormatter.format(StringEscapeUtils.unescapeJavaScript((String)this.object.toString()));
            }
            if (this.array != null) {
                return JsonFormatter.format(StringEscapeUtils.unescapeJavaScript((String)this.array.toString()));
            }
            return null;
        }
    }
}

