/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.jaxrs.raml.jsonschema;

import com.mulesoft.jaxrs.raml.jsonschema.JsonFormatter;
import com.mulesoft.jaxrs.raml.jsonschema.JsonSchemaNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JsonUtils {
    public static final String[] EMPTY_SCHEMA = new String[]{"{", "  \"type\" : \"object\" ,", "  \"required\" : true ,", "  \"$schema\" : \"http://json-schema.org/draft-03/schema\" ,", "  \"properties\" : {", "    ", "  }", "}"};

    public static boolean isJson(String example) {
        return example.trim().startsWith("{") || example.trim().startsWith("[");
    }

    public static JsonSchemaNode createSchemaNode(String text) {
        try {
            JSONObject object = new JSONObject(text);
            JsonSchemaNode schemaNode = new JsonSchemaNode("", object, null);
            return schemaNode;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static String transformObjectToString(JSONObject object) throws JSONException, IOException {
        StringWriter sw = new StringWriter();
        object.write((Writer)sw);
        StringWriter sw1 = new StringWriter();
        StringEscapeUtils.unescapeJavaScript((Writer)sw1, (String)sw.toString());
        String result = sw1.toString();
        return result;
    }

    public static String transformObjectToString(JSONArray object) throws JSONException, IOException {
        StringWriter sw = new StringWriter();
        object.write((Writer)sw);
        StringWriter sw1 = new StringWriter();
        StringEscapeUtils.unescapeJavaScript((Writer)sw1, (String)sw.toString());
        String result = sw1.toString();
        return result;
    }

    public static String transformObjectToStringAndFormat(JSONObject object) throws JSONException, IOException {
        String content = JsonUtils.transformObjectToString(object);
        String formatted = JsonFormatter.format(content);
        return formatted;
    }

    public static String getEmptySchema() {
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < EMPTY_SCHEMA.length; ++i) {
            String str = EMPTY_SCHEMA[i];
            bld.append(str);
            if (i == EMPTY_SCHEMA.length - 1) continue;
            bld.append("\r\n");
        }
        String result = bld.toString();
        return result;
    }
}

