/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.IRamlFileVisitor;
import org.raml.model.MimeType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.ResourceType;
import org.raml.model.Response;
import org.raml.model.TraitModel;
import org.raml.model.parameter.Header;
import org.raml.model.parameter.QueryParameter;
import org.raml.model.parameter.UriParameter;

public class Raml2
extends Raml {
    private Map<String, ResourceType> resourceTypesModel = new LinkedHashMap<String, ResourceType>();
    private Map<String, TraitModel> traitsModel = new LinkedHashMap<String, TraitModel>();
    private Map<String, String> schemaMap = new LinkedHashMap<String, String>();

    public Map<String, String> getSchemaMap() {
        return this.schemaMap;
    }

    public String getSchemaContent(String schemaName) {
        for (Map q : this.schemas) {
            if (!q.containsKey(schemaName)) continue;
            return (String)q.get(schemaName);
        }
        return null;
    }

    private HashMap<String, String> createSchemaMap(String schemaName, String content) {
        HashMap<String, String> newSchemaLine = new HashMap<String, String>();
        newSchemaLine.put(schemaName, content);
        return newSchemaLine;
    }

    private boolean schemaDeclared(String schemaName) {
        return this.findMapWithSchemaDeclaration(schemaName) != null;
    }

    private Map<String, String> findMapWithSchemaDeclaration(String schemaName) {
        for (Map line : this.schemas) {
            if (!line.keySet().contains(schemaName)) continue;
            return line;
        }
        return null;
    }

    public void addGlobalSchema(String schemaName, String content, boolean json, boolean addSchemaSuffix) {
        HashMap<String, String> newSchemaLine = this.createSchemaMap(schemaName, content);
        String path = "schemas/" + schemaName + (addSchemaSuffix ? "-schema" : "") + "." + (json ? "json" : "xsd");
        this.schemaMap.put(schemaName, path);
        if (!this.schemaDeclared(schemaName)) {
            this.schemas.add(newSchemaLine);
        }
    }

    public void addOrReplaceSchemaContent(String schemaName, String content) {
        Map<String, String> foundMap = this.findMapWithSchemaDeclaration(schemaName);
        if (foundMap != null) {
            foundMap.put(schemaName, content);
        } else {
            HashMap<String, String> map = this.createSchemaMap(schemaName, content);
            this.schemas.add(map);
            this.schemaMap.put(schemaName, "schemas/" + schemaName + ".json");
        }
    }

    public Map<String, ResourceType> getResourceTypesModel() {
        return this.resourceTypesModel;
    }

    public void setResourceTypesModel(Map<String, ResourceType> resourceTypesModel) {
        this.resourceTypesModel = resourceTypesModel;
    }

    public Map<String, TraitModel> getTraitsModel() {
        return this.traitsModel;
    }

    public void setTraitsModel(Map<String, TraitModel> traitsModel) {
        this.traitsModel = traitsModel;
    }

    public void visit(IRamlFileVisitor v) {
        this.visitResources(this.getResources(), v);
        Map<String, ResourceType> resourceTypesModel2 = this.getResourceTypesModel();
        for (ResourceType z : resourceTypesModel2.values()) {
            v.visitResourceType(z);
            this.visitResource(v, z);
        }
        for (TraitModel m : this.getTraitsModel().values()) {
            this.visitAction(v, m);
        }
    }

    public void addGlobalSchema(String name, String content, boolean json) {
        HashMap<String, String> e = new HashMap<String, String>();
        String path = name;
        path = json ? path + "-schema.json" : path + "-schema.xsd";
        e.put(name, content);
        this.getSchemaMap().put(name, "/schemas/" + path);
        for (Map s : this.schemas) {
            if (!s.keySet().contains(name)) continue;
            return;
        }
        this.schemas.add(e);
    }

    private void visitResources(Map<String, Resource> resourceTypesModel2, IRamlFileVisitor v) {
        for (Resource q : resourceTypesModel2.values()) {
            this.visitResource(v, q);
        }
    }

    private void visitResource(IRamlFileVisitor v, Resource q) {
        boolean startVisit = v.startVisit(q);
        if (startVisit) {
            Map<String, UriParameter> uriParameters = q.getUriParameters();
            for (String u : uriParameters.keySet()) {
                v.visit(u, uriParameters.get(u));
            }
            Map<ActionType, Action> actions = q.getActions();
            for (Action a : actions.values()) {
                this.visitAction(v, a);
            }
            this.visitResources(q.getResources(), v);
        }
        v.endVisit(q);
    }

    private void visitAction(IRamlFileVisitor v, Action a) {
        boolean startVisit2 = v.startVisit(a);
        if (startVisit2) {
            Map<String, Header> headers = a.getHeaders();
            for (String string : headers.keySet()) {
                v.visit(string, headers.get(string));
            }
            Map<String, QueryParameter> qp = a.getQueryParameters();
            for (String string : qp.keySet()) {
                v.visit(string, qp.get(string));
            }
            v.startVisitBody();
            Map<String, MimeType> map = a.getBody();
            for (MimeType m : map.values()) {
                v.visit(m);
            }
            v.endVisitBody();
            Map<String, Response> map2 = a.getResponses();
            for (String c : map2.keySet()) {
                Response response = map2.get(c);
                v.startVisit(c, response);
                for (MimeType m : response.getBody().values()) {
                    v.visit(m);
                }
                Map<String, Header> headers2 = response.getHeaders();
                for (String h : headers2.keySet()) {
                    v.visit(h, headers2.get(h));
                }
                v.endVisit(map2.get(c));
            }
        }
        v.endVisit(a);
    }
}

