/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model.validation;

import org.raml.model.validation.Validation;

public class MaximumNumberValidation
implements Validation {
    private Double maximum;

    public MaximumNumberValidation(String maximum) {
        this.maximum = this.parse(maximum);
    }

    public Double parse(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse number: " + value);
        }
    }

    @Override
    public boolean check(String input) {
        return this.maximum.compareTo(this.parse(input)) >= 0;
    }
}

