/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model.validation;

import org.raml.model.validation.Validation;

public class MinimumNumberValidation
implements Validation {
    private Double minimum;

    public MinimumNumberValidation(String minimum) {
        this.minimum = this.parse(minimum);
    }

    public Double parse(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse number: " + value);
        }
    }

    @Override
    public boolean check(String input) {
        return this.minimum.compareTo(this.parse(input)) <= 0;
    }
}

