/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.raml.parser.annotation.ExtraHandler;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.MapTupleBuilder;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.ScalarTupleBuilder;
import org.raml.parser.builder.SequenceBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class SequenceTupleBuilder
extends DefaultTupleBuilder<Node, SequenceNode>
implements SequenceBuilder {
    private String fieldName;
    private Type itemType;
    private ExtraHandler additionalHandler;

    public SequenceTupleBuilder(String fieldName, Type itemType, Class<? extends ExtraHandler> extraHandler) {
        super(new DefaultScalarTupleHandler(fieldName));
        this.itemType = itemType;
        this.fieldName = fieldName;
        if (extraHandler != null && extraHandler != ExtraHandler.class) {
            try {
                this.additionalHandler = extraHandler.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object buildValue(Object parent, SequenceNode node) {
        ArrayList list = new ArrayList();
        if (this.additionalHandler != null) {
            this.additionalHandler.handle(parent, node);
        }
        ReflectionUtils.setProperty(parent, this.fieldName, list);
        return list;
    }

    @Override
    public NodeBuilder getItemBuilder() {
        ParameterizedType pItemType;
        if (this.itemType instanceof Class) {
            if (ReflectionUtils.isWrapperOrString((Class)this.itemType)) {
                return new ScalarTupleBuilder(this.fieldName, (Class)this.itemType, null);
            }
            return new PojoTupleBuilder((Class)this.itemType);
        }
        if (this.itemType instanceof ParameterizedType && Map.class.isAssignableFrom((Class)(pItemType = (ParameterizedType)this.itemType).getRawType())) {
            return new MapTupleBuilder((Class)pItemType.getActualTypeArguments()[1]);
        }
        throw new IllegalArgumentException("Sequence item type not supported: " + this.itemType);
    }
}

