/*
 * Decompiled with CFR 0.152.
 */
package org.raml.schema.model;

import java.util.HashMap;
import org.raml.schema.model.ISchemaProperty;
import org.raml.schema.model.ISchemaType;
import org.raml.schema.model.JAXBClassMapping;
import org.raml.schema.model.SimpleType;

public class DefaultValueFactory {
    public static final int DEFAULT_INTEGER_VALUE = 123;
    public static final double DEFAULT_DOUBLE_VALUE = 123.456;
    public static final float DEFAULT_FLOAT_VALUE = 123.456f;
    public static final char DEFAULT_CHARACTER_VALUE = 'a';
    public static final String DEFAULT_STRING_VALUE = "str1234";
    public static final boolean DEFAULT_BOOLEAN_VALUE = true;
    private static HashMap<SimpleType, Object> defaultvalueMap = new HashMap();

    public static Object getDefaultValue(ISchemaProperty prop) {
        String propValue = prop.getDefaultValue();
        if (propValue != null) {
            return propValue;
        }
        if (prop.isGeneric()) {
            return "Some " + prop.getName() + " value";
        }
        ISchemaType type = prop.getType();
        return DefaultValueFactory.getDefaultValue(type);
    }

    public static Object getDefaultValue(ISchemaType type) {
        JAXBClassMapping mapping = type.getMapping();
        if (mapping != null) {
            return mapping.getExample();
        }
        if (type.isSimple() && type instanceof SimpleType) {
            return defaultvalueMap.get((SimpleType)type);
        }
        return "some " + type.getName() + " value";
    }

    static {
        defaultvalueMap.put(SimpleType.INTEGER, 123);
        defaultvalueMap.put(SimpleType.LONG, 123);
        defaultvalueMap.put(SimpleType.SHORT, 123);
        defaultvalueMap.put(SimpleType.BYTE, 123);
        defaultvalueMap.put(SimpleType.DOUBLE, 123.456);
        defaultvalueMap.put(SimpleType.FLOAT, Float.valueOf(123.456f));
        defaultvalueMap.put(SimpleType.BOOLEAN, true);
        defaultvalueMap.put(SimpleType.CHARACTER, Character.valueOf('a'));
        defaultvalueMap.put(SimpleType.STRING, DEFAULT_STRING_VALUE);
    }
}

