/*
 * Decompiled with CFR 0.152.
 */
package org.raml.schema.model.serializer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.raml.schema.model.IMapSchemaProperty;
import org.raml.schema.model.ISchemaProperty;
import org.raml.schema.model.ISchemaType;
import org.raml.schema.model.serializer.IModelSerializer;
import org.raml.schema.model.serializer.ISerializationNode;

public abstract class StructuredModelSerializer
implements IModelSerializer {
    protected abstract ISerializationNode createNode(ISchemaType var1, ISchemaProperty var2, ISerializationNode var3);

    @Override
    public String serialize(ISchemaType type) {
        if (type.isSimple()) {
            return null;
        }
        ISerializationNode node = this.createNode(type, null, null);
        this.process(type, node, null);
        return node.getStringValue();
    }

    protected void process(ISchemaType type, ISerializationNode node, Set<String> processedTypes) {
        List<ISchemaProperty> properties = type.getProperties();
        if (properties == null) {
            return;
        }
        if (processedTypes == null) {
            processedTypes = new HashSet<String>();
        }
        for (ISchemaProperty prop : properties) {
            ISchemaType childType = prop instanceof IMapSchemaProperty ? ((IMapSchemaProperty)prop).getValueType() : prop.getType();
            String qName = childType.getClassQualifiedName();
            ISerializationNode childNode = this.createNode(childType, prop, node);
            if (!processedTypes.contains(qName)) {
                processedTypes.add(qName);
                if (childNode != null) {
                    this.process(childType, childNode, processedTypes);
                }
                processedTypes.remove(qName);
            }
            node.processProperty(type, prop, childNode, processedTypes);
        }
    }
}

