/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.GenerationConfig;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.RamlToJaxRSGenerationConfig;
import org.raml.jaxrs.generator.extension.resources.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.types.TypeExtension;

public class Configuration {
    private String modelPackage;
    private File outputDirectory;
    private AnnotationStyle jsonMapper;
    private Map<String, String> jsonMapperConfiguration = new HashMap<String, String>();
    private String[] typeConfiguration = new String[0];
    private String resourcePackage;
    private String supportPackage;
    private List<TypeExtension> typeExtensions = new ArrayList<TypeExtension>();
    private Class<GlobalResourceExtension> defaultCreationExtension;
    private Class<GlobalResourceExtension> defaultFinishExtension;

    public void setupBuild(CurrentBuild build) {
        build.setConfiguration(this);
    }

    public void setJsonMapper(AnnotationStyle jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public void setJsonMapperConfiguration(Map<String, String> jsonMapperConfiguration) {
        this.jsonMapperConfiguration = jsonMapperConfiguration;
    }

    public String getSupportPackage() {
        if (this.supportPackage == null) {
            return this.resourcePackage;
        }
        return this.supportPackage;
    }

    public void setSupportPackage(String supportPackage) {
        this.supportPackage = supportPackage;
    }

    public String getModelPackage() {
        if (this.modelPackage == null) {
            return this.resourcePackage;
        }
        return this.modelPackage;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String[] getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setTypeConfiguration(String[] typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public static Configuration defaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setModelPackage("model");
        configuration.setResourcePackage("resource");
        configuration.setSupportPackage("support");
        configuration.setOutputDirectory(new File("."));
        configuration.setTypeConfiguration(new String[]{"jackson"});
        return configuration;
    }

    public List<TypeExtension> getTypeExtensions() {
        return this.typeExtensions;
    }

    public GenerationConfig createJsonSchemaGenerationConfig() {
        return new RamlToJaxRSGenerationConfig(this.jsonMapper, this.jsonMapperConfiguration);
    }

    public void defaultResourceCreationExtension(Class<GlobalResourceExtension> c) {
        this.defaultCreationExtension = c;
    }

    public void defaultResourceFinishExtension(Class<GlobalResourceExtension> c) {
        this.defaultFinishExtension = c;
    }

    public Class<GlobalResourceExtension> getDefaultCreationExtension() {
        return this.defaultCreationExtension;
    }

    public Class<GlobalResourceExtension> getDefaultFinishExtension() {
        return this.defaultFinishExtension;
    }
}

