/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsonschema2pojo.GenerationConfig;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.GFinder;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.GeneratorType;
import org.raml.jaxrs.generator.ResponseSupport;
import org.raml.jaxrs.generator.TypeFindingListener;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.CodeModelTypeGenerator;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.builders.extensions.types.GsonExtension;
import org.raml.jaxrs.generator.builders.extensions.types.JacksonExtensions;
import org.raml.jaxrs.generator.builders.extensions.types.JavadocTypeExtension;
import org.raml.jaxrs.generator.builders.extensions.types.JaxbTypeExtension;
import org.raml.jaxrs.generator.builders.extensions.types.Jsr303Extension;
import org.raml.jaxrs.generator.builders.extensions.types.TypeExtensionList;
import org.raml.jaxrs.generator.builders.resources.ResourceGenerator;
import org.raml.jaxrs.generator.extension.resources.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.ResourceClassExtension;
import org.raml.jaxrs.generator.extension.resources.ResourceMethodExtension;
import org.raml.jaxrs.generator.extension.resources.ResponseClassExtension;
import org.raml.jaxrs.generator.extension.resources.ResponseMethodExtension;
import org.raml.jaxrs.generator.extension.types.TypeExtension;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GMethod;
import org.raml.jaxrs.generator.v10.V10GResource;
import org.raml.jaxrs.generator.v10.V10GResponse;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.common.Annotable;

public class CurrentBuild {
    private final GFinder typeFinder;
    private final Api api;
    private final List<ResourceGenerator> resources = new ArrayList<ResourceGenerator>();
    private final Map<String, TypeGenerator> builtTypes = new HashMap<String, TypeGenerator>();
    private TypeExtensionList typeExtensionList = new TypeExtensionList();
    private Map<String, GeneratorType> foundTypes = new HashMap<String, GeneratorType>();
    private final List<JavaPoetTypeGenerator> supportGenerators = new ArrayList<JavaPoetTypeGenerator>();
    private Configuration configuration;

    public CurrentBuild(GFinder typeFinder, Api api) {
        this.typeFinder = typeFinder;
        this.api = api;
        this.configuration = Configuration.defaultConfiguration();
    }

    public Api getApi() {
        return this.api;
    }

    public String getResourcePackage() {
        return this.configuration.getResourcePackage();
    }

    public String getModelPackage() {
        return this.configuration.getModelPackage();
    }

    public String getSupportPackage() {
        return this.configuration.getSupportPackage();
    }

    public void generate(final File rootDirectory) throws IOException {
        if (this.resources.size() > 0) {
            ResponseSupport.buildSupportClasses(rootDirectory, this.getSupportPackage());
        }
        for (TypeGenerator typeGenerator : this.builtTypes.values()) {
            TypeGenerator<TypeSpec.Builder> b;
            if (typeGenerator instanceof JavaPoetTypeGenerator) {
                b = (JavaPoetTypeGenerator)typeGenerator;
                b.output(new CodeContainer<TypeSpec.Builder>(){

                    @Override
                    public void into(TypeSpec.Builder g) throws IOException {
                        JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getModelPackage(), (TypeSpec)g.build());
                        file.build().writeTo(rootDirectory);
                    }
                });
                continue;
            }
            if (!(typeGenerator instanceof CodeModelTypeGenerator)) continue;
            b = (CodeModelTypeGenerator)typeGenerator;
            b.output(new CodeContainer<JCodeModel>(){

                @Override
                public void into(JCodeModel g) throws IOException {
                    g.build(rootDirectory);
                }
            });
        }
        for (ResourceGenerator resourceGenerator : this.resources) {
            resourceGenerator.output(new CodeContainer<TypeSpec>(){

                @Override
                public void into(TypeSpec g) throws IOException {
                    JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getResourcePackage(), (TypeSpec)g);
                    file.build().writeTo(rootDirectory);
                }
            });
        }
        for (JavaPoetTypeGenerator javaPoetTypeGenerator : this.supportGenerators) {
            javaPoetTypeGenerator.output(new CodeContainer<TypeSpec.Builder>(){

                @Override
                public void into(TypeSpec.Builder g) throws IOException {
                    JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getSupportPackage(), (TypeSpec)g.build());
                    file.build().writeTo(rootDirectory);
                }
            });
        }
    }

    public TypeExtension withTypeListeners() {
        return this.typeExtensionList;
    }

    public void newGenerator(String ramlTypeName, TypeGenerator generator) {
        this.builtTypes.put(ramlTypeName, generator);
    }

    public void newSupportGenerator(JavaPoetTypeGenerator generator) {
        this.supportGenerators.add(generator);
    }

    public <T extends TypeGenerator> T getBuiltType(String ramlType) {
        TypeGenerator type = this.builtTypes.get(ramlType);
        if (type == null) {
            throw new GenerationException("no such type " + ramlType);
        }
        return (T)type;
    }

    public void newResource(ResourceGenerator rg) {
        this.resources.add(rg);
    }

    public void constructClasses() {
        TypeFindingListener listener = new TypeFindingListener(this.foundTypes);
        this.typeFinder.findTypes(listener);
        for (GeneratorType type : this.foundTypes.values()) {
            type.construct(this);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        for (String s : this.configuration.getTypeConfiguration()) {
            if (s.equals("jackson")) {
                this.typeExtensionList.addExtension(new JacksonExtensions());
            }
            if (s.equals("jaxb")) {
                this.typeExtensionList.addExtension(new JaxbTypeExtension());
            }
            if (s.equals("gson")) {
                this.typeExtensionList.addExtension(new GsonExtension());
            }
            if (s.equals("javadoc")) {
                this.typeExtensionList.addExtension(new JavadocTypeExtension());
            }
            if (!s.equals("jsr303")) continue;
            this.typeExtensionList.addExtension(new Jsr303Extension());
        }
    }

    public GenerationConfig getJsonMapperConfig() {
        return this.configuration.createJsonSchemaGenerationConfig();
    }

    private <T> T buildGlobalForCreate(T defaultValue) {
        if (this.configuration.getDefaultCreationExtension() != null) {
            try {
                return (T)this.configuration.getDefaultCreationExtension().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GenerationException(e);
            }
        }
        return defaultValue;
    }

    private GlobalResourceExtension buildGlobalForFinish() {
        if (this.configuration.getDefaultCreationExtension() != null) {
            try {
                return this.configuration.getDefaultFinishExtension().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GenerationException(e);
            }
        }
        return GlobalResourceExtension.NULL_EXTENSION;
    }

    public ResourceMethodExtension<GMethod> getResourceMethodExtension(Annotations<ResourceMethodExtension<GMethod>> onResourceMethodExtension, GMethod gMethod) {
        if (gMethod instanceof V10GMethod) {
            return onResourceMethodExtension.get((Annotable)this.getApi(), new Annotable[]{((V10GMethod)gMethod).implementation()});
        }
        return onResourceMethodExtension == Annotations.ON_METHOD_CREATION ? this.buildGlobalForCreate(GlobalResourceExtension.NULL_EXTENSION) : this.buildGlobalForFinish();
    }

    public ResourceClassExtension<GResource> getResourceClassExtension(ResourceClassExtension<GResource> defaultClass, Annotations<ResourceClassExtension<GResource>> onResourceClassCreation, GResource topResource) {
        if (topResource instanceof V10GResource) {
            return onResourceClassCreation.get(defaultClass, (Annotable)this.getApi(), new Annotable[]{((V10GResource)topResource).implementation()});
        }
        return onResourceClassCreation == Annotations.ON_RESOURCE_CLASS_CREATION ? this.buildGlobalForCreate(defaultClass) : this.buildGlobalForFinish();
    }

    public ResponseClassExtension<GMethod> getResponseClassExtension(Annotations<ResponseClassExtension<GMethod>> onResponseClassCreation, GMethod gMethod) {
        if (gMethod instanceof V10GMethod) {
            return onResponseClassCreation.get((Annotable)this.getApi(), new Annotable[]{((V10GMethod)gMethod).implementation()});
        }
        return onResponseClassCreation == Annotations.ON_RESPONSE_CLASS_CREATION ? this.buildGlobalForCreate(GlobalResourceExtension.NULL_EXTENSION) : this.buildGlobalForFinish();
    }

    public ResponseMethodExtension<GResponse> getResponseMethodExtension(Annotations<ResponseMethodExtension<GResponse>> onResponseMethodExtension, GResponse gResponse) {
        if (gResponse instanceof V10GResponse) {
            return onResponseMethodExtension.get((Annotable)this.getApi(), new Annotable[]{((V10GResponse)gResponse).implementation()});
        }
        return onResponseMethodExtension == Annotations.ON_RESPONSE_METHOD_CREATION ? this.buildGlobalForCreate(GlobalResourceExtension.NULL_EXTENSION) : this.buildGlobalForFinish();
    }
}

