/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.squareup.javapoet.ClassName;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.util.Map;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.JsonSchemaTypeGenerator;
import org.raml.jaxrs.generator.XmlSchemaTypeGenerator;
import org.raml.jaxrs.generator.builders.JAXBHelper;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.ramltypes.GType;

public class SchemaTypeFactory {
    public static TypeGenerator createXmlType(CurrentBuild currentBuild, GType type) {
        File schemaFile = null;
        try {
            schemaFile = JAXBHelper.saveSchema(type.schema());
            JCodeModel codeModel = new JCodeModel();
            Map<String, JClass> generated = JAXBHelper.generateClassesFromXmlSchemas(currentBuild.getModelPackage(), schemaFile, codeModel);
            XmlSchemaTypeGenerator gen = new XmlSchemaTypeGenerator(codeModel, currentBuild.getModelPackage(), generated.values().iterator().next());
            type.setJavaType(gen.getGeneratedJavaType());
            currentBuild.newGenerator(type.name(), gen);
            XmlSchemaTypeGenerator xmlSchemaTypeGenerator = gen;
            return xmlSchemaTypeGenerator;
        }
        catch (Exception e) {
            throw new GenerationException(e);
        }
        finally {
            if (schemaFile != null) {
                schemaFile.delete();
            }
        }
    }

    public static TypeGenerator createJsonType(CurrentBuild currentBuild, GType type) {
        JsonSchemaTypeGenerator gen = new JsonSchemaTypeGenerator(currentBuild, currentBuild.getModelPackage(), (ClassName)type.defaultJavaTypeName(currentBuild.getModelPackage()), type.schema());
        type.setJavaType(gen.getGeneratedJavaType());
        currentBuild.newGenerator(type.name(), gen);
        return gen;
    }
}

