/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.extension.Context;

public class ContextImpl
implements Context {
    private final CurrentBuild build;

    public ContextImpl(CurrentBuild build) {
        this.build = build;
    }

    @Override
    public String getResourcePackage() {
        return this.build.getResourcePackage();
    }

    @Override
    public String getModelPackage() {
        return this.build.getModelPackage();
    }

    @Override
    public String getSupportPackage() {
        return this.build.getSupportPackage();
    }

    @Override
    public MethodSpec.Builder rename(MethodSpec.Builder builder, String name) {
        MethodSpec method = builder.build();
        if (method.isConstructor()) {
            throw new GenerationException("Can't rename a constructor: " + name);
        }
        MethodSpec.Builder newBuilder = MethodSpec.methodBuilder((String)name);
        for (AnnotationSpec annotation : method.annotations) {
            newBuilder.addAnnotation(annotation);
        }
        for (Modifier modifier : method.modifiers) {
            newBuilder.addModifiers(new Modifier[]{modifier});
        }
        for (TypeVariableName typeVariable : method.typeVariables) {
            newBuilder.addTypeVariable(typeVariable);
        }
        for (ParameterSpec parameter : method.parameters) {
            newBuilder.addParameter(parameter);
        }
        for (TypeName exception : method.exceptions) {
            newBuilder.addException(exception);
        }
        if (method.code != null) {
            newBuilder.addCode(method.code);
        }
        if (method.defaultValue != null) {
            newBuilder.defaultValue(method.defaultValue);
        }
        if (method.returnType != null) {
            newBuilder.returns(method.returnType);
        }
        if (method.javadoc != null) {
            newBuilder.addJavadoc("$L", new Object[]{method.javadoc});
        }
        newBuilder.varargs(method.varargs);
        return newBuilder;
    }

    @Override
    public TypeSpec.Builder rename(TypeSpec.Builder builder, String name) {
        TypeSpec.Builder newType;
        TypeSpec type = builder.build();
        switch (type.kind) {
            case ANNOTATION: {
                newType = TypeSpec.annotationBuilder((String)name);
                break;
            }
            case ENUM: {
                newType = TypeSpec.enumBuilder((String)name);
                break;
            }
            case INTERFACE: {
                newType = TypeSpec.interfaceBuilder((String)name);
                break;
            }
            case CLASS: {
                newType = TypeSpec.classBuilder((String)name);
                break;
            }
            default: {
                throw new GenerationException("this can't happen...");
            }
        }
        for (AnnotationSpec annotationSpec : type.annotations) {
            newType.addAnnotation(annotationSpec);
        }
        for (Modifier modifier : type.modifiers) {
            newType.addModifiers(new Modifier[]{modifier});
        }
        for (TypeVariableName typeVariableName : type.typeVariables) {
            newType.addTypeVariable(typeVariableName);
        }
        for (TypeName typeName : type.superinterfaces) {
            newType.addSuperinterface(typeName);
        }
        for (FieldSpec fieldSpec : type.fieldSpecs) {
            newType.addField(fieldSpec);
        }
        for (MethodSpec methodSpec : type.methodSpecs) {
            newType.addMethod(methodSpec);
        }
        for (TypeSpec typeSpec : type.typeSpecs) {
            newType.addType(typeSpec);
        }
        for (Map.Entry entry : type.enumConstants.entrySet()) {
            newType.addEnumConstant((String)entry.getKey(), (TypeSpec)entry.getValue());
        }
        if (type.javadoc != null) {
            newType.addJavadoc("$L", new Object[]{type.javadoc});
        }
        if (type.superclass != null) {
            newType.superclass(type.superclass);
        }
        if (type.staticBlock != null && !type.staticBlock.isEmpty()) {
            newType.addStaticBlock(type.staticBlock);
        }
        if (type.initializerBlock != null && !type.initializerBlock.isEmpty()) {
            newType.addInitializerBlock(type.initializerBlock);
        }
        return newType;
    }
}

