/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.extensions.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeSpec;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.builders.extensions.types.TypeExtensionHelper;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;

public class JacksonDiscriminatorInheritanceTypeExtension
extends TypeExtensionHelper {
    @Override
    public void onTypeDeclaration(CurrentBuild currentBuild, TypeSpec.Builder typeSpec, V10GType type) {
        ObjectTypeDeclaration otr = (ObjectTypeDeclaration)type.implementation();
        if (otr.discriminator() != null && type.childClasses(type.name()).size() > 0) {
            typeSpec.addAnnotation(AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$T.Id.NAME", new Object[]{JsonTypeInfo.class}).addMember("include", "$T.As.PROPERTY", new Object[]{JsonTypeInfo.class}).addMember("property", "$S", new Object[]{otr.discriminator()}).build());
            AnnotationSpec.Builder subTypes = AnnotationSpec.builder(JsonSubTypes.class);
            for (V10GType gType : type.childClasses(type.name())) {
                subTypes.addMember("value", "$L", new Object[]{AnnotationSpec.builder(JsonSubTypes.Type.class).addMember("value", "$L", new Object[]{gType.defaultJavaTypeName(currentBuild.getModelPackage()) + ".class"}).build()});
            }
            typeSpec.addAnnotation(subTypes.build());
        }
        if (otr.discriminatorValue() != null) {
            typeSpec.addAnnotation(AnnotationSpec.builder(JsonTypeName.class).addMember("value", "$S", new Object[]{otr.discriminatorValue()}).build());
        }
        if (type.childClasses(type.name()).size() == 0 && !Annotations.ABSTRACT.get(type).booleanValue()) {
            typeSpec.addAnnotation(AnnotationSpec.builder(JsonDeserialize.class).addMember("as", "$L.class", new Object[]{type.javaImplementationName(currentBuild.getModelPackage())}).build());
        }
    }
}

