/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders.resources;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.ws.rs.Consumes;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.HTTPMethods;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.ResourceUtils;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGeneratorBase;
import org.raml.jaxrs.generator.builders.extensions.ContextImpl;
import org.raml.jaxrs.generator.builders.resources.ResourceGenerator;
import org.raml.jaxrs.generator.extension.Context;
import org.raml.jaxrs.generator.extension.resources.ResourceClassExtension;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GRequest;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.ramltypes.GResponseType;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.TypeUtils;

public class ResourceBuilder
implements ResourceGenerator {
    private final CurrentBuild build;
    private final GResource topResource;
    private final String name;
    private final String uri;

    public ResourceBuilder(CurrentBuild build, GResource resource, String name, String uri) {
        this.build = build;
        this.topResource = resource;
        this.name = name;
        this.uri = uri;
    }

    @Override
    public void output(CodeContainer<TypeSpec> container) throws IOException {
        TypeSpec.Builder typeSpec = this.build.getResourceClassExtension(new DefaultResourceClassCreator(), Annotations.ON_RESOURCE_CLASS_CREATION, this.topResource).onResource(new ContextImpl(this.build), this.topResource, null);
        if (typeSpec != null) {
            container.into(typeSpec.build());
        }
    }

    private void recurse(TypeSpec.Builder typeSpec, GResource parentResource) {
        for (GResource resource : parentResource.resources()) {
            this.buildResource(typeSpec, resource);
            this.recurse(typeSpec, resource);
        }
    }

    private void buildResource(TypeSpec.Builder typeSpec, GResource currentResource) {
        ArrayListMultimap incomingBodies = ArrayListMultimap.create();
        ArrayListMultimap responses = ArrayListMultimap.create();
        ResourceUtils.fillInBodiesAndResponses(currentResource, (Multimap<GMethod, GRequest>)incomingBodies, (Multimap<GMethod, GResponse>)responses);
        Map<String, TypeSpec.Builder> responseSpecs = this.createResponseClass(typeSpec, (Multimap<GMethod, GRequest>)incomingBodies, (Multimap<GMethod, GResponse>)responses);
        for (GMethod gMethod : currentResource.methods()) {
            String methodName = Names.resourceMethodName(gMethod.resource(), gMethod);
            Set<String> mediaTypesForMethod = this.fetchAllMediaTypesForMethodResponses(gMethod);
            if (gMethod.body().size() == 0) {
                this.createMethodWithoutBody(typeSpec, gMethod, mediaTypesForMethod, methodName, responseSpecs);
                continue;
            }
            Multimap<String, String> ramlTypeToMediaType = this.accumulateMediaTypesPerType((Multimap<GMethod, GRequest>)incomingBodies, gMethod);
            for (GRequest gRequest : gMethod.body()) {
                if (!ramlTypeToMediaType.containsKey((Object)gRequest.type().name())) continue;
                this.createMethodWithBody(typeSpec, gMethod, ramlTypeToMediaType, methodName, gRequest, responseSpecs);
                ramlTypeToMediaType.removeAll((Object)gRequest.type().name());
            }
        }
    }

    private Multimap<String, String> accumulateMediaTypesPerType(Multimap<GMethod, GRequest> incomingBodies, GMethod gMethod) {
        ArrayListMultimap ramlTypeToMediaType = ArrayListMultimap.create();
        for (GRequest request : incomingBodies.get((Object)gMethod)) {
            if (request == null) continue;
            ramlTypeToMediaType.put((Object)request.type().name(), (Object)request.mediaType());
        }
        return ramlTypeToMediaType;
    }

    private void createMethodWithoutBody(TypeSpec.Builder typeSpec, GMethod gMethod, Set<String> mediaTypesForMethod, String methodName, Map<String, TypeSpec.Builder> responseSpecs) {
        MethodSpec.Builder methodSpec = this.createMethodBuilder(gMethod, methodName, mediaTypesForMethod, responseSpecs);
        methodSpec = this.build.getResourceMethodExtension(Annotations.ON_METHOD_FINISH, gMethod).onMethod(new ContextImpl(this.build), gMethod, methodSpec);
        if (methodSpec != null) {
            typeSpec.addMethod(methodSpec.build());
        }
    }

    private void createMethodWithBody(TypeSpec.Builder typeSpec, GMethod gMethod, Multimap<String, String> ramlTypeToMediaType, String methodName, GRequest gRequest, Map<String, TypeSpec.Builder> responseSpec) {
        MethodSpec.Builder methodSpec = this.createMethodBuilder(gMethod, methodName, new HashSet<String>(), responseSpec);
        TypeName name = gRequest.type().defaultJavaTypeName(this.build.getModelPackage());
        methodSpec.addParameter(ParameterSpec.builder((TypeName)name, (String)"entity", (Modifier[])new Modifier[0]).build());
        this.handleMethodConsumer(methodSpec, ramlTypeToMediaType, gRequest.type());
        methodSpec = this.build.getResourceMethodExtension(Annotations.ON_METHOD_FINISH, gMethod).onMethod(new ContextImpl(this.build), gMethod, methodSpec);
        if (methodSpec != null) {
            typeSpec.addMethod(methodSpec.build());
        }
    }

    private Set<String> fetchAllMediaTypesForMethodResponses(GMethod gMethod) {
        HashSet<String> mediaTypes = new HashSet<String>();
        for (GResponse gResponse : gMethod.responses()) {
            mediaTypes.addAll(Lists.transform(gResponse.body(), (Function)new Function<GResponseType, String>(){

                @Nullable
                public String apply(@Nullable GResponseType input) {
                    return input.mediaType();
                }
            }));
        }
        return mediaTypes;
    }

    private Map<String, TypeSpec.Builder> createResponseClass(TypeSpec.Builder typeSpec, Multimap<GMethod, GRequest> bodies, Multimap<GMethod, GResponse> responses) {
        HashMap<String, TypeSpec.Builder> map = new HashMap<String, TypeSpec.Builder>();
        HashSet allMethods = new HashSet();
        allMethods.addAll(bodies.keySet());
        allMethods.addAll(responses.keySet());
        for (GMethod gMethod : allMethods) {
            if (gMethod.responses().size() == 0) continue;
            String defaultName = Names.responseClassName(gMethod.resource(), gMethod);
            TypeSpec.Builder responseClass = TypeSpec.classBuilder((String)defaultName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((TypeName)ClassName.get((String)this.build.getSupportPackage(), (String)"ResponseDelegate", (String[])new String[0])).addMethod(MethodSpec.constructorBuilder().addParameter(Response.class, "Response", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("super(Response);\n", new Object[0]).build());
            responseClass = this.build.getResponseClassExtension(Annotations.ON_RESPONSE_CLASS_CREATION, gMethod).onMethod(new ContextImpl(this.build), gMethod, responseClass);
            if (responseClass == null) {
                map.put(defaultName, null);
                continue;
            }
            TypeSpec currentClass = responseClass.build();
            for (GResponse gResponse : responses.get((Object)gMethod)) {
                if (gResponse == null) continue;
                if (gResponse.body().size() == 0) {
                    String httpCode = gResponse.code();
                    MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("respond" + httpCode));
                    builder.addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addStatement("Response.ResponseBuilder responseBuilder = Response.status(" + httpCode + ")", new Object[0]).addStatement("return new $N(responseBuilder.build())", new Object[]{currentClass}).returns((TypeName)TypeVariableName.get((String)currentClass.name)).build();
                    builder = this.build.getResponseMethodExtension(Annotations.ON_RESPONSE_METHOD_CREATION, gResponse).onMethod(new ContextImpl(this.build), gResponse, builder);
                    if (builder == null || (builder = this.build.getResponseMethodExtension(Annotations.ON_RESPONSE_METHOD_FINISH, gResponse).onMethod(new ContextImpl(this.build), gResponse, builder)) == null) continue;
                    responseClass.addMethod(builder.build());
                    continue;
                }
                for (GResponseType typeDeclaration : gResponse.body()) {
                    String httpCode = gResponse.code();
                    MethodSpec.Builder builder = MethodSpec.methodBuilder((String)Names.methodName("respond", httpCode, "With", typeDeclaration.mediaType())).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC});
                    builder = this.build.getResponseMethodExtension(Annotations.ON_RESPONSE_METHOD_CREATION, gResponse).onMethod(new ContextImpl(this.build), gResponse, builder);
                    if (builder == null) continue;
                    builder.addStatement("Response.ResponseBuilder responseBuilder = Response.status(" + httpCode + ").header(\"Content-Type\", \"" + typeDeclaration.mediaType() + "\")", new Object[0]).addStatement("responseBuilder.entity(entity)", new Object[0]).addStatement("return new $N(responseBuilder.build())", new Object[]{currentClass}).returns((TypeName)TypeVariableName.get((String)currentClass.name)).build();
                    TypeName typeName = typeDeclaration.type().defaultJavaTypeName(this.build.getModelPackage());
                    if (typeName == null) {
                        throw new GenerationException(typeDeclaration + " was not seen before");
                    }
                    builder.addParameter(ParameterSpec.builder((TypeName)typeName, (String)"entity", (Modifier[])new Modifier[0]).build());
                    builder = this.build.getResponseMethodExtension(Annotations.ON_RESPONSE_METHOD_FINISH, gResponse).onMethod(new ContextImpl(this.build), gResponse, builder);
                    if (builder == null) continue;
                    responseClass.addMethod(builder.build());
                }
            }
            responseClass = this.build.getResponseClassExtension(Annotations.ON_RESPONSE_CLASS_FINISH, gMethod).onMethod(new ContextImpl(this.build), gMethod, responseClass);
            if (responseClass == null) {
                map.put(defaultName, null);
                continue;
            }
            map.put(defaultName, responseClass);
            typeSpec.addType(responseClass.build());
        }
        return map;
    }

    private MethodSpec.Builder createMethodBuilder(GMethod gMethod, String methodName, Set<String> mediaTypesForMethod, Map<String, TypeSpec.Builder> responseSpec) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
        methodSpec = this.build.getResourceMethodExtension(Annotations.ON_METHOD_CREATION, gMethod).onMethod(new ContextImpl(this.build), gMethod, methodSpec);
        for (GParameter typeDeclaration : gMethod.resource().uriParameters()) {
            if (TypeUtils.isComposite(typeDeclaration)) {
                throw new GenerationException("uri parameter is composite: " + typeDeclaration);
            }
            methodSpec.addParameter(ParameterSpec.builder((TypeName)typeDeclaration.type().defaultJavaTypeName(this.build.getModelPackage()), (String)Names.methodName(typeDeclaration.name()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(PathParam.class).addMember("value", "$S", new Object[]{typeDeclaration.name()}).build()).build());
        }
        for (GParameter typeDeclaration : gMethod.queryParameters()) {
            if (TypeUtils.isComposite(typeDeclaration)) {
                throw new GenerationException("query parameter is composite: " + typeDeclaration);
            }
            methodSpec.addParameter(ParameterSpec.builder((TypeName)typeDeclaration.type().defaultJavaTypeName(this.build.getModelPackage()), (String)Names.methodName(typeDeclaration.name()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(QueryParam.class).addMember("value", "$S", new Object[]{typeDeclaration.name()}).build()).build());
        }
        this.buildNewWebMethod(gMethod, methodSpec);
        if (gMethod.resource().parentResource() != null) {
            methodSpec.addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{gMethod.resource().resourcePath()}).build());
        }
        if (gMethod.responses().size() != 0) {
            TypeSpec.Builder responseSpecForMethod = responseSpec.get(Names.responseClassName(gMethod.resource(), gMethod));
            if (responseSpecForMethod == null) {
                methodSpec.returns((TypeName)ClassName.get(Response.class));
            } else {
                methodSpec.returns((TypeName)ClassName.get((String)"", (String)responseSpecForMethod.build().name, (String[])new String[0]));
            }
        } else {
            methodSpec.returns(ClassName.VOID);
        }
        if (mediaTypesForMethod.size() > 0) {
            AnnotationSpec.Builder ann = this.buildAnnotation(mediaTypesForMethod, Produces.class);
            methodSpec.addAnnotation(ann.build());
        }
        return methodSpec;
    }

    private void buildNewWebMethod(GMethod gMethod, MethodSpec.Builder methodSpec) {
        Class<? extends Annotation> type = HTTPMethods.methodNameToAnnotation(gMethod.method());
        if (type == null) {
            String name = gMethod.method().toUpperCase();
            ClassName className = ClassName.get((String)this.build.getSupportPackage(), (String)name, (String[])new String[0]);
            final TypeSpec.Builder builder = TypeSpec.annotationBuilder((ClassName)className);
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Target.class).addMember("value", "{$T.$L}", new Object[]{ElementType.class, "METHOD"}).build()).addAnnotation(AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, "RUNTIME"}).build()).addAnnotation(AnnotationSpec.builder(HttpMethod.class).addMember("value", "$S", new Object[]{name}).build());
            this.build.newSupportGenerator(new JavaPoetTypeGeneratorBase((TypeName)className){

                @Override
                public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
                    rootDirectory.into(builder);
                }
            });
            methodSpec.addAnnotation(AnnotationSpec.builder((ClassName)className).build());
        } else {
            methodSpec.addAnnotation(AnnotationSpec.builder(type).build());
        }
    }

    private void handleMethodConsumer(MethodSpec.Builder methodSpec, Multimap<String, String> ramlTypeToMediaType, GType typeDeclaration) {
        Collection mediaTypes = ramlTypeToMediaType.get((Object)typeDeclaration.type());
        AnnotationSpec.Builder ann = this.buildAnnotation(mediaTypes, Consumes.class);
        methodSpec.addAnnotation(ann.build());
    }

    private AnnotationSpec.Builder buildAnnotation(Collection<String> mediaTypes, Class<? extends Annotation> type) {
        AnnotationSpec.Builder ann = AnnotationSpec.builder(type);
        for (String mediaType : mediaTypes) {
            ann.addMember("value", "$S", new Object[]{mediaType});
        }
        return ann;
    }

    private class DefaultResourceClassCreator
    implements ResourceClassExtension<GResource> {
        private DefaultResourceClassCreator() {
        }

        @Override
        public TypeSpec.Builder onResource(Context context, GResource resource, TypeSpec.Builder nullSpec) {
            TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((String)Names.typeName(ResourceBuilder.this.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{ResourceBuilder.this.uri}).build());
            ResourceBuilder.this.buildResource(typeSpec, ResourceBuilder.this.topResource);
            ResourceBuilder.this.recurse(typeSpec, ResourceBuilder.this.topResource);
            typeSpec = ResourceBuilder.this.build.getResourceClassExtension(NULL_EXTENSION, Annotations.ON_RESOURCE_CLASS_FINISH, ResourceBuilder.this.topResource).onResource(new ContextImpl(ResourceBuilder.this.build), ResourceBuilder.this.topResource, typeSpec);
            return typeSpec;
        }
    }
}

