/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v08;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.GAbstractionFactory;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.v08.V08GParameter;
import org.raml.jaxrs.generator.v08.V08Method;
import org.raml.jaxrs.generator.v08.V08TypeRegistry;
import org.raml.v2.api.model.v08.methods.Method;
import org.raml.v2.api.model.v08.parameters.Parameter;
import org.raml.v2.api.model.v08.resources.Resource;

public class V08GResource
implements GResource {
    private final GAbstractionFactory factory;
    private final GResource parent;
    private final Resource resource;
    private final V08TypeRegistry registry;
    private final List<GResource> subResources;
    private final List<GParameter> uriParameters;
    private final List<GMethod> methods;

    public V08GResource(GAbstractionFactory factory, Resource resource, Set<String> globalSchemas, V08TypeRegistry registry) {
        this(factory, null, resource, globalSchemas, registry);
    }

    public V08GResource(final GAbstractionFactory factory, GResource parent, Resource resource, final Set<String> globalSchemas, final V08TypeRegistry registry) {
        this.factory = factory;
        this.parent = parent;
        this.resource = resource;
        this.registry = registry;
        this.subResources = Lists.transform((List)resource.resources(), (Function)new Function<Resource, GResource>(){

            @Nullable
            public GResource apply(@Nullable Resource input) {
                return factory.newResource(globalSchemas, registry, V08GResource.this, input);
            }
        });
        this.uriParameters = Lists.transform((List)resource.uriParameters(), (Function)new Function<Parameter, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable Parameter input) {
                return new V08GParameter(input);
            }
        });
        this.methods = Lists.transform((List)resource.methods(), (Function)new Function<Method, GMethod>(){

            @Nullable
            public GMethod apply(@Nullable Method input) {
                return new V08Method(V08GResource.this, input, globalSchemas, registry);
            }
        });
    }

    public Resource implementation() {
        return this.resource;
    }

    @Override
    public List<GResource> resources() {
        return this.subResources;
    }

    @Override
    public List<GMethod> methods() {
        return this.methods;
    }

    @Override
    public List<GParameter> uriParameters() {
        return this.uriParameters;
    }

    @Override
    public String resourcePath() {
        return this.resource.resourcePath();
    }

    @Override
    public GResource parentResource() {
        return this.parent;
    }
}

