/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.AbstractTypeGenerator;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class EnumerationGenerator
extends AbstractTypeGenerator<TypeSpec.Builder>
implements JavaPoetTypeGenerator {
    private final CurrentBuild build;
    private final ClassName javaName;
    private final List<String> values;
    private TypeDeclaration typeDeclaration;

    public EnumerationGenerator(CurrentBuild build, TypeDeclaration typeDeclaration, ClassName javaName, List<String> values) {
        this.build = build;
        this.typeDeclaration = typeDeclaration;
        this.javaName = javaName;
        this.values = values;
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory, TypeGenerator.TYPE type) throws IOException {
        FieldSpec.Builder field = FieldSpec.builder((TypeName)ClassName.get(String.class), (String)"name", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        this.build.withTypeListeners().onEnumField(this.build, field, this.typeDeclaration);
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((ClassName)this.javaName).addField(field.build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ClassName.get(String.class), "name", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"name", "name"}).build());
        this.build.withTypeListeners().onEnumerationClass(this.build, enumBuilder, this.typeDeclaration);
        for (String value : this.values) {
            TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"$S", (Object[])new Object[]{value});
            this.build.withTypeListeners().onEnumConstant(this.build, builder, this.typeDeclaration, value);
            enumBuilder.addEnumConstant(Names.constantName(value), builder.build());
        }
        rootDirectory.into(enumBuilder);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.javaName;
    }
}

