/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.AbstractTypeGenerator;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.v10.PropertyInfo;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RamlTypeGeneratorImplementation
extends AbstractTypeGenerator<TypeSpec.Builder>
implements JavaPoetTypeGenerator {
    private final CurrentBuild build;
    private final ClassName className;
    private final ClassName parentClassName;
    private Map<String, JavaPoetTypeGenerator> internalTypes = new HashMap<String, JavaPoetTypeGenerator>();
    private Map<String, PropertyInfo> propertyInfos = new HashMap<String, PropertyInfo>();
    private final V10GType typeDeclaration;

    public RamlTypeGeneratorImplementation(CurrentBuild build, ClassName className, ClassName parentClassName, List<PropertyInfo> properties, Map<String, JavaPoetTypeGenerator> internalTypes, V10GType typeDeclaration) {
        this.build = build;
        this.className = className;
        this.parentClassName = parentClassName;
        this.internalTypes = internalTypes;
        this.typeDeclaration = typeDeclaration;
        for (PropertyInfo property : properties) {
            this.propertyInfos.put(property.getName(), property);
        }
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> container, TypeGenerator.TYPE type) throws IOException {
        ObjectTypeDeclaration object = (ObjectTypeDeclaration)this.typeDeclaration.implementation();
        final TypeSpec.Builder typeSpec = TypeSpec.classBuilder((ClassName)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.build.withTypeListeners().onTypeImplementation(this.build, typeSpec, this.typeDeclaration.implementation());
        if (this.parentClassName != null) {
            typeSpec.addSuperinterface((TypeName)this.parentClassName);
        }
        for (TypeGenerator typeGenerator : this.internalTypes.values()) {
            typeGenerator.output(new CodeContainer<TypeSpec.Builder>(){

                @Override
                public void into(TypeSpec.Builder g) throws IOException {
                    g.addModifiers(new Modifier[]{Modifier.STATIC});
                    typeSpec.addType(g.build());
                }
            }, type);
        }
        for (PropertyInfo propertyInfo : this.propertyInfos.values()) {
            FieldSpec.Builder fieldSpec = FieldSpec.builder((TypeName)propertyInfo.resolve(this.build), (String)Names.variableName(propertyInfo.getName()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
            this.build.withTypeListeners().onFieldImplementation(this.build, fieldSpec, (TypeDeclaration)propertyInfo.getType().implementation());
            if (propertyInfo.getName().equals(object.discriminator())) {
                fieldSpec.initializer("$S", new Object[]{object.discriminatorValue()});
            }
            typeSpec.addField(fieldSpec.build());
            MethodSpec.Builder getSpec = MethodSpec.methodBuilder((String)("get" + Names.typeName(propertyInfo.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this." + Names.variableName(propertyInfo.getName()), new Object[0]);
            getSpec.returns(propertyInfo.resolve(this.build));
            this.build.withTypeListeners().onGetterMethodImplementation(this.build, getSpec, (TypeDeclaration)propertyInfo.getType().implementation());
            typeSpec.addMethod(getSpec.build());
            if (propertyInfo.getName().equals(object.discriminator())) continue;
            MethodSpec.Builder setSpec = MethodSpec.methodBuilder((String)("set" + Names.typeName(propertyInfo.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this." + Names.variableName(propertyInfo.getName()) + " = " + Names.variableName(propertyInfo.getName()), new Object[0]);
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)propertyInfo.resolve(this.build), (String)Names.variableName(propertyInfo.getName()), (Modifier[])new Modifier[0]);
            this.build.withTypeListeners().onSetterMethodImplementation(this.build, setSpec, parameterSpec, (TypeDeclaration)propertyInfo.getType().implementation());
            setSpec.addParameter(parameterSpec.build());
            typeSpec.addMethod(setSpec.build());
        }
        container.into(typeSpec);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.className;
    }
}

