/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.AbstractTypeGenerator;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.ramltypes.GType;
import org.raml.jaxrs.generator.v10.PropertyInfo;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RamlTypeGeneratorInterface
extends AbstractTypeGenerator<TypeSpec.Builder>
implements JavaPoetTypeGenerator {
    private final CurrentBuild build;
    private final List<V10GType> parentTypes;
    private final ClassName interf;
    private Map<String, PropertyInfo> propertyInfos = new HashMap<String, PropertyInfo>();
    private Map<String, JavaPoetTypeGenerator> internalTypes = new HashMap<String, JavaPoetTypeGenerator>();
    private final V10GType typeDeclaration;

    public RamlTypeGeneratorInterface(CurrentBuild currentBuild, ClassName interf, List<V10GType> parentTypes, List<PropertyInfo> properties, Map<String, JavaPoetTypeGenerator> internalTypes, V10GType typeDeclaration) {
        this.build = currentBuild;
        this.interf = interf;
        this.parentTypes = parentTypes;
        this.internalTypes = internalTypes;
        this.typeDeclaration = typeDeclaration;
        for (PropertyInfo property : properties) {
            this.propertyInfos.put(property.getName(), property);
        }
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> into, TypeGenerator.TYPE type) throws IOException {
        ObjectTypeDeclaration object = (ObjectTypeDeclaration)this.typeDeclaration.implementation();
        final TypeSpec.Builder typeSpec = TypeSpec.interfaceBuilder((ClassName)this.interf).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.build.withTypeListeners().onTypeDeclaration(this.build, typeSpec, this.typeDeclaration);
        for (JavaPoetTypeGenerator javaPoetTypeGenerator : this.internalTypes.values()) {
            javaPoetTypeGenerator.output(new CodeContainer<TypeSpec.Builder>(){

                @Override
                public void into(TypeSpec.Builder g) throws IOException {
                    g.addModifiers(new Modifier[]{Modifier.STATIC});
                    typeSpec.addType(g.build());
                }
            }, type);
        }
        for (GType gType : this.parentTypes) {
            if (gType.name().equals("object")) continue;
            typeSpec.addSuperinterface(gType.defaultJavaTypeName(this.build.getModelPackage()));
        }
        for (PropertyInfo propertyInfo : this.propertyInfos.values()) {
            MethodSpec.Builder getSpec = MethodSpec.methodBuilder((String)Names.methodName("get", propertyInfo.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            getSpec.returns(propertyInfo.resolve(this.build));
            this.build.withTypeListeners().onGetterMethodDeclaration(this.build, getSpec, (TypeDeclaration)propertyInfo.getType().implementation());
            typeSpec.addMethod(getSpec.build());
            if (propertyInfo.getName().equals(object.discriminator())) continue;
            MethodSpec.Builder setSpec = MethodSpec.methodBuilder((String)Names.methodName("set", propertyInfo.getName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)propertyInfo.resolve(this.build), (String)Names.variableName(propertyInfo.getName()), (Modifier[])new Modifier[0]);
            this.build.withTypeListeners().onSetterMethodDeclaration(this.build, setSpec, parameterSpec, (TypeDeclaration)propertyInfo.getType().implementation());
            setSpec.addParameter(parameterSpec.build());
            typeSpec.addMethod(setSpec.build());
        }
        into.into(typeSpec);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.interf;
    }
}

