/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.Names;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class UnionTypeGenerator
implements JavaPoetTypeGenerator {
    private final V10TypeRegistry registry;
    private final V10GType v10GType;
    private final ClassName javaName;
    private final CurrentBuild currentBuild;

    public UnionTypeGenerator(V10TypeRegistry registry, V10GType v10GType, ClassName javaName, CurrentBuild currentBuild) {
        this.registry = registry;
        this.v10GType = v10GType;
        this.javaName = javaName;
        this.currentBuild = currentBuild;
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory) throws IOException {
        UnionTypeDeclaration union = (UnionTypeDeclaration)this.v10GType.implementation();
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.javaName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (TypeDeclaration typeDeclaration : union.of()) {
            V10GType type = this.registry.fetchType(typeDeclaration);
            TypeName typeName = type.defaultJavaTypeName(this.currentBuild.getModelPackage());
            String fieldName = Names.methodName(typeDeclaration.name());
            builder.addField(FieldSpec.builder((TypeName)typeName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build()).addField(FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)Names.variableName("is", typeDeclaration.name()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.constructorBuilder().addParameter(ParameterSpec.builder((TypeName)typeName, (String)fieldName, (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.$L = $L", new Object[]{fieldName, fieldName}).addStatement("this.is$L = true", new Object[]{typeDeclaration.name()}).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("get", typeDeclaration.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(typeName).addStatement("if ( is$L == false) throw new $T(\"fetching wrong type out of the union: $T\")", new Object[]{typeDeclaration.name(), IllegalStateException.class, typeName}).addStatement("return $L", new Object[]{fieldName}).build()).addMethod(MethodSpec.methodBuilder((String)Names.methodName("is", typeDeclaration.name())).addStatement("return " + Names.variableName("is", typeDeclaration.name()), new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).build());
        }
        this.currentBuild.withTypeListeners().onUnionType(this.currentBuild, builder, this.v10GType);
        rootDirectory.into(builder);
    }

    @Override
    public void output(CodeContainer<TypeSpec.Builder> rootDirectory, TypeGenerator.TYPE type) throws IOException {
        this.output(rootDirectory);
    }

    @Override
    public TypeName getGeneratedJavaType() {
        return this.javaName;
    }
}

