/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.GAbstractionFactory;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GParameter;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.v10.V10GMethod;
import org.raml.jaxrs.generator.v10.V10PGParameter;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class V10GResource
implements GResource {
    private final GAbstractionFactory factory;
    private final GResource parent;
    private final Resource resource;
    private final List<GResource> subResources;
    private final List<GParameter> uriParameters;
    private final List<GMethod> methods;

    public V10GResource(V10TypeRegistry registry, GAbstractionFactory factory, Resource resource) {
        this(registry, factory, null, resource);
    }

    public V10GResource(final V10TypeRegistry registry, final GAbstractionFactory factory, GResource parent, Resource resource) {
        this.factory = factory;
        this.parent = parent;
        this.resource = resource;
        this.subResources = Lists.transform((List)resource.resources(), (Function)new Function<Resource, GResource>(){

            @Nullable
            public GResource apply(@Nullable Resource input) {
                return factory.newResource(registry, V10GResource.this, input);
            }
        });
        this.uriParameters = Lists.transform((List)resource.uriParameters(), (Function)new Function<TypeDeclaration, GParameter>(){

            @Nullable
            public GParameter apply(@Nullable TypeDeclaration input) {
                return new V10PGParameter(registry, input);
            }
        });
        this.methods = Lists.transform((List)resource.methods(), (Function)new Function<Method, GMethod>(){

            @Nullable
            public GMethod apply(@Nullable Method input) {
                return new V10GMethod(registry, V10GResource.this, input);
            }
        });
    }

    @Override
    public List<GResource> resources() {
        return this.subResources;
    }

    @Override
    public List<GMethod> methods() {
        return this.methods;
    }

    @Override
    public List<GParameter> uriParameters() {
        return this.uriParameters;
    }

    @Override
    public String resourcePath() {
        return this.resource.resourcePath();
    }

    @Override
    public GResource parentResource() {
        return this.parent;
    }

    public Resource implementation() {
        return this.resource;
    }
}

