/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.types;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GObjectType;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GProperty;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.jaxrs.generator.v10.types.V10GTypeHelper;
import org.raml.jaxrs.generator.v10.types.V10TypeFactory;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class V10GTypeObject
extends V10GTypeHelper {
    private final V10TypeRegistry registry;
    private final TypeDeclaration typeDeclaration;
    private final String name;
    private final String defaultJavatypeName;
    private final boolean inline;
    private final List<V10GProperty> properties;
    private final List<V10GType> parentTypes;

    V10GTypeObject(V10TypeRegistry registry, TypeDeclaration typeDeclaration, String realName, String defaultJavatypeName, boolean inline, List<V10GProperty> properties, List<V10GType> parentTypes) {
        super(realName);
        this.registry = registry;
        this.typeDeclaration = typeDeclaration;
        this.name = realName;
        this.defaultJavatypeName = defaultJavatypeName;
        this.inline = inline;
        this.properties = properties;
        this.parentTypes = parentTypes;
        if (this.isObject() && !this.name.equals("object")) {
            registry.addChildToParent(this.parentTypes(), this);
        }
    }

    @Override
    public TypeDeclaration implementation() {
        return this.typeDeclaration;
    }

    @Override
    public String type() {
        return this.typeDeclaration.type();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isObject() {
        return this.typeDeclaration instanceof ObjectTypeDeclaration;
    }

    @Override
    public List<V10GType> parentTypes() {
        return this.parentTypes;
    }

    @Override
    public List<V10GProperty> properties() {
        return this.properties;
    }

    @Override
    public TypeName defaultJavaTypeName(String pack) {
        if (this.isInline()) {
            return ClassName.get((String)"", (String)this.defaultJavatypeName, (String[])new String[0]);
        }
        return ClassName.get((String)pack, (String)this.defaultJavatypeName, (String[])new String[0]);
    }

    @Override
    public ClassName javaImplementationName(String pack) {
        if (this.isInline()) {
            return ClassName.get((String)"", (String)Annotations.IMPLEMENTATION_CLASS_NAME.get(this.defaultJavatypeName + "Impl", (Annotable)this.typeDeclaration, new Annotable[0]), (String[])new String[0]);
        }
        return ClassName.get((String)pack, (String)Annotations.IMPLEMENTATION_CLASS_NAME.get(this.defaultJavatypeName + "Impl", (Annotable)this.typeDeclaration, new Annotable[0]), (String[])new String[0]);
    }

    @Override
    public boolean isInline() {
        return this.inline;
    }

    @Override
    public Collection<V10GType> childClasses(String typeName) {
        return new HashSet<V10GType>(this.registry.getChildClasses().get((Object)typeName));
    }

    public String toString() {
        return "V10GType{input=" + this.typeDeclaration.name() + ":" + this.typeDeclaration.type() + ", name='" + this.name() + '\'' + '}';
    }

    @Override
    public void construct(final CurrentBuild currentBuild, GObjectType objectType) {
        objectType.dispatch(new GObjectType.GObjectTypeDispatcher(){

            @Override
            public void onPlainObject() {
                V10TypeFactory.createObjectType(V10GTypeObject.this.registry, currentBuild, V10GTypeObject.this, true);
            }
        });
    }
}

