/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10.types;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GObjectType;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.TypeUtils;
import org.raml.jaxrs.generator.v10.V10TypeRegistry;
import org.raml.jaxrs.generator.v10.types.V10GTypeHelper;
import org.raml.jaxrs.generator.v10.types.V10TypeFactory;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;

public class V10GTypeUnion
extends V10GTypeHelper {
    private final V10TypeRegistry registry;
    private final TypeDeclaration typeDeclaration;
    private final String name;
    private final String defaultJavatypeName;

    V10GTypeUnion(V10TypeRegistry registry, UnionTypeDeclaration typeDeclaration, String realName, String defaultJavatypeName) {
        super(realName);
        this.registry = registry;
        this.typeDeclaration = typeDeclaration;
        this.name = realName;
        this.defaultJavatypeName = defaultJavatypeName;
    }

    @Override
    public TypeDeclaration implementation() {
        return this.typeDeclaration;
    }

    @Override
    public String type() {
        return this.typeDeclaration.type();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isUnion() {
        return true;
    }

    @Override
    public TypeName defaultJavaTypeName(String pack) {
        if (this.isInline()) {
            return ClassName.get((String)"", (String)this.defaultJavatypeName, (String[])new String[0]);
        }
        return ClassName.get((String)pack, (String)this.defaultJavatypeName, (String[])new String[0]);
    }

    @Override
    public ClassName javaImplementationName(String pack) {
        if (this.isInline()) {
            return ClassName.get((String)"", (String)Annotations.IMPLEMENTATION_CLASS_NAME.get(this.defaultJavatypeName + "Impl", (Annotable)this.typeDeclaration, new Annotable[0]), (String[])new String[0]);
        }
        return ClassName.get((String)pack, (String)Annotations.IMPLEMENTATION_CLASS_NAME.get(this.defaultJavatypeName + "Impl", (Annotable)this.typeDeclaration, new Annotable[0]), (String[])new String[0]);
    }

    @Override
    public boolean isInline() {
        return TypeUtils.shouldCreateNewClass(this.typeDeclaration, this.typeDeclaration.parentTypes().toArray(new TypeDeclaration[0]));
    }

    public String toString() {
        return "V10GTypeUnion{input=" + this.typeDeclaration.name() + ":" + this.typeDeclaration.type() + ", name='" + this.name() + '\'' + '}';
    }

    @Override
    public void construct(final CurrentBuild currentBuild, GObjectType objectType) {
        objectType.dispatch(new GObjectType.GObjectTypeDispatcher(){

            @Override
            public void onUnion() {
                V10TypeFactory.createUnion(currentBuild, V10GTypeUnion.this.registry, V10GTypeUnion.this);
            }
        });
    }
}

