/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import com.google.common.collect.ArrayListMultimap;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.sun.codemodel.JCodeModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.Modifier;
import org.jsonschema2pojo.GenerationConfig;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.GFinder;
import org.raml.jaxrs.generator.GenerationException;
import org.raml.jaxrs.generator.GeneratorType;
import org.raml.jaxrs.generator.ResponseSupport;
import org.raml.jaxrs.generator.TypeFindingListener;
import org.raml.jaxrs.generator.builders.BuildPhase;
import org.raml.jaxrs.generator.builders.CodeContainer;
import org.raml.jaxrs.generator.builders.CodeModelTypeGenerator;
import org.raml.jaxrs.generator.builders.JavaPoetTypeGenerator;
import org.raml.jaxrs.generator.builders.TypeGenerator;
import org.raml.jaxrs.generator.builders.extensions.types.GsonExtension;
import org.raml.jaxrs.generator.builders.extensions.types.JavadocTypeLegacyExtension;
import org.raml.jaxrs.generator.builders.extensions.types.JaxbTypeExtension;
import org.raml.jaxrs.generator.builders.extensions.types.Jsr303Extension;
import org.raml.jaxrs.generator.builders.extensions.types.TypeExtensionList;
import org.raml.jaxrs.generator.builders.extensions.types.jackson.JacksonExtensions;
import org.raml.jaxrs.generator.builders.resources.ResourceGenerator;
import org.raml.jaxrs.generator.extension.resources.GlobalResourceExtension;
import org.raml.jaxrs.generator.extension.resources.ResourceClassExtension;
import org.raml.jaxrs.generator.extension.resources.ResourceMethodExtension;
import org.raml.jaxrs.generator.extension.resources.ResponseClassExtension;
import org.raml.jaxrs.generator.extension.resources.ResponseMethodExtension;
import org.raml.jaxrs.generator.extension.types.FieldExtension;
import org.raml.jaxrs.generator.extension.types.LegacyTypeExtension;
import org.raml.jaxrs.generator.extension.types.MethodExtension;
import org.raml.jaxrs.generator.extension.types.TypeExtension;
import org.raml.jaxrs.generator.ramltypes.GMethod;
import org.raml.jaxrs.generator.ramltypes.GResource;
import org.raml.jaxrs.generator.ramltypes.GResponse;
import org.raml.jaxrs.generator.v10.Annotations;
import org.raml.jaxrs.generator.v10.V10GMethod;
import org.raml.jaxrs.generator.v10.V10GResource;
import org.raml.jaxrs.generator.v10.V10GResponse;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.common.Annotable;

public class CurrentBuild {
    private final GFinder typeFinder;
    private final Api api;
    private final List<ResourceGenerator> resources = new ArrayList<ResourceGenerator>();
    private final Map<String, TypeGenerator> builtTypes = new ConcurrentHashMap<String, TypeGenerator>();
    private TypeExtensionList typeExtensionList = new TypeExtensionList();
    private Map<String, GeneratorType> foundTypes = new HashMap<String, GeneratorType>();
    private final List<JavaPoetTypeGenerator> supportGenerators = new ArrayList<JavaPoetTypeGenerator>();
    private Configuration configuration;
    private Set<JavaPoetTypeGenerator> implementations = new HashSet<JavaPoetTypeGenerator>();
    private ArrayListMultimap<JavaPoetTypeGenerator, JavaPoetTypeGenerator> internalTypesPerClass = ArrayListMultimap.create();

    public CurrentBuild(GFinder typeFinder, Api api) {
        this.typeFinder = typeFinder;
        this.api = api;
        this.configuration = Configuration.defaultConfiguration();
    }

    public Api getApi() {
        return this.api;
    }

    public String getResourcePackage() {
        return this.configuration.getResourcePackage();
    }

    public String getModelPackage() {
        return this.configuration.getModelPackage();
    }

    public String getSupportPackage() {
        return this.configuration.getSupportPackage();
    }

    public void generate(final File rootDirectory) throws IOException {
        if (this.resources.size() > 0) {
            ResponseSupport.buildSupportClasses(rootDirectory, this.getSupportPackage());
        }
        for (TypeGenerator typeGenerator : this.builtTypes.values()) {
            if (typeGenerator instanceof JavaPoetTypeGenerator) {
                this.buildTypeTree(rootDirectory, (JavaPoetTypeGenerator)typeGenerator);
                continue;
            }
            if (!(typeGenerator instanceof CodeModelTypeGenerator)) continue;
            CodeModelTypeGenerator b = (CodeModelTypeGenerator)typeGenerator;
            b.output(new CodeContainer<JCodeModel>(){

                @Override
                public void into(JCodeModel g) throws IOException {
                    g.build(rootDirectory);
                }
            });
        }
        for (ResourceGenerator resourceGenerator : this.resources) {
            resourceGenerator.output(new CodeContainer<TypeSpec>(){

                @Override
                public void into(TypeSpec g) throws IOException {
                    JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getResourcePackage(), (TypeSpec)g);
                    file.build().writeTo(rootDirectory);
                }
            });
        }
        for (JavaPoetTypeGenerator javaPoetTypeGenerator : this.supportGenerators) {
            javaPoetTypeGenerator.output(new CodeContainer<TypeSpec.Builder>(){

                @Override
                public void into(TypeSpec.Builder g) throws IOException {
                    JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getSupportPackage(), (TypeSpec)g.build());
                    file.build().writeTo(rootDirectory);
                }
            });
        }
    }

    private void buildTypeTree(final File rootDirectory, final JavaPoetTypeGenerator typeGenerator) throws IOException {
        JavaPoetTypeGenerator b = typeGenerator;
        b.output(new CodeContainer<TypeSpec.Builder>(){

            @Override
            public void into(final TypeSpec.Builder containing) throws IOException {
                for (JavaPoetTypeGenerator generator : CurrentBuild.this.internalTypesPerClass.get((Object)typeGenerator)) {
                    generator.output(new CodeContainer<TypeSpec.Builder>(){

                        @Override
                        public void into(TypeSpec.Builder g) throws IOException {
                            g.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
                            containing.addType(g.build());
                        }
                    }, BuildPhase.INTERFACE);
                }
                if (containing != null) {
                    JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getModelPackage(), (TypeSpec)containing.build());
                    file.build().writeTo(rootDirectory);
                }
            }
        }, BuildPhase.INTERFACE);
        if (this.implementations.contains(b)) {
            b.output(new CodeContainer<TypeSpec.Builder>(){

                @Override
                public void into(final TypeSpec.Builder containing) throws IOException {
                    for (JavaPoetTypeGenerator generator : CurrentBuild.this.internalTypesPerClass.get((Object)typeGenerator)) {
                        generator.output(new CodeContainer<TypeSpec.Builder>(){

                            @Override
                            public void into(TypeSpec.Builder g) throws IOException {
                                g.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
                                containing.addType(g.build());
                            }
                        }, BuildPhase.IMPLEMENTATION);
                    }
                    if (containing != null) {
                        JavaFile.Builder file = JavaFile.builder((String)CurrentBuild.this.getModelPackage(), (TypeSpec)containing.build());
                        file.build().writeTo(rootDirectory);
                    }
                }
            }, BuildPhase.IMPLEMENTATION);
        }
    }

    public LegacyTypeExtension withTypeListeners() {
        return this.typeExtensionList;
    }

    public void newGenerator(String ramlTypeName, TypeGenerator generator) {
        this.builtTypes.put(ramlTypeName, generator);
    }

    public void newSupportGenerator(JavaPoetTypeGenerator generator) {
        this.supportGenerators.add(generator);
    }

    public <T extends TypeGenerator> T getBuiltType(String ramlType) {
        TypeGenerator type = this.builtTypes.get(ramlType);
        if (type == null) {
            throw new GenerationException("no such type " + ramlType);
        }
        return (T)type;
    }

    public void newResource(ResourceGenerator rg) {
        this.resources.add(rg);
    }

    public void constructClasses() {
        TypeFindingListener listener = new TypeFindingListener(this.foundTypes);
        this.typeFinder.findTypes(listener);
        for (GeneratorType type : this.foundTypes.values()) {
            type.construct(this);
        }
    }

    public void newImplementation(JavaPoetTypeGenerator objectType) {
        this.implementations.add(objectType);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        for (String s : this.configuration.getTypeConfiguration()) {
            if (s.equals("jackson")) {
                this.typeExtensionList.addExtension(new JacksonExtensions());
            }
            if (s.equals("jaxb")) {
                this.typeExtensionList.addExtension(new JaxbTypeExtension());
            }
            if (s.equals("gson")) {
                this.typeExtensionList.addExtension(new GsonExtension());
            }
            if (s.equals("javadoc")) {
                this.typeExtensionList.addExtension(new JavadocTypeLegacyExtension());
            }
            if (!s.equals("jsr303")) continue;
            this.typeExtensionList.addExtension(new Jsr303Extension());
        }
    }

    public GenerationConfig getJsonMapperConfig() {
        return this.configuration.createJsonSchemaGenerationConfig();
    }

    private <T> T buildGlobalForCreate(T defaultValue) {
        if (this.configuration.getDefaultCreationExtension() != null) {
            try {
                return (T)this.configuration.getDefaultCreationExtension().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GenerationException(e);
            }
        }
        return defaultValue;
    }

    private GlobalResourceExtension buildGlobalForFinish() {
        if (this.configuration.getDefaultCreationExtension() != null) {
            try {
                return this.configuration.getDefaultFinishExtension().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new GenerationException(e);
            }
        }
        return GlobalResourceExtension.NULL_EXTENSION;
    }

    public TypeExtension getTypeExtension(Annotations<TypeExtension> typeExtensionAnnotation, V10GType type) {
        return typeExtensionAnnotation.get((Annotable)this.getApi(), new Annotable[]{type.implementation()});
    }

    public MethodExtension getMethodExtension(Annotations<MethodExtension> methodExtensionAnnotations, V10GType type) {
        return methodExtensionAnnotations.get((Annotable)this.getApi(), new Annotable[]{type.implementation()});
    }

    public FieldExtension getFieldExtension(Annotations<FieldExtension> fieldExtensionAnnotations, V10GType type) {
        return fieldExtensionAnnotations.get((Annotable)this.getApi(), new Annotable[]{type.implementation()});
    }

    public ResourceMethodExtension<GMethod> getResourceMethodExtension(Annotations<ResourceMethodExtension<GMethod>> onResourceMethodExtension, GMethod gMethod) {
        if (gMethod instanceof V10GMethod) {
            return onResourceMethodExtension.get((Annotable)this.getApi(), new Annotable[]{((V10GMethod)gMethod).implementation()});
        }
        return onResourceMethodExtension == Annotations.ON_METHOD_CREATION ? this.buildGlobalForCreate(GlobalResourceExtension.NULL_EXTENSION) : this.buildGlobalForFinish();
    }

    public ResourceClassExtension<GResource> getResourceClassExtension(ResourceClassExtension<GResource> defaultClass, Annotations<ResourceClassExtension<GResource>> onResourceClassCreation, GResource topResource) {
        if (topResource instanceof V10GResource) {
            ArrayList<ResourceClassExtension<GResource>> list = new ArrayList<ResourceClassExtension<GResource>>();
            list.add(defaultClass);
            list.add(onResourceClassCreation.get((Annotable)this.getApi(), new Annotable[]{((V10GResource)topResource).implementation()}));
            return new ResourceClassExtension.Composite((List<ResourceClassExtension<GResource>>)list);
        }
        return onResourceClassCreation == Annotations.ON_RESOURCE_CLASS_CREATION ? this.buildGlobalForCreate(defaultClass) : this.buildGlobalForFinish();
    }

    public ResponseClassExtension<GMethod> getResponseClassExtension(Annotations<ResponseClassExtension<GMethod>> onResponseClassCreation, GMethod gMethod) {
        if (gMethod instanceof V10GMethod) {
            return onResponseClassCreation.get((Annotable)this.getApi(), new Annotable[]{((V10GMethod)gMethod).implementation()});
        }
        return onResponseClassCreation == Annotations.ON_RESPONSE_CLASS_CREATION ? this.buildGlobalForCreate(GlobalResourceExtension.NULL_EXTENSION) : this.buildGlobalForFinish();
    }

    public ResponseMethodExtension<GResponse> getResponseMethodExtension(Annotations<ResponseMethodExtension<GResponse>> onResponseMethodExtension, GResponse gResponse) {
        if (gResponse instanceof V10GResponse) {
            return onResponseMethodExtension.get((Annotable)this.getApi(), new Annotable[]{((V10GResponse)gResponse).implementation()});
        }
        return onResponseMethodExtension == Annotations.ON_RESPONSE_METHOD_CREATION ? this.buildGlobalForCreate(GlobalResourceExtension.NULL_EXTENSION) : this.buildGlobalForFinish();
    }

    public void internalClass(JavaPoetTypeGenerator simpleTypeGenerator, JavaPoetTypeGenerator internalGenerator) {
        this.internalTypesPerClass.put((Object)simpleTypeGenerator, (Object)internalGenerator);
    }
}

