/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator;

import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GObjectType;
import org.raml.jaxrs.generator.ramltypes.GType;

public class GeneratorType {
    private final GObjectType objectType;
    private final GType declaredType;

    public static GeneratorType generatorFrom(GType typeDeclaration) {
        if (typeDeclaration.isJson()) {
            return new GeneratorType(GObjectType.JSON_OBJECT_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isUnion()) {
            return new GeneratorType(GObjectType.UNION_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isXml()) {
            return new GeneratorType(GObjectType.XML_OBJECT_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isObject()) {
            return new GeneratorType(GObjectType.PLAIN_OBJECT_TYPE, typeDeclaration);
        }
        if (typeDeclaration.isEnum()) {
            return new GeneratorType(GObjectType.ENUMERATION_TYPE, typeDeclaration);
        }
        return new GeneratorType(GObjectType.SCALAR, typeDeclaration);
    }

    public GeneratorType(GObjectType objectType, GType declaredType) {
        this.objectType = objectType;
        this.declaredType = declaredType;
    }

    public GType getDeclaredType() {
        return this.declaredType;
    }

    public GObjectType getObjectType() {
        return this.objectType;
    }

    public void construct(CurrentBuild currentBuild) {
        if (this.getObjectType() != GObjectType.SCALAR) {
            this.declaredType.construct(currentBuild, this.objectType);
        }
    }
}

