/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.builders;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.jaxrs.generator.GenerationException;
import org.xml.sax.SAXParseException;

public class JAXBHelper {
    public static File saveSchema(String schema) throws IOException {
        File tmpFile = File.createTempFile("schema", ".xml");
        FileWriter tmp = new FileWriter(tmpFile);
        tmp.write(schema);
        tmp.close();
        return tmpFile;
    }

    public static Map<String, JClass> generateClassesFromXmlSchemas(String pack, File file, JCodeModel codeModel) throws GenerationException {
        HashMap<String, JClass> classNameToKeyMap = new HashMap<String, JClass>();
        List<JDefinedClass> classes = JAXBHelper.generateClassesFromXmlSchemas(pack, codeModel, file);
        for (JDefinedClass aClass : classes) {
            String className = aClass.name();
            classNameToKeyMap.put(className, (JClass)aClass);
        }
        return classNameToKeyMap;
    }

    private static List<JDefinedClass> generateClassesFromXmlSchemas(String pack, JCodeModel codeModel, File schemaFile) throws GenerationException {
        try {
            ArrayList<JDefinedClass> classList = new ArrayList<JDefinedClass>();
            ArrayList<String> argList = new ArrayList<String>();
            argList.add("-mark-generated");
            argList.add("-p");
            argList.add(pack);
            argList.add(schemaFile.getAbsolutePath());
            String[] args = argList.toArray(new String[argList.size()]);
            final Options opt = new Options();
            opt.setSchemaLanguage(Language.XMLSCHEMA);
            opt.parseArguments(args);
            ErrorReceiverFilter receiver = new ErrorReceiverFilter(){

                public void info(SAXParseException exception) {
                    if (opt.verbose) {
                        super.info(exception);
                    }
                }

                public void warning(SAXParseException exception) {
                    if (!opt.quiet) {
                        super.warning(exception);
                    }
                }
            };
            Model model = ModelLoader.load((Options)opt, (JCodeModel)codeModel, (ErrorReceiver)receiver);
            Outline outline = model.generateCode(opt, (ErrorReceiver)receiver);
            for (ClassOutline co : outline.getClasses()) {
                JDefinedClass cl = co.implClass;
                if (cl.outer() != null) continue;
                classList.add(cl);
            }
            return classList;
        }
        catch (Exception e) {
            throw new GenerationException(e);
        }
    }
}

